/***************************************************************************/
/* Ŀ */
/*  NOMBRE DEL FICHERO: VIDEO.CPP                                        */
/*  DESCRIPCION:        Implementacin de clases y funciones para tra-   */
/*                      tamiento de video.                               */
/*  CONTENIDO:          .definicin de variables locales al mdulo.      */
/* 			 .metodos de la clase paleta256.                  */
/*                      .funciones video VGA.                            */
/*                      .funciones video SVGA (modos VESA).              */
/*  LLAMADO POR:        ---                                              */
/*  LLAMA A:            VIDEO.H: Fichero cabecera. Definiciones          */
/*                                                                       */
/*  PROGRAMADO POR:     Juan Manuel Sanchez Cervantes.                   */
/*  FECHA:              07/3/1995                                        */
/*  ACTUALIZACIONES:    ---                                              */
/*  */
/***************************************************************************/
#include "video.h"

/*** DEFINICION DE VARIABLES LOCALES AL MODULO *****************************/
/***************************************************************************/
int desplazaV=0;      //Desplazamiento de la ventana de acceso VESA.

/***************************************************************************/
/*   CLASE PALETA256: IMPLEMENTACION DE METODOS.                           */
/***************************************************************************/
paleta256::paleta256(void){
   paleta = new char[768];
};
/***************************************************************************/
void paleta256::actualizarDAC(void){
   char far *P;

   P=paleta;
   asm{ mov ah,10h
	mov al,12h
	mov bx,0h
	mov cx,256
	les dx,P
	int 10h
   };
};
/***************************************************************************/
char paleta256::cargar(char far *fichero, char modo){
   int etiqueta;
   int result;

   if(modo==0){
      etiqueta=_open(fichero,O_BINARY);
      if(etiqueta>=0){
	 result=_read(etiqueta,paleta,768);
	 _close(etiqueta);
	 if(result<0) return(0);
	 return(1);
      }
      else return(-1);
   }
   else{
      etiqueta=_open(fichero,O_BINARY);
      if(etiqueta>=0){
	 result=_read(etiqueta,paleta,768);
	 _close(etiqueta);
	 if(result<0) return(0);
	 return(1);
      }
      else return(-1);
   };
};
/***************************************************************************/
void paleta256::putColor(int n, char R, char G, char B){
   n=n*3;
   paleta[n]=R;
   paleta[n+1]=G;
   paleta[n+2]=B;
};
/***************************************************************************/
void paleta256::getColor(int n, char *R, char *G, char *B){
   n=n*3;
   *R=paleta[n];
   *G=paleta[n+1];
   *B=paleta[n+2];
};
/***************************************************************************/
void paleta256::putGris(int n, char Gris){
   n=n*3;
   paleta[n]=Gris;
   paleta[n+1]=Gris;
   paleta[n+2]=Gris;
};
/***************************************************************************/
paleta256::~paleta256(void){
   delete paleta;
};


/***************************************************************************/
/*   FUNCIONES INICIALIZACION VIDEO. TARGETA VGA.                          */
/***************************************************************************/
void ModoTexto(void){
   asm{ mov AX, 3
	int 16
   }
};
/***************************************************************************/
void Modo320200256(void){
   asm{ mov AX, 13h
	int 10h
   }
};
/***************************************************************************/
void Modo64048016(void){
   asm{ mov AH, 00h
	mov AL, 12h
	int 10h
   }
};

/***************************************************************************/
/*   FUNCIONES DE VIDEO ESTANDAR VESA. TARGETA SUPER-VGA.     Vdeo.       */
/*                                                            Electronic.  */
/*                                                            Standards.   */
/*                                                            Association. */
/***************************************************************************/
char LeerFuncionesVesa(char far *tabla){

   asm{ mov AH, 4fh      //AH <-- Funcin 4Fh
	mov AL, 00h      //AL <-- Subfuncin 00h
	les DI, tabla    //ES:DI <-- tabla
	int 10h          //Interrupcin 10h
	cmp AH, 00h      //Compara [AH] con 0
	jne Negativo     //Si no son iguales bifurcar a Negativo
	cmp AL, 4Fh      //Compara [AL] con 4Fh
	jne Negativo     //Si no son iguales bifurcar a Negativo
   };
   return(1);            //Se soportan funciones VESA.
   Negativo: return(0);  //No se soportan funciones VESA.
};
/***************************************************************************/
char LeerModoVesa(int modo, char far *tabla){

   asm{ mov AH, 4Fh      //AH <-- Funcin 4Fh
	mov AL, 01h      //AL <-- Subfuncin 01h
	mov CX, modo     //CX <-- modo
	les DI, tabla    //ES:DI <-- tabla
	int 10h          //Interrupcin 10h
	cmp AH, 00h      //Compara [AH] con 0
	jne Negativo     //Si no son iguales bifurcar a Negativo
	cmp AL, 4Fh      //Compara [AL] con 4Fh
	jne Negativo     //Si no son iguales bifurcar a Negativo
   };
   return(1);            //Se soporta este modo VESA.
   Negativo: return(0);  //No se soporta este modo VESA.
};
/***************************************************************************/
void CalcularDesplazaV(int modo){
   char far *tabla;
   char granularidad;

   tabla = new char[29];
   asm{	mov AH, 4Fh      //AH <-- Funcin 4Fh
	mov AL, 01h      //AL <-- Subfuncin 01h
	mov CX, modo     //CX <-- modo
	les DI, tabla    //ES:DI <-- tabla
	int 10h          //Interrupcin 10h
   };
   granularidad = tabla[4];
   desplazaV = (64/granularidad);
   delete tabla;
};
/***************************************************************************/
char Modo640400256(void){

   asm{ mov AH, 4Fh      //AH <-- Funcin 4Fh
	mov AL, 02h      //AL <-- Subfuncin 02h
	mov BX, 100h     //BX <-- 100h, modo requerido
	int 10h          //Interrupcin 10h
	cmp AH, 00h      //Compara [AH] con 0
	jne Negativo     //Si no son iguales bifurcar a Negativo
	cmp AL, 4Fh      //Compara [AL] con 4Fh
	jne Negativo     //Si no son iguales bifurcar a Negativo
   };
   if(!desplazaV) CalcularDesplazaV(0x100);
   return(1);            //Se ha inicializado el modo 100h de VESA.
   Negativo: return(0);  //La funcin no se ejecut adecuadamente.
};
/***************************************************************************/
char Modo640480256(void){

   asm{ mov AH, 4fh      //AH <-- Funcin 4Fh
	mov AL, 02h      //AL <-- Subfuncin 02h
	mov BX, 101h     //BX <-- 101h, modo requerido
	int 10h          //Interrupcin 10h
	cmp AH, 00h      //Compara [AH] con 0
	jne Negativo     //Si no son iguales bifurcar a Negativo
	cmp AL, 4Fh      //Compara [AL] con 4Fh
	jne Negativo     //Si no son iguales bifurcar a Negativo
   };
   if(!desplazaV) CalcularDesplazaV(0x101);
   return(1);            //Se ha inicializadoel modo 101h de VESA.
   Negativo: return(0);  //La funcin no se ejecut adecuadamente.
};
/***************************************************************************/
/* ATENCION!!, TODA LA DOCUMENTACION EN EL FICHERO CABECERA  VIDEO.H     */
/***************************************************************************/
/* F I N *******************************************************************/
