;****************************************************************************
; Filename: MK_FP.ASM
;   Author: Peter Andersson
;  Version: 0.1
;  Created: 1994.09.18
;  Updated: 1995.03.11
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: PVOID @MK_FP(PVOID address)
;  Comment: Converts an 32 bit address to a segment:offset
;    input: Eax - address to convert
;  Returns: Segment address in the higher part of Eax and the offset address
;           in the lower part of Eax (Ax). Eax is -1 if the memory address
;           is out of range (>=1Mb)
;****************************************************************************

	Include	STDDEF.INC

	Codeseg

Proc	MK_FP   ,1
		Sub	Eax,[_zero]
		Cmp	Eax,100000h		; Can't convert address above
		Jae	@@Error			; 1Mb or below 0...
		Mov	Edx,Eax
		And	Eax,0FFFF0h
		And	Edx,0Fh
		Shl	Eax,12
		Add	Eax,Edx
		Ret
	Align	4
@@Error:	Mov	Eax,-1
		Ret
Endp

	End
