;****************************************************************************
;*	Ce module permet de charger des fichiers au format MOD
;*	Comme toutes les fonctions de ce projet on utilise la convention
;*	d'appel pascal
;*
;* Programm par Sbastien Granjoux
;* Commenc le 24/12/94
;* Modification le 02/01/95

IDEAL
P386N

PUBLIC	LOADMOD


INCLUDE "CRYSERR.INC"
INCLUDE "CRYSLOAD.INC"

SEGMENT CSEG PARA PUBLIC USE16 'CODE'

ASSUME	cs:CSEG

MODFLAGPOS	EQU     438h

AmigaNote       DW  1B88h,1D28h,1EE0h,20B0h,22A0h,24B0h
		DW  26E0h,2930h,2BB0h,2E50h,3110h,3400h
		DW  8000h
;***************************************************************************
;*	Charge un fichier MOD en mmoire
;*
;* Entre:
;*	DS:DX	adresse longue du nom du fichier mod
;*	CS:BX	adresse du driver de fichier utilis
;*
;* Sortie:
;*	AX	code d'erreur si C=1 et AX diffrent de zero
;*

PROC    loadmod FAR
LOCAL	nbinst:BYTE,nbmodvoice:BYTE,patsize:WORD=locvar

	push	ds
	push	es
	push	si
	push	di

	enter	locvar,0

	lds	dx,[ss:bp+14]	; Ouverture du fichier mod
	call	open
	jc      @@error

	call	clearmod	; Reinitialisation des instruments
	jc	@@error

	xor	cx,cx		; Test du type de mod
	mov	dx,MODFLAGPOS
	call	seek
	jc	@@error

	mov	cx,4
	mov	dx,OFFSET Comments
	call	read
	jc	@@error

	mov	cx,0FFFFh
	mov	dx,-(MODFLAGPOS+4)
	call	seek
	jc	@@error

	mov	[nbmodvoice],4
	mov	[nbinst],15
	cmp	[dword ptr ds:OFFSET Comments],'.K.M'
	je	@@mod31
	cmp	[dword ptr ds:OFFSET Comments],'!K!M'
	je	@@mod31
	cmp	[dword ptr ds:OFFSET Comments],'4TLF'
	je	@@mod31
	cmp	[dword ptr ds:OFFSET Comments],'NHC4'
	je	@@mod31
	cmp	[dword ptr ds:OFFSET Comments],'NHC6'
	je	@@mod6
	cmp	[dword ptr ds:OFFSET Comments],'8TLF'
	je	@@mod8
	cmp	[dword ptr ds:OFFSET Comments],'ATCO'
	je	@@mod8
	cmp	[dword ptr ds:OFFSET Comments],'NHC8'
	je	@@mod8
	cmp	[word ptr ds:OFFSET Comments+2],'HC'
	jne	@@loadheader
@@modxx:
	mov	ax,[word ptr ds:OFFSET Comments]
	sub	ax,'00'
	shl	al,1
	add	ah,al
	shl	al,2
	add	ah,al
	cmp	ah,32
	ja	@@loadheader
	mov	[nbmodvoice],ah
	jmp	@@mod31

@@mod8:
	add	[nbmodvoice],2
@@mod6:
	add	[nbmodvoice],2
@@mod31:
	add	[nbinst],16
@@loadheader:

	mov	cx,20			; Lecture du nom de la musique
	mov	dx,OFFSET Comments
	call	read
	jc	@@error
	mov	[byte ptr ds:OFFSET Comments+20],0

	mov	cl,[nbinst]		; Lecture des instruments
	mov	di,OFFSET Instrument1+SIZE INSTRUMENT
	mov	si,OFFSET Comments+32
@@next_inst:
	push	cx

	mov	cx,30			; Lecture d'un instrument
	mov	dx,si
	call	read
	jc	@@error

	movzx	eax,[word ptr ds:si+22]	; Recupre sa taille
	rol	ax,8
	cmp	ax,1
	jbe	@@no_inst
	mov	dx,ax
	add	eax,eax
	mov	[(INSTRUMENT PTR ds:di).endadr],eax

	movzx	eax,[word ptr ds:si+28]	; Recupre la longueur du repeat
	rol	ax,8
	cmp	ax,1
	ja	@@true_rep
	xor	ax,ax
@@true_rep:
	cmp	ax,dx
	jbe	@@lenrepok
	mov	ax,dx
@@lenrepok:
	add	eax,eax
	mov	[(INSTRUMENT PTR ds:di).replen],eax

	xor	ax,ax			; Fixe l'adresse de segment
	mov	[(INSTRUMENT PTR ds:di).adrseg],ax

	mov	al,[ds:si+25]		; Fixe le volume (0  63)
	cmp	al,64
	cmc
	sbb	al,0
	mov	[(INSTRUMENT PTR ds:di).volume],al

@@no_inst:
	add	di,SIZE INSTRUMENT

	mov	[byte ptr ds:si+22],0	; Marque la fin du nom de l'instrument
	add	si,32
	pop	cx
	dec	cl
	jne	@@next_inst

	mov	si,OFFSET Sequence+512-130	; Lecture de la sequence
	mov	dx,si
	mov	cx,130
	call	read
	jc	@@error

	cmp	[nbinst],15	; Saute le flag si il existait
	je	@@no_flag
	xor	cx,cx
	mov	dx,4
	call	seek
	jc	@@error
@@no_flag:

	push	ds   	; Remet la squence on format attendus par le player
	pop	es
	xor	bx,bx
	mov     cl,128 ; pour certain mod [ds:si] n'est pas significatif (PRELUDE)
	mov	di,OFFSET Sequence
	lodsw
	push	ax
@@nb_pattern:
	lodsb
	mul	[nbmodvoice]
	shl	ax,4
	cmp     bx,ax
	jae     @@no_new_pattern
	mov     bx,ax
@@no_new_pattern:
	stosw
	dec     cl
	jne     @@nb_pattern

	movzx	ax,[nbmodvoice]	; Reserve la place pour les patterns
	shl	ax,4
	add	bx,ax
	mov	[patsize],bx
	call	allocpat
	jc      @@error
	mov	[ds:FirstPatAdr],ebx
	mov	[ds:PatternSeg],dx
	mov	[ds:PatternType],al

	pop	cx
	mov     si,OFFSET Sequence
@@changepat:
	add	[word ptr ds:si],dx
	add	si,2
	dec	cl
	jne	@@changepat
	mov	[ds:LastPos],si

	push	es
	pop	ds
	push	cs		; Lecture et conversion des patterns
	pop	es

	mov	cx,64		; lecture en 64 fois
	mov	si,di
@@readpat:

	push	cx		; Lecture d'un bout de pattern
	mov	cx,[patsize]
	shr	cx,2
	mov	dx,si

	call	read
	jc	@@error

	mov	cx,[patsize]
	shr	cx,4
@@changepos:
	lodsd
	rol	ax,8
	mov	dx,ax
	and	dx,0FFFh
	je	@@nonote
	mov	di,OFFSET AmigaNote	; Conversion de la note
	mov	al,0FCh
@@search_oct:
	add	al,10h
	add	dx,dx
	cmp     dx,[es:di]
	jb	@@search_oct
@@search_note:
	add	di,2
	dec	al
	cmp	dx,[es:di]
	ja	@@search_note
	add	al,al
@@nonote:

	ror	eax,8		; Conversion de l'instrument
	shr	al,4
	rol	ax,4
	rol	eax,8
	shr	ax,1
	mov	[ds:si-4],ax

	shr	eax,16		; Conversion des effets
	shr	al,1
	call	@@convert_speed
	call	@@convert_pat_break
	mov	[ds:si-2],ax

	loop	@@changepos

	pop	cx
	push	cx
	push	es
	push	ds
	pop	es
	pop	ds
	mov	ax,[patsize]
	shr	ax,2
	sub	cx,65
	neg	cx
	mul	cx
	mov	bx,ax
	shl	ebx,16
	mov	bx,dx
	ror	ebx,16
	call	seekblk
	mov	si,di
	push	es
	push	ds
	pop	es
	pop	ds

	pop	cx
	dec	cx
	jne	@@readpat

	push	es
	pop	ds
	movzx	ecx,[patsize]
	shl	ecx,4
	call	copymem

	mov	ax,SEG Instrument1
	mov	ds,ax
	mov	si,OFFSET Instrument1+SIZE INSTRUMENT
	mov     cl,[nbinst]           ;lecture des samples
@@sample:
	push	cx
	cmp	[(INSTRUMENT PTR ds:si).adrseg],0
	jne	@@no_sample

	push	ds
	mov     ebx,[(INSTRUMENT PTR ds:si).endadr]
	push	ebx
	add	ebx,SAMPLE_BORDER+MIN_REPEAT+16  ;bien 16  cause du inc ebx
	shr	ebx,4				 ; si pas de loop
	call	allocsamp
	jc	@@error

	mov	[(INSTRUMENT PTR ds:si).sampadr],ebx
	add	[(INSTRUMENT PTR ds:si).endadr],ebx
	mov	[(INSTRUMENT PTR ds:si).adrseg],dx
	mov	[(INSTRUMENT PTR ds:si).type],al

	push	es
	pop	ds
	pop	ebx
	cmp	ebx,MAX_BLOCK
	jbe	@@read_last
@@read_next:
	mov	ecx,MAX_BLOCK
	sub	ebx,ecx
	push	ebx
	mov	dx,di
	call	read
	jc	@@error
	call	nextmem
	push	es
	pop	ds
	pop	ebx
	cmp	ebx,MAX_BLOCK
	ja	@@read_next

@@read_last:
	mov	cx,bx
	mov	dx,di
	call	read
	jc	@@error

	pop	ds
	mov	ebx,[(INSTRUMENT PTR ds:si).endadr]
	sub	ebx,[(INSTRUMENT PTR ds:si).sampadr]
	sub	ebx,[(INSTRUMENT PTR ds:si).replen]
	call	seekblk

	mov	ebx,[(INSTRUMENT PTR ds:si).endadr]
	sub	ebx,[(INSTRUMENT PTR ds:si).sampadr]
	cmp	[(INSTRUMENT PTR ds:si).replen],2
	ja	@@true_loop
	mov	[byte ptr es:di],SILENT
	add	[(INSTRUMENT PTR ds:si).endadr],MIN_REPEAT
	mov	[(INSTRUMENT PTR ds:si).replen],MIN_REPEAT
	inc	ebx
@@true_loop:

	push	ds
	push	si
	push	es
	pop	ds
	mov	si,di
	call	seekblk

	mov	cx,MIN_REPEAT+SAMPLE_BORDER
	rep	movsb
	pop	si
	pop	ds

	mov	ecx,[(INSTRUMENT PTR ds:si).endadr]
	sub	ecx,[(INSTRUMENT PTR ds:si).sampadr]
	call	copymem
	jc	@@error

@@no_sample:
	add     si,SIZE INSTRUMENT
	pop	cx
	dec     cl
	jne     @@sample

	call	close
	jc      @@error

	mov	al,[nbmodvoice]
	mov	[NbVoice],al
	mov	al,6
	mov	[Tempo],al
	mov	al,125
	mov	[Bpm],al

	call	ResetMod
	jc	@@error

	xor	ax,ax
	jmp	@@ok
@@error:
	push	ax
	call	close
	call	UNLOADMOD
	pop	ax
	stc
@@ok:
	leave
	pop	di
	pop	si
	pop	es
	pop	ds
	ret	4

@@convert_speed:

	cmp	al,78h
	jne	@@no_speed
	cmp	ah,1Fh
	jbe	@@no_speed
	add	al,8
@@no_speed:
	retn

@@convert_pat_break:
	cmp	al,68h
	jne	@@no_break
	mov	dl,ah
	and	dl,0F0h
	add	dl,dl
	add	dl,ah
	rcr	dl,1
	shr	dl,2
	and	dl,0FEh
	sub	ah,dl
@@no_break:
	retn
ENDP

ENDS
END

