;*************************************************************************
;*	Quelques routines graphiques pour travailler en mode texte  80*25
;*	 en 16 couleurs
;* Programm par Sbastien Granjoux
;* Commenc le 26/12/93
;* Dernire modification le 26/12/93

IDEAL

P386N
MODEL	SMALL

PUBLIC	setmode
PUBLIC	resetmode
PUBLIC	puttxt
PUBLIC	putbar

VIDEO_MOD	EQU	3
LEN_LINE	EQU	160
VIDEO_SEG	EQU	0b800h

DATASEG

Oldmode	DB ?


CODESEG

;*************************************************************************
;*	Initialise le mode texte
;*	ES contient le segment vido du mode graphique 3

PROC    setmode

	mov     ah,0fh          ; sauve l'ancien mode
	int     10h
	mov     [byte ptr ds:OFFSET Oldmode],al

	mov     ax,VIDEO_MOD      ; passe en mode 3
	int     10h

	mov	ax,VIDEO_SEG
        mov	es,ax

	mov	dx,3d4h
	mov	ax,1f0ah
	out	dx,ax

	ret

ENDP

;***************************************************************************
;*      Reprend le mode avant le dernier setmode

PROC    resetmode

	xor     ah,ah
	mov     al,[byte ptr ds:OFFSET Oldmode]
	int     10h

	ret

ENDP

;*************************************************************************
;*	Affiche  l'cran une chaine de caractre avec l'attribut spcifi
;*
;* Entre:
;*	DL	coordonn X du dbut de la chaine
;*	DH	coordonn Y du dbut de la chaine
;*	DS:SI	adresse de la chaine
;*	ES	segment video de la mmoire cran
;*	AH	attribut de la chaine

PROC	puttxt

	xor	edi,edi
	mov	di,dx
	shr	di,8
	lea	di,[edi*4+edi]
	shl	di,4
	and	dx,00ffh
	add	di,dx
	shl	di,1

	lodsb
@@next_char:
	stosw
	lodsb
	or	al,al
	jne	@@next_char

	ret

ENDP

;*************************************************************************
;*	Affiche une ligne horizontal avec le caractre AL de longueur CL
;*	en dl,dh
;*
;* Entre:
;*	AL	caractre  afficher
;*	CH	longueur de la ligne
;*	DL	coordonne x du dbut
;*	DH	coordonne y du dbut

PROC	putbar

	xor	edi,edi
	mov	di,dx
	shr	di,8
	lea	di,[edi*4+edi]
	shl	di,4
	and	dx,00ffh
	add	di,dx
	shl	di,1

	mov	ah,0ah

	mov	cl,10
@@next_char:
	dec	ch
	jns	@@ok
	mov	al,' '
@@ok:
	stosw
	dec	cl
	jne	@@next_char

	mov	ah,14
	mov	cl,4
@@next_char2:
	dec	ch
	jns	@@ok2
	mov	al,' '
@@ok2:
	stosw
	dec	cl
	jne	@@next_char2

	mov	ah,12
	mov	cl,2
@@next_char3:
	dec	ch
	jns	@@ok3
	mov	al,' '
@@ok3:
	stosw
	dec	cl
	jne	@@next_char3

	ret

ENDP

END