#include <math.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <mem.h>
#include <stdlib.h>

#include <wgt5.h>
#include <wgtscrol.h>

/* Textured Plane
   Written by Chris Egerter
   Placed in the public domain on October 1, 1995

   Uses a 1024x1024 bitmap as a texture map.   It is built at run time using
   a 32x32 tiled map (using 32x32 pixel tiles).

   Note that the map routines are only availabe from the registered version
   of WGT 5.1.  If you don't have it (why not?) you should modify the
   build_map routine to draw whatever you like on the 1024x1024 bitmap.

   */

//#define USE_VIRTUAL 1
/* Uncomment to use a virtual screen instead of writing directly onto
   the VGA ram. */


/* Keyboard defines */
#define KEY_UP 0x48
#define KEY_DOWN 0x50
#define KEY_LEFT 0x4B
#define KEY_RIGHT 0x4D
#define KEY_W 0x11
#define KEY_S 0x1F
#define KEY_E 0x12
#define KEY_D 0x20
#define KEY_R 0x13
#define KEY_F 0x21
#define KEY_T 0x14
#define KEY_G 0x22
#define KEY_F1 0x3B
#define KEY_F2 0x3C
#define KEY_F3 0x3D
#define KEY_CTRL 0x1D

/* General graphics info */
block ground;
color pal[256];
color pal2[256];
block virt;
block shadeptrasm;
unsigned char *shades;
block groundpic;

/* View Variables */
unsigned short rowoffset;
int shading_factor = 200;
int shading_on = 0;
unsigned int playerx;
unsigned int playery;
int playerangle;
int playerspeed;
int playercos;
int playersin;
int jumpheight = 0;
int jumpdir;
int elevation = 255360;
int inclination = 8;
int view_height = 130;
int view_width;
int viewcone = 45;
int x,y;
int draw_routine;

/* Map Variables */
wgtmap roadmap;
block tiles[256];
int tiletypes[256];
scrollsprite wobjects[30];

/* Detail levels */
#define LOW_DETAIL 0
#define LOW_WIDTH 80
#define MEDIUM_DETAIL 1
#define MEDIUM_WIDTH 160
#define HIGH_DETAIL 2
#define HIGH_WIDTH 320
#define PIXPREC 16
#define PIXPREC2 65536L


/* Tables */
int isin[360];
int icos[360];


/* Table creation */
void p_create_sincos (void)
{
int i;
float realangle;

 for (i = 0; i < 360; i++)
   {
    realangle = i / 180.0 * 3.14153254234216;
    icos[i] = cos(realangle) * PIXPREC2;
    isin[i] =  sin(realangle) * PIXPREC2;
   }
}



int gxstep, gystep;

void draw_mode7_linel (unsigned long ax, unsigned long ay, block temp);
#pragma aux draw_mode7_linel = \
  "push ebp" \
  "mov ecx, 80" \
  "mov esi, ground" \
  "add esi, 4" \
  "D1: mov edx, eax" \
  "shr edx, 22" \
  "mov ebp, edx" \
  "mov edx, ebx" \
  "shr edx, 12" \
  "and edx, 4294966272" \
  "add ebp, edx" \
  "mov dl, [esi + ebp]" \
  "mov dh, dl" \
  "mov bp, dx" \
  "shl edx, 16" \
  "mov dx, bp" \
  "mov [edi], edx" \
  "add eax, gxstep" \
  "add ebx, gystep" \
  "add edi, 4" \
  "dec ecx" \
  "jnz D1" \
  "pop ebp" \
parm [eax] [ebx] [edi] \
modify exact [eax ebx ecx edx esi edi gs] nomemory;


void draw_mode7_linem (unsigned long ax, unsigned long ay, block temp);
#pragma aux draw_mode7_linem = \
  "push ebp" \
  "mov ecx, 160" \
  "mov esi, ground" \
  "add esi, 4" \
  "D1: mov edx, eax" \
  "shr edx, 22" \
  "mov ebp, edx" \
  "mov edx, ebx" \
  "shr edx, 12" \
  "and edx, 4294966272" \
  "add ebp, edx" \
  "mov dl, [esi + ebp]" \
  "mov dh, dl" \
  "mov [edi], dx" \
  "add eax, gxstep" \
  "add ebx, gystep" \
  "add edi, 2" \
  "dec ecx" \
  "jnz D1" \
  "pop ebp" \
parm [eax] [ebx] [edi] \
modify exact [eax ebx ecx edx esi edi] nomemory;

void draw_mode7_lineh (unsigned long ax, unsigned long ay, block temp);
#pragma aux draw_mode7_lineh = \
  "push ebp" \
  "mov ecx, view_width" \
  "mov esi, ground" \
  "add esi, 4" \
  "D1: mov edx, eax" \
  "shr edx, 22" \
  "mov ebp, edx" \
  "mov edx, ebx" \
  "shr edx, 12" \
  "and edx, 4294966272" \
  "add ebp, edx" \
  "mov dl, [esi + ebp]" \
  "mov [edi], dl" \
  "add eax, gxstep" \
  "add ebx, gystep" \
  "inc edi" \
  "dec ecx" \
  "jnz D1" \
  "pop ebp" \
parm [eax] [ebx] [edi] \
modify exact [eax ebx ecx edx esi edi] nomemory;


void draw_shaded_linel (unsigned long ax, unsigned long ay, block temp);
#pragma aux draw_shaded_linel = \
  "push ebp" \
  "mov ecx, 80" \
  "mov esi, ground" \
  "add esi, 4" \
  "D1: mov edx, eax" \
  "shr edx, 22" \
  "mov ebp, edx" \
  "mov edx, ebx" \
  "shr edx, 12" \
  "and edx, 4294966272" \
  "add ebp, edx" \
  "xor edx, edx" \
  "mov dl, [esi + ebp]" \
  "mov ebp, shadeptrasm"\
  "mov dl, [edx + ebp]" \
  "mov dh, dl" \
  "mov bp, dx" \
  "shl edx, 16" \
  "mov dx, bp" \
  "mov [edi], edx" \
  "add eax, gxstep" \
  "add ebx, gystep" \
  "add edi, 4" \
  "dec ecx" \
  "jnz D1" \
  "pop ebp" \
parm [eax] [ebx] [edi] \
modify exact [eax ebx ecx edx esi edi gs] nomemory;


void draw_shaded_linem (unsigned long ax, unsigned long ay, block temp);
#pragma aux draw_shaded_linem = \
  "push ebp" \
  "mov ecx, 160" \
  "mov esi, ground" \
  "add esi, 4" \
  "D1: mov edx, eax" \
  "shr edx, 22" \
  "mov ebp, edx" \
  "mov edx, ebx" \
  "shr edx, 12" \
  "and edx, 4294966272" \
  "add ebp, edx" \
  "xor edx, edx" \
  "mov dl, [esi + ebp]" \
  "mov ebp, shadeptrasm"\
  "mov dl, [edx + ebp]" \
  "mov dh, dl" \
  "mov [edi], dx" \
  "add eax, gxstep" \
  "add ebx, gystep" \
  "add edi, 2" \
  "dec ecx" \
  "jnz D1" \
  "pop ebp" \
parm [eax] [ebx] [edi] \
modify exact [eax ebx ecx edx esi edi] nomemory;

void draw_shaded_lineh (unsigned long ax, unsigned long ay, block temp);
#pragma aux draw_shaded_lineh = \
  "push ebp" \
  "mov ecx, view_width" \
  "mov esi, ground" \
  "add esi, 4" \
  "D1: mov edx, eax" \
  "shr edx, 22" \
  "mov ebp, edx" \
  "mov edx, ebx" \
  "shr edx, 12" \
  "and edx, 4294966272" \
  "add ebp, edx" \
  "xor edx, edx" \
  "mov dl, [esi + ebp]" \
  "mov ebp, shadeptrasm"\
  "mov dl, [edx + ebp]" \
  "mov [edi], dl" \
  "add eax, gxstep" \
  "add ebx, gystep" \
  "inc edi" \
  "dec ecx" \
  "jnz D1" \
  "pop ebp" \
parm [eax] [ebx] [edi] \
modify exact [eax ebx ecx edx esi edi] nomemory;


void draw_mode7 (void)
{
int x;
int y;
int view_distance;

unsigned int ax, ay;
unsigned int bx, by;

unsigned int realelevation;
int leftangle;
int rightangle;
int xdiff, ydiff;
unsigned int row2;
int shade;

block temp;


 leftangle = (playerangle - viewcone);
 if (leftangle < 0)
     leftangle += 360;
 rightangle = (playerangle + viewcone) % 360;


 #ifdef USE_VIRTUAL
  wsetscreen (virt);
 #else
  wnormscreen ();
 #endif
 wclip (0, 0, 319, 200 - view_height);

 realelevation = elevation + jumpheight;

 for (y = 0; y < view_height; y++)
   {
    row2 = (200 - ((y * 200) / view_height) + inclination);
    if (row2 == 0)
      row2 = 1;
    
    #ifdef USE_VIRTUAL
     temp = virt + (200 - y) * 320 + 4;
    #else
     temp = abuf + (200 - y) * 320;
    #endif

    view_distance = (realelevation) / row2;

    /* Used if shaded tmapping */
    if (shading_on)
      {
       shade = view_distance / shading_factor;
       shade = 63 - shade;
       if (shade > 63)
         shade = 63;
       if (shade < 0)
         shade = 0;
       shadeptrasm = shades + shade * 256;
      }

    ax = playerx - (isin [leftangle] * view_distance);
    ay = playery - (icos [leftangle] * view_distance);
		    
    bx = playerx - (isin [rightangle] * view_distance);
    by = playery - (icos [rightangle] * view_distance);

    xdiff = bx - ax;
    ydiff = by - ay;

    gxstep = xdiff / (long)view_width;
    gystep = ydiff / (long)view_width;

    if ((!shading_on) || (shade == 63))
    switch (draw_routine)
      {
       case LOW_DETAIL: draw_mode7_linel (ax, ay, temp); break;
       case MEDIUM_DETAIL: draw_mode7_linem (ax, ay, temp); break;
       case HIGH_DETAIL: draw_mode7_lineh (ax, ay, temp); break;
      }
    else    
    switch (draw_routine)
      {
       case LOW_DETAIL: draw_shaded_linel (ax, ay, temp); break;
       case MEDIUM_DETAIL: draw_shaded_linem (ax, ay, temp); break;
       case HIGH_DETAIL: draw_shaded_lineh (ax, ay, temp); break;
      }
   }
}




void build_map (void)
{
short x, y; 
int tile;

 wsetscreen (ground);

 wsetscreen (ground);
 for (y = 0; y < 32; y++)
  for (x = 0; x < 32; x++)
   {
    tile = wgetworldblock (0, x*32, y*32);
    wputblock (x * 32, y * 32, tiles[tile], 0);
   }

 wfreemap (roadmap);
 wfreesprites (tiles, 0, 255);
}



#define MAXCOL 256
/* Fade table creation routines */
/* ------------------------------------------------------------------------ */
unsigned char closest_match (int red, int green, int blue, color *pal)
{
int colnum;                     /* Color number to compare */
int delta_r, delta_g, delta_b;  /* Difference between new and existing */
float distance;                 /* Distance from new color */
float lowest_distance;          /* Lowest distance found */
int closest_color;              /* Color with the lowest distance */


   lowest_distance = 33333;
   /* Set to a high number, higher than anything possible.
      The highest distance we can have is sqrt (64*64 + 64*64 + 64*64)
      which is 110.85 */

   for  (colnum = 0; colnum < MAXCOL; colnum++)
   /* Compare each color from the existing palette */
     {

      delta_r = (pal[colnum].r - red);
      delta_g = (pal[colnum].g - green);
      delta_b = (pal[colnum].b - blue);

      distance = sqrt (delta_r*delta_r*30 + delta_g*delta_g*59 + delta_b*delta_b*11);

      if  (distance < lowest_distance)
        {
         lowest_distance = distance;
         closest_color = colnum;
        }
     }

 return (closest_color);
}



void create_fade_table (int frame, int maxframe,
                        unsigned char *fadetable, color *pal)
{
float lightlevel1;      /* Percentage of color 1 */

float fr, fg, fb;       /* Floating point RGB values of color 1 */
int   ir,  ig,  ib;     /* Integer RGB values after combing the two above */

int col1;

unsigned char bestcolor; /* Best match */

 lightlevel1 = (float)frame / (float)maxframe;
 /* Calculate the percentage of color 1 */

 for (col1 = 0; col1 < MAXCOL; col1++)
   {
    fr = (float)pal[col1].r * lightlevel1;
    fg = (float)pal[col1].g * lightlevel1;
    fb = (float)pal[col1].b * lightlevel1;

    /* Calculate the two new colors */

    ir = fr;
    ig = fg;
    ib = fb;

    /* Combine the percentage of color 1 with the percentage of color 2
       to form a new color */

    bestcolor = closest_match (ir, ig, ib, pal);
    fadetable[frame * (MAXCOL) + col1] = bestcolor;
    /* Store the color at fadetable[frame][col1] */
   }

}



void create_all_shades (int numframes, unsigned char *fadetable,
                         color *pal)
{
int i;

 wtextcolor (255);  /* White color */
 wtexttransparent (TEXTFGBG);

 for (i = 0; i < numframes; i++)
  { 
   wgtprintf (160, 0, NULL, "Frame: %hi/%hi", i, (numframes/2-1));
   create_fade_table (i, numframes, fadetable, pal);
  }
}






void save_shade_table (void)
{
FILE *outfile;

 outfile = fopen ("shade.dat", "wb");
 fwrite (shades, 64 * 256L, 1, outfile);
 fclose (outfile);
}

void load_shade_table (void)
{
FILE *infile;

 infile = fopen ("shade.dat", "rb");
 fread (shades, 64 * 256L, 1, infile);
 fclose (infile);
}

void process_keyboard (void)
{

 if (kbdon[KEY_LEFT])
   {
    playerangle -= 4;
    if (playerangle < 0)
      playerangle += 360;
   }

 if (kbdon[KEY_RIGHT])
   {
    playerangle += 4;
    if (playerangle > 359)
      playerangle -= 360;
   }
	
 if (kbdon[KEY_UP])
   playerspeed += 10;
	  
 if (kbdon[KEY_DOWN])
   playerspeed -= 10;
	
 if (playerspeed > 0)
   playerspeed--;

 if (playerspeed < 0)
   playerspeed++;

 playercos = icos[playerangle];
 playersin = isin[playerangle];

 playerx -= playersin * playerspeed;
 playery -= playercos * playerspeed;



 if (kbdon[KEY_W])
   {
    if (elevation < 6553600)
      elevation +=5600;
   }

 if (kbdon[KEY_S])
   {
    if (elevation > 5600)
      elevation -=5600;          
   }
	
 if (kbdon[KEY_E])
    inclination += 5;

 if (kbdon[KEY_D])
   {
    inclination -= 5;
    if (inclination < 1)
      inclination = 1;
   }

 if (kbdon[KEY_R])
   viewcone += 1;          

 if (kbdon[KEY_F])
   {
    viewcone -= 1; 
    if (viewcone < 1)
      viewcone = 1;
   }
	
 if (kbdon[KEY_T])
    shading_factor += 10;

 if (kbdon[KEY_G])
   {
    shading_factor -= 10;
    if (shading_factor < 1)
      shading_factor = 1;
   }
	
 if (kbdon[KEY_F1])  /* Low detail */
   {
    draw_routine = LOW_DETAIL;
    view_width = LOW_WIDTH;
   }

 if (kbdon[KEY_F2])  /* Medium detail */
   {
    draw_routine = MEDIUM_DETAIL;
    view_width = MEDIUM_WIDTH;
   }

 if (kbdon[KEY_F3])  /* High detail */
   {
    draw_routine = HIGH_DETAIL;
    view_width = HIGH_WIDTH;
   }
      
 if ((kbdon[KEY_CTRL]) & (jumpheight == 0))
   jumpdir = 50000;

 if (jumpdir > -50001)
   {
    jumpheight += jumpdir;
    jumpdir -= 5000;
    if (jumpheight < 0)
      jumpheight = 0;
   }
}


void main (void)
{
int i, j;

  printf("Texture Plane \n");
  printf("Written with WGT 5.1 for Watcom C/C++\n");
  printf("October 1, 1995\n\n");
  printf("Keys:\n");
  printf("Arrows keys move\n");
  printf("ESC  - quits\n");
  printf("W    - Increase height\n");
  printf("S    - Decrease height\n");
  printf("E    - Look towards ground\n");
  printf("D    - Look towards sky\n");
  printf("R    - Increase viewing cone size\n");
  printf("F    - Decrease viewing cone size\n");
  printf("T    - Increase brightness\n");
  printf("G    - Decrease brightness\n");
  printf("F1   - Low detail\n");
  printf("F2   - Medium detail\n");
  printf("F3   - High detail\n");
  printf("CTRL - Jumps\n\n\n");
  printf("Enter number of scanlines for land: (eg. 130)");
  scanf ("%hi", &view_height);
  printf("Do you want shading? (0 = NO, 1 = YES)");
  scanf ("%hi", &shading_on);
  
  vga256 ();

  #ifdef USE_VIRTUAL
   virt = wnewblock (0, 0, 319, 199);
  #endif

  ground = wallocblock (1024, 1024);

  wloadsprites (pal, "road.spr", tiles, 0, 255);
  roadmap = wloadmap (0, "road.wmp", tiletypes, wobjects);
  tilewidth[0] = 32;
  tileheight[0] = 32;
 
  if (shading_on)
    {
     shades = malloc (64 * 256);
     //create_all_shades (64, shades, pal);
     load_shade_table ();

     /* If you want to make a new shade table, uncomment the above line
        and change load_shade_table to save_shade_table once. */
    }


  build_map ();

  groundpic = ground + 4;
  wnormscreen ();
      
  wsetpalette (0, 255, pal);
  p_create_sincos ();

  playerx = 100 << 22;
  playery = 10 << 22;
  playerangle = 12;

  wnormscreen ();
  wcls (0);

  installkbd ();
   
  draw_routine = MEDIUM_DETAIL;
  view_width = MEDIUM_WIDTH;
  jumpdir = -11;
  jumpheight = 0;
  
   do
     {
      process_keyboard ();  
      draw_mode7 ();

      wnormscreen ();
      rowoffset = (200 - view_height) * 320;

      #ifdef USE_VIRTUAL  
       wcopyscreen (0, 199 - view_height, 319, 199, virt, 0, 199 - view_height, NULL);
      #endif
     } while (!kbdon[1]);

 uninstallkbd ();

 wfreeblock (ground);
 wsetmode (3);   
}    



