/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 2                         
                                                                            
Draws pixels with a random colour in random places until you hit a key.     
                                                                            
The second loop fills the screen with wfastputpixel.                        
                                                                            
The third third loop read in the pixels in the top left corner of the       
screen with wgetpixel and uses wputpixel to recreate the image in           
the bottom right corner.                                                    
                                                                            
  PROJECT                                                             
 This program requires the file WGT45.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <wgt45.h>


void main(void)
{
short x;
short y;
short i;
short oldmode;

  printf ("WGT Example #2\n\n");
  printf ("This program will draw random pixels until you hit a key.\n");
  printf ("Then it will fill the screen using wfastputpixel, press a key.\n");
  printf ("The wgetpixel command is then used to duplicate a portion of the screen.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();


  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  oldmode = wgetmode ();	/* Gets the current mode 	*/
  vga256 ();			/* Initializes WGT system 	*/
  wcls (0); 			/* Clear screen with color 0 	*/

  /* Put randomly coloured pixels in random screen coordinates 	*/
  do {
    wsetcolor (rand () % 255);
    x = rand () % 320;
    y = rand() % 200;
    wputpixel (x, y);
  } while (kbhit () == 0);
  getch ();

  wcls (0);			/* Clear screen with color 0	*/
  wsetcolor (10);		/* Now we will draw with #10	*/
  for (x = 0; x < 320; x++)
    for (y = 0; y < 200; y++)
      wfastputpixel (x, y);	/* Fast due to no clipping checking */

  getch ();
  wcls (0); 			/* Clears screen with color 0	*/

  /* Put randomly coloured pixels in the top left corner of the screen	*/
  for (i = 0; i < 15000; i++)
  {
    wsetcolor (rand () % 255);
    x = rand () % 160;
    y = rand () % 100;
    wputpixel (x, y);
  }

  /* Now use wgetpixel to read image off screen */
  for (y = 0; y < 100; y++)
    for (x = 0; x < 160; x++)
    {
      wsetcolor (wgetpixel (x, y));
      wputpixel (x + 160, y + 100);
    }

  getch ();
  wsetmode (oldmode);		/* Restore old video mode	*/
}