        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc

public  _mtm_voicebase, _mtm_voicenum, _mtm_playing, _mtm_ramtype

public  _mtmp_init, _mtmp_uninit, _mtmp_setmuz, _mtmp_playmuz, _mtmp_stopmuz
public  _mtmp_phademuz

;
; DATA
;
align 4
muzbaseptr      dd      ?               ; base ptr of muzik file
insbaseptr      dd      ?               ; base ptr of instrument data
ordbaseptr      dd      ?               ; base ptr of order list
trkbaseptr      dd      ?               ; base ptr of track data
patbaseptr      dd      ?               ; base ptr of pattern data

voicetrkptr     dd      16 dup(?)       ; ptr to track for each voice
voicepanloc     db      16 dup(?)       ; pan locs for voices
voicevol        db      16 dup(?)       ; voice volumes

soundcarddata   dd      ?               ; ptr to soundcard data structure

setmuzl1jtbl	dd	setmuzl1f1,setmuzl1f2,setmuzl1f3,setmuzl1f4,setmuzl1f5

realfreqtbl     dw      2166, 2294, 2431, 2573, 2728, 2891, 3063, 3245, 3438, 3642, 3859, 4088             ;2112, 2237, 2370, 2509, 2660, 2819, 2986, 3164, 3352, 3551, 3763, 3986
                dw      4332, 4589, 4862, 5147, 5457, 5782, 6126, 6490, 6876, 7285, 7718, 8177             ;4224, 4475, 4741, 5019, 5321, 5638, 5973, 6328, 6704, 7103, 7526, 7973
                dw      8664, 9179, 9725, 10294, 10915, 11565, 12252, 12981, 13752, 14571, 15437, 16355    ;8448, 8950, 9482, 10038, 10643, 11276, 11947, 12657, 13409, 14207, 15052, 15947
                dw      17328, 18358, 19450, 20589, 21831, 23130, 24505, 25962, 27505, 29142, 30874, 32710 ;16896, 17900, 18965, 20076, 21287, 22553, 23894, 25315, 26819, 28415, 30105, 31895
                dw      34656, 36716, 38900, 41179, 43663, 46260, 49011, 51925, 55010, 58284, 61749, 65421 ;33792, 35801, 37930, 40152, 42575, 45107, 47789, 50630, 53638, 56831, 60210, 63790
freqtbl         dw      5*12 dup(?)

_mtm_voicebase  db      0               ; base voice of play
_mtm_voicenum   db      16              ; number of voices to play
_mtm_playing    db      ?               ; 1=muzik playing, 0=not
_mtm_ramtype    db      ?               ; 1=ram on card, 0=system ram
installed       db      0               ; 1=mtm player installed, 0=not

mtmtempo        db      ?               ; current tempo
mtmtempocntr    db      ?               ; tempo counter
mtmord          db      ?               ; current order playing
mtmlastord      db      ?               ; last order to play in MTM module
mtmrowstogo     db      ?               ; rows to go in current pattern
mtmvolfactor    db      ?               ; volume scale factor
mtmphading      db      ?               ; 1=muzik phading out, 0=not
mtmphadespeed   db      ?               ; ticks to skip between phades
mtmphadecntr    db      ?               ; phade tick counter

;
; CODE
;

include low_data.m

;
mtmp:
        cmp mtmphading,0
        je short mtmpf2
        mov al,mtmphadecntr
        sub al,1
        jnc short mtmpf3
        mov bl,mtmvolfactor
        sub bl,1
        jnc short mtmpf4
        call _mtmp_stopmuz
        ret
mtmpf4:
        mov mtmvolfactor,bl
        movzx ebp,_mtm_voicenum
        sub ebp,1
        jc short mtmpl2d
mtmpl2:
        mov al,voicevol[ebp]
        mul bl
;       shr al,4
        or _low_vccmnd[ebp],1
        mov _low_vcvol[ebp],al
        sub ebp,1
        jnc mtmpl2
mtmpl2d:
        mov al,mtmphadespeed
mtmpf3:
        mov mtmphadecntr,al
mtmpf2:

        mov al,mtmtempocntr
        dec al
        jnz mtmpf0
        mov al,mtmrowstogo
        dec al
        jnz short mtmpf1

        movzx eax,mtmord
        inc al
        cmp al,mtmlastord
        jbe short $+4
        xor al,al
        mov mtmord,al
        mov ebx,ordbaseptr
        mov al,[ebx+eax]
        lea eax,[eax*8]
        mov ebx,patbaseptr
        lea ebx,[ebx+eax*8]
        mov edx,trkbaseptr
        movzx ecx,_mtm_voicenum
        sub ecx,1
        jc mtmpl0d
mtmpl0:
        movzx eax,word ptr [ebx+ecx*2]
        or eax,eax
        jz short mtmpl0c
        lea eax,[eax*2+eax-3]
        shl eax,6
        add eax,edx
mtmpl0c:
        mov voicetrkptr[ecx*4],eax
        sub ecx,1
        jnc mtmpl0
mtmpl0d:

        mov al,64
mtmpf1:
        mov mtmrowstogo,al

        movzx ebp,_mtm_voicenum
        sub ebp,1
        jc mtmpl1d
mtmpl1:
        mov edi,voicetrkptr[ebp*4]
        or edi,edi
        jz mtmpl1c
        movzx eax,byte ptr [edi]
        or eax,eax
        jz short mtmpl1f0
        mov ax,freqtbl[eax*2-2]
        mov _low_vcfreq[ebp*2],ax
        mov al,voicepanloc[ebp]
        mov _low_vcpan[ebp],al
        or _low_vccmnd[ebp],8
        movzx ebx,byte ptr [edi+1]
        imul ebx,37
        add ebx,insbaseptr
        mov al,[ebx+35]
        mov voicevol[ebp],al
        shl al,4
        mov _low_vcvol[ebp],al
        mov al,[ebx+12]
        mov _low_vccntrl[ebp],al
        mov eax,[ebx]
        mov _low_vcsbeg[ebp*4],eax
        mov eax,[ebx+4]
        mov _low_vclbeg[ebp*4],eax
        mov eax,[ebx+8]
        mov _low_vclend[ebp*4],eax
mtmpl1f0:
        mov al,[edi+2]
        cmp al,1
        jb short mtmpl1c2
        je short mtmpl1f1
        test al,80h
        jz short mtmpl1f2
        test al,40h
        jnz short mtmpl1f4
        and al,0fh
        mov voicevol[ebp],al
        shl al,4                ;
        mov _low_vcvol[ebp],al
        or _low_vccmnd[ebp],1
        jmp short mtmpl1c2
mtmpl1f4:
        and al,3fh
        mov mtmtempo,al
        jmp short mtmpl1c2
mtmpl1f2:
        test al,20h
        jz short mtmpl1f3
        and al,0fh
        mov voicepanloc[ebp],al
        mov _low_vcpan[ebp],al
        or _low_vccmnd[ebp],2
        jmp short mtmpl1c2
mtmpl1f3:
        and al,1fh
        dec al
        mov mtmord,al
mtmpl1f1:
        mov mtmrowstogo,1
mtmpl1c2:
        test _low_vccmnd[ebp],9
        jz short mtmpl1f5
        mov al,_low_vcvol[ebp]
        mul mtmvolfactor
        shr eax,4
        mov _low_vcvol[ebp],al
mtmpl1f5:
        add edi,3
        mov voicetrkptr[ebp*4],edi
mtmpl1c:
        sub ebp,1
        jnc mtmpl1
mtmpl1d:

        mov al,mtmtempo
mtmpf0:
        mov mtmtempocntr,al

        ret

;
; Initialize MTM player
; In:
;   AH - number of voices (1-16)
;   BX - mixing rate (8000-44100)
;   ESI -> soundcard data structure
; Notes:
;   _low_port, _low_irq, and _low_dma must all be set before calling.
;   Allocates low memory.
;
_mtmp_init:
        call _mtmp_uninit
        mov installed,1
        push eax ebx

        mov soundcarddata,esi
        mov ebx,_lomembase
        mov _low_bufptr,ebx
        mov al,[esi+4*9]
        and al,1
        mov _mtm_ramtype,al
        mov _mtm_playing,0
        mov _low_rout,offset _ret

        mov al,56
        mov bx,[esp]
        call _sound_init
        mov eax,_low_buf
        add _lomembase,eax

        mov ebx,(12*5-1)*2
initl0:
        movzx eax,realfreqtbl[ebx]
        call _low_get_freq
        mov freqtbl[ebx],ax
        sub ebx,2
        jnc initl0

        pop ebx eax
        ret

;
; Uninitialize MTM player
;
_mtmp_uninit:
        cmp installed,0
        je _ret
        mov installed,0
        call _mtmp_stopmuz
        call _low_uninit
        ret

;
; Set up muzik for play
; In:
;   EDX -> MTM module
; Out:
;   EAX - number of bytes to keep of module
; Notes:
;   Music data is altered, so if needs to be set up again, must reload it.
;
_mtmp_setmuz:
        pushad

        mov muzbaseptr,edx
        mov al,[edx+27]
        mov mtmlastord,al
        lea edi,[edx+66]
        mov insbaseptr,edi
        movzx esi,byte ptr [edx+30]
        imul esi,37
        add esi,edi
        mov ordbaseptr,esi
        add esi,128
        mov trkbaseptr,esi
        movzx eax,word ptr [edx+24]
        lea eax,[eax*2+eax]
        shl eax,6
        add esi,eax
        mov patbaseptr,esi
        movzx eax,byte ptr [edx+26]
        shl eax,6
        lea esi,[esi+eax+64]
        movzx ebx,word ptr [edx+28]
        add ebx,esi

        push ebx
        mov al,[edx+30]
        mov edx,ebx
        mov ebp,offset _ret
        cmp _mtm_ramtype,0
        je short setmuzl0
        xor ebx,ebx
        mov ebp,_low_put_data
setmuzl0:
        mov ecx,[edi+22]
        jecxz setmuzl0c
        lea esi,[ecx-1]
setmuzl0l0:
        xor byte ptr [edx+esi],80h
        sub esi,1
        jnc setmuzl0l0
        mov esi,[edi+30]
        xor ah,ah
        cmp esi,2
        jbe short setmuzl0f0
        mov ah,8
        mov ecx,esi
setmuzl0f0:
        mov [edi+12],ah
        call ebp
        mov [edi],ebx
        lea ecx,[ebx+ecx-2] ; -1]
        mov [edi+8],ecx
        mov ecx,[edi+26]
        add ecx,ebx
        mov [edi+4],ecx
        mov ah,[edi+35]
        sub ah,1
        adc ah,0
        shr ah,2
        mov [edi+35],ah
        mov ecx,[edi+22]
        add ebx,ecx
        add edx,ecx
setmuzl0c:
        add edi,37
        dec al
        jnz setmuzl0
        pop ebx
        cmp _mtm_ramtype,0
        je short $+4
        mov edx,ebx
        sub edx,muzbaseptr
        mov [esp+28],edx

        mov edi,trkbaseptr
        mov ecx,muzbaseptr
        movzx ecx,word ptr [ecx+24]
        shl ecx,6
setmuzl1:
	xor ebx,ebx
	movzx eax,byte ptr [edi+1]
	and al,0fh
	sub al,0bh
	jc short setmuzl1f0
	mov bl,[edi+2]
	jmp setmuzl1jtbl[eax*4]
setmuzl1f1:
	and bl,1fh
	or bl,40h
	jmp short setmuzl1f0
setmuzl1f2:
	sub bl,1
	adc bl,0
	shr bl,2
	or bl,80h
	jmp short setmuzl1f0
setmuzl1f3:
	mov bl,1
	jmp short setmuzl1f0
setmuzl1f4:
	mov bh,bl
	and bl,0f0h
	cmp bl,80h
	mov bl,0
	jne short setmuzl1f0
	mov bl,bh
	and bl,0fh
	or bl,60h
        jmp short setmuzl1f0
setmuzl1f5:
	shl ebx,2
	mov eax,60*56
	xor edx,edx
	div ebx
        or al,0c0h
	mov bl,al
setmuzl1f0:
	mov [edi+2],bl
        mov ax,[edi]
        ror ax,2
        and al,3fh
        shr ah,2
        sub ah,1
        adc ah,0
        mov [edi],ax
        add edi,3
        loop setmuzl1

        mov ebp,muzbaseptr
        lea edi,[ebp+34]
        movzx edx,_mtm_voicebase
        lea esi,[edi+edx]
        movzx ebx,_mtm_voicenum
        mov ecx,ebx
        rep movsb
        movzx ebp,byte ptr [ebp+26]
        mov edi,patbaseptr
        shl edx,1
        xor eax,eax
setmuzl2:
        lea esi,[edi+edx]
        mov ecx,ebx
        rep movsw
        mov cl,32
        sub ecx,ebx
        rep stosw
        sub ebp,1
        jnc setmuzl2

        popad
        ret

;
; Start muzik playback
;
_mtmp_playmuz:
        call _mtmp_stopmuz
        push eax ebx
        mov ebx,muzbaseptr
        mov eax,[ebx+34+0]
        mov dword ptr voicepanloc[0],eax
        mov eax,[ebx+34+4]
        mov dword ptr voicepanloc[4],eax
        mov eax,[ebx+34+8]
        mov dword ptr voicepanloc[8],eax
        mov eax,[ebx+34+12]
        mov dword ptr voicepanloc[12],eax
        xor eax,eax
        mov dword ptr voicevol[0],eax
        mov dword ptr voicevol[4],eax
        mov dword ptr voicevol[8],eax
        mov dword ptr voicevol[12],eax
        mov mtmphading,al
        mov al,1
        mov _mtm_playing,al
        mov mtmrowstogo,al
        mov mtmtempocntr,al
        mov mtmvolfactor,10h
        mov mtmtempo,7
        mov mtmord,-1
        mov _low_rout,offset mtmp
        pop ebx eax
        ret

;
; Stop muzik playback
;
_mtmp_stopmuz:
        cmp _mtm_playing,0
        je _ret
        push eax
        mov _low_rout,offset _ret
        mov _mtm_playing,0
        movzx eax,_mtm_voicenum
stopmuzl0:
        sub al,1
        jc short stopmuzl0d
        mov _low_vcvol[eax],0
        mov _low_vccmnd[eax],1
        jmp stopmuzl0
stopmuzl0d:
        pop eax
        ret

;
; Set muzik to phade out
; In:
;   AL - speed to phade at (ticks to skip between phades (1/56th sec))
;
_mtmp_phademuz:
        mov mtmphading,1
        mov mtmphadespeed,al
        mov mtmphadecntr,0
        ret

code32  ends
        end

