#include <STDIO.H>
#include <STDLIB.H>
#include <STRING.H>

#include "profile.h"

extern void ASM_TestTSC(void);
extern void ASM_TestMSR(void);

//
// Main entry point
//

//
// If the user is running in a multitasking environemnt then the TSC will
// most definetly get the wrong results.
// And the MSR tests will crash....
//
void main(void)
{
  int i,j,k;
  int dummy_write=0;

  j=0;
  k=2;
  printf("\nWARNING! If you are in a multitasking environment these test will be\n"
         "         wrong and will also cause a crash.\n");

  // Test TSC in C

  printf("\nStarting C TSC test\n");

  StartTSC();
  for(i=0;i<20;i++)
  {
    j+=k;
  }
  EndTSC();

  printf("20 loops : %d cycles\n"
	 " 1 loop  : %g cycles\n",TSC,(float)(TSC/20));

  // Test MSR in C

  printf("\nStarting C MSR test\n");

  _StartProfile(0x00,0x01);
  for(i=0;i<20;i++)
  {
    j+=k;
    dummy_write = j; // Watcom/C will probably optimize this out
		     // giving low counts on the reads/writes
  }
  _EndProfile();

  printf("20 loops : %d data reads\n"
	 "           %d data writes\n"
	 "1  loop  : %g data read\n"
	 "           %g data writes\n",prof0,prof1,
			(float)(prof0/20),(float)(prof1/20));

  
  // Test MSR test in ASM..

  // Test TSC in ASM..

  ASM_TestTSC();
  printf("\nASM TSC TEST : %d cycles (expecting 3 cycles)\n",TSC);

                                                                  
  ASM_TestMSR();
  printf("ASM MSR TEST : timer0 = %d (expecting 3)\n"
	 "               timer1 = %d (expecting 3)\n",prof0,prof1);

}
