.486p
SMART
JUMPS
LOCALS

_TEXT   segment use32 dword public 'CODE'
_TEXT   ends

_DATA   segment use32 dword public 'DATA'
_DATA   ends

_BSS    segment use32 dword public 'BSS'
_BSS    ends

DGROUP  group _DATA, _BSS
assume  cs:_TEXT, ds:DGROUP


include profile.inc


;
; CODE
;
_TEXT   segment use32 dword public 'CODE'
	assume  cs:_TEXT,ds:_DATA

global ASM_TestTSC_:proc
global ASM_TestMSR_:proc

;

;
; Test the TSC macros
;
;
ASM_TestTSC_    proc
	pushad

	;
	; Count some cycles.
	; Should get result of 3 cycles
	;
	; Make sure code is cached run 3 times...
	; (not really needed, since this section is so small)
	;

	mov ecx,3
@@loop1:

	StartTSC
	;
	; The first instruction after StartTSC is always executed in the
	; U-pipe..
	
	add eax,eax
	add ebx,ebx

	; so the following instruction won't cause a pipe stall
	
	add ebx,ebx
	add eax,eax

	add eax,eax
	add ebx,ebx
	

	EndTSC

	dec ecx
	jnz @@loop1

	popad
	ret
ASM_TestTSC_    endp


;
; Test the MSR macros
;
;
ASM_TestMSR_    proc
	pushad

	;
	; Count some memory reads and writes
	; Should get results of 3 and 3.
	;
	; Make sure code is cached, run 3 times
	; (not really needed, since this section is so small)
	;
	mov ecx,3
@@loop2:

	StartProfile 00h,01h

	mov eax,_prof0
	mov _prof0,eax

	mov eax,_prof0
	mov _prof0,eax

	mov eax,_prof0
	mov _prof0,eax

	EndProfile

	dec ecx
	jnz @@loop2

	popad
	ret
ASM_TestMSR_    endp

ends


end
