# Compilers and options:

#__16__ = 1

!ifdef __16__

CC = wcc
CCOPTS = -ml -zdp -zu -w3 -d2 -d__WC16__ -2 -5 -dDEBUG
ASM = tasm
ASMOPTS = -UT310 -ml -m9 -zi -d__WC16__ -dDEBUG

EMSINC = ems.inc
EMSH = ems.h
EMSOBJ = ems.obj
DPMIH =
DPMIINC =
DPMIOBJ =
LINKCMD = midp16.wlk

!else

CC = wcc386
CCOPTS = -w3 -d2 -zdp -zu -bt=dos -d__WC32__ -dDEBUG #-dNOTIMER
#CCOPTS = -w3 -zdp -zu -bt=dos -d__WC32__ -dDEBUG -oneatx -s #-dNOTIMER
ASM = tasm
ASMOPTS = -UT310 -p -ml -m9 -zi -d__WC32__ -dDEBUG

EMSINC =
EMSH =
EMSOBJ=
DPMIH = dpmi.h
DPMIINC = dpmi.inc
DPMIOBJ = dpmi.obj
LINKCMD = midp.wlk

!endif

TOUCH = wtouch


midp.exe : midp.obj midas.obj dsm.obj dsmmix.obj mmem.obj errors.obj \
	mutils.obj dma.obj mixsd.obj postproc.obj pas.obj mglobals.obj \
	sb.obj gmplayer.obj gmpcmds.obj file.obj rawfile.obj loadmod.obj \
	wss.obj timer.obj midpdisp.obj vgatext.obj gus.obj loadxm.obj \
        loads3m.obj vu.obj mconfig.obj nosound.obj gusdac.obj \
        $(EMSOBJ) $(DPMIOBJ)
	wlink @$(LINKCMD)

midp.obj : midp.c midas.h midp.h vu.h
        wpp386 midp.c $(CCOPTS)
#        $(CC) midp.c $(CCOPTS)

midpdisp.obj : midpdisp.c midas.h vu.h midp.h vgatext.h
	$(CC) midpdisp.c $(CCOPTS)

midas.obj : midas.c midas.h
	$(CC) midas.c $(CCOPTS)

vgatext.obj : vgatext.asm lang.inc vgatext.inc
	$(ASM) vgatext.asm $(ASMOPTS)

gmplayer.obj : gmplayer.c lang.h mtypes.h errors.h sdevice.h gmplayer.h \
	mmem.h $(EMSH)
	$(CC) gmplayer.c $(CCOPTS)

gmpcmds.obj : gmpcmds.c lang.h mtypes.h errors.h sdevice.h gmplayer.h
	$(CC) gmpcmds.c $(CCOPTS) -w2

loadmod.obj : loadmod.c lang.h mtypes.h errors.h mglobals.h mmem.h file.h \
	sdevice.h gmplayer.h mutils.h $(EMSH)
	$(CC) loadmod.c $(CCOPTS)

loadxm.obj : loadxm.c lang.h mtypes.h errors.h mglobals.h mmem.h file.h \
	sdevice.h gmplayer.h mutils.h xm.h $(EMSH)
	$(CC) loadxm.c $(CCOPTS)

loads3m.obj : loads3m.c lang.h mtypes.h errors.h mglobals.h mmem.h file.h \
	sdevice.h gmplayer.h mutils.h $(EMSH)
	$(CC) loads3m.c $(CCOPTS)

file.obj : file.c lang.h mtypes.h errors.h mmem.h rawfile.h file.h
	$(CC) file.c $(CCOPTS)

rawfile.obj : rawfile.c lang.h mtypes.h errors.h mmem.h rawfile.h
	$(CC) rawfile.c $(CCOPTS)

asmrfile.obj : asmrfile.asm lang.inc errors.inc rawfile.inc mmem.inc
	$(ASM) asmrfile.asm $(ASMOPTS)

dsm.obj : dsm.c lang.h errors.h mmem.h dsm.h sdevice.h dsm.h mutils.h \
	mglobals.h $(DPMIH) $(EMSH)
	$(CC) dsm.c $(CCOPTS)

mmem.obj : mmem.c lang.h errors.h mmem.h
	$(CC) mmem.c $(CCOPTS)

errors.obj : errors.c lang.h errors.h
	$(CC) errors.c $(CCOPTS)

mutils.obj : mutils.asm lang.inc mutils.inc
	$(ASM) mutils.asm $(ASMOPTS)

dsmmix.obj : dsmmix.asm lang.inc errors.inc sdevice.inc dsm.inc mglobals.inc \
	$(EMSINC)
	$(ASM) dsmmix.asm $(ASMOPTS)

dma.obj : dma.c lang.h mtypes.h errors.h mmem.h dma.h $(DPMIINC)
	$(CC) dma.c $(CCOPTS)

dpmi.obj : dpmi.asm lang.inc errors.inc dpmi.inc
	$(ASM) dpmi.asm $(ASMOPTS)

mixsd.obj : mixsd.c lang.h mtypes.h errors.h mmem.h mixsd.h dma.h sdevice.h \
	dsm.h
	$(CC) mixsd.c $(CCOPTS)

postproc.obj : postproc.asm lang.inc errors.inc dsm.inc
	$(ASM) postproc.asm $(ASMOPTS)

pas.obj : pas.asm pas.inc lang.inc errors.inc sdevice.inc dsm.inc \
	mixsd.inc $(DPMIINC)
	$(ASM) pas.asm $(ASMOPTS)

ems.obj : ems.asm lang.inc errors.inc ems.inc mmem.inc
	$(ASM) ems.asm $(ASMOPTS)

mglobals.obj : mglobals.c mglobals.h
	$(CC) mglobals.c $(CCOPTS)

sb.obj : sb.asm lang.inc errors.inc sdevice.inc dsm.inc dma.inc mixsd.inc \
	mutils.inc
	$(ASM) sb.asm $(ASMOPTS)

wss.obj : wss.asm lang.inc errors.inc sdevice.inc mixsd.inc dsm.inc
	$(ASM) wss.asm $(ASMOPTS)

gus.obj : gus.asm lang.inc errors.inc sdevice.inc
	$(ASM) gus.asm $(ASMOPTS)

gusdac.obj : gusdac.asm lang.inc errors.inc sdevice.inc
        $(ASM) gusdac.asm $(ASMOPTS)

timer.obj : timer.asm lang.inc mglobals.inc errors.inc timer.inc sdevice.inc \
	$(EMSINC)
	$(ASM) timer.asm $(ASMOPTS)

vu.obj : vu.c lang.h mtypes.h errors.h mmem.h sdevice.h vu.h mutils.h
        $(CC) vu.c $(CCOPTS)

mconfig.obj : mconfig.c midas.h vgatext.h
        $(CC) mconfig.c $(CCOPTS)

nosound.obj : nosound.c lang.h mtypes.h errors.h sdevice.h
        $(CC) nosound.c $(CCOPTS)

midas.h : lang.h mtypes.h errors.h mglobals.h mmem.h file.h sdevice.h \
        gmplayer.h timer.h dma.h dsm.h mutils.h $(EMSH)
	$(TOUCH) midas.h