#*      GMFILES.MAK
#*
#* Make script for MIDAS Sound System GM file support
#*
#* Copyright 1996 Petteri Kangaslampi and Jarno Paananen
#*
#* This file is part of the MIDAS Sound System, and may only be
#* used, modified and distributed under the terms of the MIDAS
#* Sound System license, LICENSE.TXT. By continuing to use,
#* modify or distribute this file you indicate that you have
#* read the license and understand and accept it fully.
#*

# MIDAS Sound System directory:
MIDASDIR=src


# Compilers and options:

#__16__ = 1

!ifdef __16__

CL = wcl
CLOPTS = -ml -zdp -zu -w3 -d2 -d__WC16__ -2 -5 -dDEBUG
ASM = tasm
ASMOPTS = -UT310 -ml -m9 -zi -d__WC16__ -dDEBUG

EMSINC = ems.inc
EMSH = ems.h
EMSOBJ = ems.obj
DPMIH =
DPMIINC =
DPMIOBJ =
LINKCMD = midp16.wlk

!else

CL = wcl386
CLOPTS = -w3 -zdp -zu -d__WC32__ -oneatx -s -bt=dos -i$(MIDASDIR)
#CLOPTS = -w3 -d2 -zdp -zu -d__WC32__ -"debug all"
#CCOPTS = -w3 -d__WC32__ -dDEBUG -oneatx -s
ASM = tasm
#ASMOPTS = -UT310 -p -ml -m9 -zi -d__WC32__ -dDEBUG
ASMOPTS = -UT310 -p -ml -m9 -d__WC32__ -i$(MIDASDIR)

EMSINC =
EMSH =
EMSOBJ=
DPMIH = dpmi.h
DPMIINC = dpmi.inc
DPMIOBJ = dpmi.obj
LINKCMD = midp.wlk

!endif

LIBNAME = mdsswc32.lib
LIBCMDS = mdsswc32.

!ifdef CUTDOWN
ASMOPTS += -dNOLOADERS -dNOCMDNAMES -dNOEMS -dCUTDOWN
CCOPTS += -dNOLOADERS -dNOCMDNAMES -dNOEMS -dCUTDOWN
LIBNAME = mcutwc32.lib
LIBCMDS = mcutwc32.
!endif

!ifdef GUSONLY
ASMOPTS += -dNOCONFIG -dGUSONLY
CCOPTS += -dNOCONFIG -dGUSONLY
LIBNAME = mguswc32.lib
LIBCMDS = mguswc32.
!endif


TOUCH = wtouch
LIBCMD = wlib -c -n $(LIBNAME) @$(LIBCMDS)


all : mod2gm.exe playgm.exe

mod2gm.exe : mod2gm.c mdsswc32.lib
        $(CL) $(CLOPTS) mod2gm.c mdsswc32.lib

playgm.exe : playgm.c mdsswc32.lib
        $(CL) $(CLOPTS) playgm.c mdsswc32.lib
