/*
==============================================================================================================
   Name:             INDICES.H

   Description:      Defines the required index to access effects type and variations and 
                     synthesizer emulation of the AWEMAN.DLL.

   Purpose:          Header file meant for accessing effects type and variations of AWEMAN.DLL.

   Author:           E.W. Khor
                     Copyright 1993,94 Creative Technology Ltd.

   Date:             version 1.0    -     27th Jan 1994

   Revision:

==============================================================================================================
*/

#ifndef  _INDICES_H
#define  _INDICES_H

enum SBANK {
               GENERAL_MIDI = 0,
               ROLAND_GS,
               MT_32,
               USER_CUSTOM_BANK
            };

enum TYPEINDEX {
               REVERB_CHORUS = 0,
               QSOUND
            };
            
enum SUBINDEX {
               REVERB = 0,
               CHORUS
            };
            
enum VARIINDEX {
               ROOM_1 = 0,
               ROOM_2,
               ROOM_3,
               HALL_1,
               HALL_2,
               PLATE,
               DELAY,
               PANNING_DELAY,

               CHORUS_1 = 0,
               CHORUS_2,
               CHORUS_3,
               CHORUS_4,
               FEEDBACK_DELAY,
               FLANGER,
               SHORT_DELAY,
               SHORT_DELAY_FB            
            };

enum FLAG_OPERATION {
               OPER_FILE,
               OPER_MEMORY
            };
               
typedef struct {

   enum SBANK        m_SBankIndex;           /* Follows strictly to the available Synth Emulation available */
   WORD              m_UBankIndex;           /* Valid number are from 1 to 127 */
   WORD              m_InstrIndex;           /* Instrument Index from 0 to 127 */
   
   enum TYPEINDEX    m_TypeIndex;            /* Follows strictly to the available Effects Type available */
   WORD              m_SubIndex;             /* A sub index of the Type Index */
   WORD              m_VariIndex[6];         /* 6 sets of variations! Extendibility thought */

   } CParamObject;

typedef CParamObject FAR *    LPPARAMOBJECT;
/*
   This CParamObject is usually used when required to pass several indices to the DLL. This happens
   when configuring an effects type, synth emulation or during query session.
   The LPPARAMOBJECT type define a far pointer to the parameter object.
*/

typedef struct {

   DWORD             m_Size;                 /* The size of the buffer attached */
   LPSTR             m_Buffer;               /* The far pointer to the buffer itself */
   DWORD             m_SizeUsed;             /* The number of buffer characters used by DLL */
   WORD              m_Flag;                 /* Scratch Variable */

   } CBufferObject;

typedef CBufferObject FAR *   LPBUFFEROBJECT;
/*
   The CBufferObject is used to specified a buffer area to the DLL. This buffer area will usually
   be filled with some strings or values. In some occassions, the buffer itself, actually carries
   information to the DLL, like filename etc.
   The LPBUFFEROBJECT type define a far pointer to the buffer object.
*/

#endif   /* _INDICES_H */
