/***************************************************************************
*	NAME:  MIXER16.C
**	COPYRIGHT:
**	"Copyright (c) 1994, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 01/01/94
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	01/01/94		Original
***************************************************************************/

#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "ultraerr.h"
#include "gf1os.h"
#include "extern16.h"
#include "defs16.h"
#include "codecos.h"
#include "codec.h"
#include "proto16.h"

extern ULTRA16_DATA _codec_data;
extern IMAGE16 _image_codec;
extern ULTRA_DATA _gf1_data;

unsigned char
Left_Input_Gain_Select(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.lic;

_image_codec.lic &= ~0x0f;
_image_codec.lic |= (level&0x0f);

ENTER_CRITICAL;
outp(_codec_data.addr,LEFT_INPUT);
outp(_codec_data.data,_image_codec.lic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_Input_Source(source)
unsigned char source;
{
unsigned char old;

old = _image_codec.lic & 0xC0;

_image_codec.lic &= ~0xC0;
_image_codec.lic |= (source&0xC0);

ENTER_CRITICAL;
outp(_codec_data.addr,LEFT_INPUT);
outp(_codec_data.data,_image_codec.lic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_Mic_Gain_Enable(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.lic & MIC_GAIN)
	old = ON;

if (on_off == ON)
	{
	_image_codec.lic |= MIC_GAIN;
	}
else
	{
	_image_codec.lic &= ~MIC_GAIN;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,LEFT_INPUT);
outp(_codec_data.data,_image_codec.lic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_Input_Gain_Select(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.ric & 0x0f;

_image_codec.ric &= ~0x0f;
_image_codec.ric |= (level&0x0f);

ENTER_CRITICAL;
outp(_codec_data.addr,RIGHT_INPUT);
outp(_codec_data.data,_image_codec.ric);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_Input_Source(source)
unsigned char source;
{
unsigned char old;

old = _image_codec.ric & 0xC0;

_image_codec.ric &= ~0xC0;
_image_codec.ric |= (source&0xC0);

ENTER_CRITICAL;
outp(_codec_data.addr,RIGHT_INPUT);
outp(_codec_data.data,_image_codec.ric);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_Mic_Gain_Enable(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.ric & MIC_GAIN)
	old = ON;

if (on_off == ON)
	{
	_image_codec.ric |= MIC_GAIN;
	}
else
	{
	_image_codec.ric &= ~MIC_GAIN;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,RIGHT_INPUT);
outp(_codec_data.data,_image_codec.ric);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_GF1_Input_Level(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.la1ic & 0x1f;

_image_codec.la1ic &= ~0x1f;
_image_codec.la1ic |= (level&0x1f);

ENTER_CRITICAL;
outp(_codec_data.addr,GF1_LEFT_INPUT);
outp(_codec_data.data,_image_codec.la1ic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_GF1_Input_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.la1ic & MUTE_INPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.la1ic |= MUTE_INPUT;
	}
else
	{
	_image_codec.la1ic &= ~MUTE_INPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,GF1_LEFT_INPUT);
outp(_codec_data.data,_image_codec.la1ic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_Line_Input_Level(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.llic & 0x1f;

_image_codec.llic &= ~0x1f;
_image_codec.llic |= (level&0x1f);

ENTER_CRITICAL;
outp(_codec_data.addr,LEFT_LINE_IN);
outp(_codec_data.data,_image_codec.llic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_Line_Input_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.llic & MUTE_INPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.llic |= MUTE_INPUT;
	}
else
	{
	_image_codec.llic &= ~MUTE_INPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,LEFT_LINE_IN);
outp(_codec_data.data,_image_codec.llic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_CD_Input_Level(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.la2ic & 0x1f;

_image_codec.la2ic &= ~0x1f;
_image_codec.la2ic |= (level&0x1f);
ENTER_CRITICAL;
outp(_codec_data.addr,CD_LEFT_INPUT);
outp(_codec_data.data,_image_codec.la2ic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_CD_Input_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.la2ic & MUTE_INPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.la2ic |= MUTE_INPUT;
	}
else
	{
	_image_codec.la2ic &= ~MUTE_INPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,CD_LEFT_INPUT);
outp(_codec_data.data,_image_codec.la2ic);
LEAVE_CRITICAL;

return(old);
}


unsigned char
Right_GF1_Input_Level(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.ra1ic & 0x1f;

_image_codec.ra1ic &= ~0x1f;
_image_codec.ra1ic |= (level&0x1f);

ENTER_CRITICAL;
outp(_codec_data.addr,GF1_RIGHT_INPUT);
outp(_codec_data.data,_image_codec.ra1ic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_GF1_Input_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.ra1ic & MUTE_INPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.ra1ic |= MUTE_INPUT;
	}
else
	{
	_image_codec.ra1ic &= ~MUTE_INPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,GF1_RIGHT_INPUT);
outp(_codec_data.data,_image_codec.ra1ic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_Line_Input_Level(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.rlic & 0x1f;

_image_codec.rlic &= ~0x1f;
_image_codec.rlic |= (level&0x1f);

ENTER_CRITICAL;
outp(_codec_data.addr,RIGHT_LINE_IN);
outp(_codec_data.data,_image_codec.rlic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_Line_Input_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.rlic & MUTE_INPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.rlic |= MUTE_INPUT;
	}
else
	{
	_image_codec.rlic &= ~MUTE_INPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,RIGHT_LINE_IN);
outp(_codec_data.data,_image_codec.rlic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_CD_Input_Level(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.ra2ic & 0x1f;

_image_codec.ra2ic &= ~0x1f;
_image_codec.ra2ic |= (level&0x1f);

ENTER_CRITICAL;
outp(_codec_data.addr,CD_RIGHT_INPUT);
outp(_codec_data.data,_image_codec.ra2ic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Mono_Output_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.mioc & 0x40)
	old = ON;

if (on_off == ON)
	{
	_image_codec.mioc |= 0x40;
	}
else
	{
	_image_codec.mioc &= ~0x40;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,MONO_IO_CTRL);
outp(_codec_data.data,_image_codec.mioc);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Mono_Input_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.mioc & MUTE_INPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.mioc |= MUTE_INPUT;
	}
else
	{
	_image_codec.mioc &= ~MUTE_INPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,MONO_IO_CTRL);
outp(_codec_data.data,_image_codec.mioc);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Mono_Input_Level(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.mioc & 0x0f;

_image_codec.mioc &= ~0x0f;
_image_codec.mioc |= (level&0x0f);

ENTER_CRITICAL;
outp(_codec_data.addr,MONO_IO_CTRL);
outp(_codec_data.data,_image_codec.mioc);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_CD_Input_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.ra2ic & MUTE_INPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.ra2ic |= MUTE_INPUT;
	}
else
	{
	_image_codec.ra2ic &= ~MUTE_INPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,CD_RIGHT_INPUT);
outp(_codec_data.data,_image_codec.ra2ic);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_Output_Attn_Select(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.loc & 0x3f;

_image_codec.loc &= ~0x3f;
_image_codec.loc |= (level & 0x3f);

ENTER_CRITICAL;
outp(_codec_data.addr,LEFT_OUTPUT);
outp(_codec_data.data,_image_codec.loc);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Left_Output_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.loc & MUTE_OUTPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.loc |= MUTE_OUTPUT;
	}
else
	{
	_image_codec.loc &= ~MUTE_OUTPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,LEFT_OUTPUT);
outp(_codec_data.data,_image_codec.loc);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_Output_Attn_Select(level)
unsigned char level;
{
unsigned char old;

old = _image_codec.roc & 0x3f;

_image_codec.roc &= ~0x3f;
_image_codec.roc |= (level & 0x3f);

ENTER_CRITICAL;
outp(_codec_data.addr,RIGHT_OUTPUT);
outp(_codec_data.data,_image_codec.roc);
LEAVE_CRITICAL;

return(old);
}

unsigned char
Right_Output_Mute(on_off)
unsigned char on_off;
{
unsigned char old = OFF;

if (_image_codec.roc & MUTE_OUTPUT)
	old = ON;

if (on_off == ON)
	{
	_image_codec.roc |= MUTE_OUTPUT;
	}
else
	{
	_image_codec.roc &= ~MUTE_OUTPUT;
	}

ENTER_CRITICAL;
outp(_codec_data.addr,RIGHT_OUTPUT);
outp(_codec_data.data,_image_codec.roc);
LEAVE_CRITICAL;

return(old);
}

void
Ultra16Xparent()
{

/* Lets try this method now ... */
	Left_GF1_Input_Mute(OFF);	/* Let GF1 output thru ... */
	Right_GF1_Input_Mute(OFF);	/* Let GF1 output thru ... */
	Left_GF1_Input_Level(8);	/* No attenuations please ... */
	Right_GF1_Input_Level(8);

	Left_CD_Input_Mute(OFF);	/* Let CD output thru ... */
	Right_CD_Input_Mute(OFF);	/* Let CD output thru ... */
	Left_CD_Input_Level(8);		/* No attenuations please ... */
	Right_CD_Input_Level(8);

	Left_Line_Input_Mute(OFF);	/* Let line level input thru */
	Right_Line_Input_Mute(OFF);	/* Let line level input thru */
	Left_Line_Input_Level(8);	/* 0db gain please */
	Right_Line_Input_Level(8);

	Mono_Input_Mute(OFF);		/* let microphone input thru ... */
	Mono_Input_Level(4);		/* No attenuation */

	/* Now setup the sampling side of the codec .. */
	Left_Input_Source(MUX_OUTPUT_SOURCE);/* loop mixed back to sample */
	Right_Input_Source(MUX_OUTPUT_SOURCE);/* loop mixed back to sample */
	Left_Output_Mute(ON);		/* Block sampled output ... */
	Right_Output_Mute(ON);		/* Block sampled output ... */
	Mono_Output_Mute(ON);		/* Block sampled output ... */
	Left_Input_Gain_Select(8);	/* No gain during sampling .. */
	Right_Input_Gain_Select(8);

}
