/***************************************************************************
*	NAME:  OPEN.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"
#include "extern.h"
#include "ultraerr.h"

extern ULTRA_DATA _gf1_data;

int
UltraOpen(ULTRA_CFG *config,int voices)
{
int temp;

_gf1_data.base_port = config->base_port;
_gf1_data.dram_dma_chan = config->dram_dma_chan;
_gf1_data.adc_dma_chan = config->adc_dma_chan;
_gf1_data.gf1_irq_num = config->gf1_irq_num;
_gf1_data.midi_irq_num = config->midi_irq_num;
_gf1_data.mix_image = 0x0B;

_gf1_data.voices = voices;
temp = UltraProbe(_gf1_data.base_port);
if (temp == NO_ULTRA)
	return(temp);

UltraDisableLineIn();
UltraDisableMicIn();
UltraDisableOutput();

temp = UltraReset(voices);
if (temp != ULTRA_OK)
	return(temp);

UltraSetInterface(_gf1_data.dram_dma_chan,_gf1_data.adc_dma_chan,
				  _gf1_data.gf1_irq_num,_gf1_data.midi_irq_num);

SetIrqHandlers(_gf1_data.gf1_irq_num,_gf1_data.midi_irq_num);

SetIrqs(_gf1_data.gf1_irq_num,_gf1_data.midi_irq_num);

UltraEnableOutput();

UltraMemInit();

return(ULTRA_OK);
}

int
UltraClose(void)
{
UltraDisableOutput();
UltraDisableLineIn();
UltraDisableMicIn();
UltraReset(14);
ResetIrqs(_gf1_data.gf1_irq_num,_gf1_data.midi_irq_num);
ReSetIrqHandlers(_gf1_data.gf1_irq_num,_gf1_data.midi_irq_num);
return(ULTRA_OK);
}


