;Plasma in 80x50 ModeX

.286
.model small
.stack 100h

GLOBAL  PLAZMA:PROC

.data
segment plaz

screen  dw 0

timeout dw 0

sinus   db 42,43,44,45,46,47,48,49,50,51
        db 52,53,54,55,56,57,58,59,60,61
        db 62,63,64,64,65,66,67,68,69,69
        db 70,71,72,72,73,74,74,75,76,76
        db 77,77,78,79,79,80,80,80,81,81
        db 82,82,82,82,83,83,83,83,84,84
        db 84,84,84,84,84,84,84,84,84,84
        db 84,83,83,83,83,82,82,82,82,81
        db 81,80,80,80,79,79,78,78,77,76
        db 76,75,74,74,73,72,72,71,70,69
        db 69,68,67,66,65,65,64,63,62,61
        db 60,59,58,57,56,55,54,53,52,51
        db 50,49,48,47,46,45,44,43,42,41
        db 40,39,38,37,36,35,34,33,32,31
        db 30,29,28,27,26,25,24,23,22,21
        db 20,20,19,18,17,16,15,15,14,13
        db 12,12,11,10,10,9,8,8,7,7
        db 6,6,5,5,4,4,3,3,2,2
        db 2,2,1,1,1,1,0,0,0,0
        db 0,0,0,0,0,0,0,0,0,1
        db 1,1,1,1,2,2,2,3,3,4
        db 4,4,5,5,6,6,7,8,8,9
        db 9,10,11,12,12,13,14,14,15,16
        db 17,18,19,19,20,21,22,23,24,25
        db 26,27,28,29,30,31,32,33,34,35
        db 36,37,38,39,40,41

mt1     dw 0
mt2     dw 0
mt3     dw 0

ax1     dw -2
ax2     dw 1
ax3     dw 4
ay1     dw 3
ay2     dw -3
ay3     dw 1
az1     dw 1
az2     dw -2
az3     dw 1

palette db 3 dup (0)
        i = 0
   REPT 63                      
        db 20+i/3,15+i/3,i      
    i = i+1
   ENDM
        db 20+i/3,15+i/3,i      
   REPT 63                      
        db 20+i/3,15+i/3,i
    i = i-1
   ENDM
        db 20+i/3,15+i/3,i      
   REPT 63             
        db i,15+i/3,20+i/3
    i = i+1
   ENDM
   REPT 63
        db i,15+i/3,20+i/3
    i = i-1
   ENDM
ends    plaz

.code
        call    plazma
        mov     ax,0003h
        int     10h
        mov     ax,4c00h
        int     21h



plazma  proc
        mov     ax,plaz
        mov     ds,ax
        assume  ds:plaz
        mov     ax,0012h
        int     10h
        mov     ax,0013h
        int     10h
        mov     ax,0a000h
        mov     es,ax
        mov     dx,3c4h
        mov     ax,0604h
        out     dx,ax
        mov     dx,3d4h
        mov     ax,0014h
        out     dx,ax
        mov     ax,0e317h
        out     dx,ax
        mov     ax,709h
        out     dx,ax
        mov     dx,3c4h
        mov     ax,0f02h
        out     dx,ax

        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,768
        lea     si,palette
load_pal:
        mov     al,[si]
        out     dx,al
        inc     si
        loop    load_pal

        mov     cx,40
init:
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        loop    init


animation_loop:
        call    plasma
        call    vertical
        cmp     timeout,50
        ja      no_fade_in_
        add     screen,80
no_fade_in_:
        cmp     timeout,650
        jb      no_fade_out_
        sub     screen,80
no_fade_out_:
        cmp     timeout,700
        jz      dos
        inc     timeout
        jmp     animation_loop
dos:
        xor     di,di
        mov     cx,80*50
        xor     ax,ax
        rep     stosw
        ret
endp    plazma

proc    plasma
        pusha
        xor     di,di
        
        mov     ax,mt1
        mov     bx,mt2
        mov     cx,mt3
        push    ax bx cx

strange_loop:
        mov     si,mt1
        mov     bx,mt2
        mov     dx,mt3

        mov     cx,80
draw_plasma:
        mov     al,sinus[si]
        add     al,sinus[bx]
        push    bx
        mov     bx,dx
        add     al,sinus[bx]
        pop     bx
        cmp     al,0
        jnz     ok_color
        mov     al,1
ok_color:
        stosb
        add     si,ax1
        and     si,0ffh
        add     bx,ax2
        and     bx,0ffh
        add     dx,ax3
        and     dx,0ffh
        loop    draw_plasma

        mov     ax,ay1
        add     mt1,ax
        and     mt1,255
        mov     ax,ay2
        add     mt2,ax
        and     mt2,255
        mov     ax,ay3
        add     mt3,ax
        and     mt3,255

        cmp     di,screen
        jb      strange_loop

        xor     ax,ax
        mov     cx,40
        rep     stosw

        pop     cx bx ax
        mov     mt1,ax
        mov     mt2,bx
        mov     mt3,cx

        mov     ax,az1
        add     mt1,ax
        and     mt1,255
        mov     ax,az2
        add     mt2,ax
        and     mt2,255
        mov     ax,az3
        add     mt3,ax
        and     mt3,255

        popa
        ret
endp    plasma

proc    vertical
        pusha
        mov     dx,3dah
vrt1:
        in      al,dx
        test    al,8
        jnz     vrt1
vrt2:
        in      al,dx
        test    al,8
        jz      vrt2
        popa
        ret
endp    vertical
end
