		ideal
		p386

		model	large,pascal
		codeseg
MACRO	waitvr	keepdx
	local	a
IFNB	<keepdx>
	push	dx
ENDIF
	mov	dx,03dah
a:
	in	al,dx
	test	al,8
	jz	a
IFNB	<keepdx>
	pop	dx
ENDIF
ENDM

; -- set_flame_palette -----------------------------------------
;
		udataseg
flame_ofs	dw	?
flame_incr	dw	?
		codeseg
label		make_pal_idx	byte
db	4,  0, 0, 0,  0, 0,20
db	36,  0, 0,20, 40, 0, 0
db	64, 40, 0, 0, 63,31, 0
db	64, 63,31, 0, 63,63, 0
db	64, 63,63, 0, 63,63,63
db	0
public		set_flame_palette
proc		set_flame_palette	far
	local	@@a:word
	pushad
	push	ds es
	mov	ax,SEG flame_ofs
	mov	ds,ax
	mov	[flame_ofs],0
	mov	[flame_incr],1
	mov	ax,SEG tmp_pal
	mov	es,ax
	mov	di,offset tmp_pal
	push	di
	xor	eax,eax
	mov	cx,300h/4
	rep	stosd
	pop	di
	xor	si,si
	xor	dx,dx
@@loop:
	movzx	cx,[si+make_pal_idx]
	add	dx,cx
	or	cl,cl
	jz	@@paldone
	inc	si
	xor	ch,ch
@@cluster:
	MACRO	onecolor	cofs
	mov	al,[si+3+cofs+make_pal_idx]
	sub	al,[si+cofs+make_pal_idx]
	imul	ch
	idiv	cl
	add	al,[si+cofs+make_pal_idx]
	mov	[es:di+cofs],al
	ENDM
	onecolor	0
	onecolor	1
	onecolor	2
	add	di,3
	inc	ch
	cmp	ch,cl
	jb	@@cluster
	add	si,6
	jmp	@@loop
@@paldone:
	mov	[@@a],dx
	waitvr
	mov	al,0
	call	fade_to_flame	; Output palette without changes (fade coef equal to zero)
	pop	es ds
	popad
	mov	ax,[@@a]
	ret
endp		set_flame_palette

; -- make_flame ------------------------------------------------
;
public		make_flame
proc		make_flame	far
	push	ax bx cx dx di
	push	ds es
	mov	ax,SEG flame_incr
	mov	ds,ax
	mov	ax,0a000h
	mov	es,ax
	mov	cx,8000
;	mov	di,[flame_ofs]
;	mov	dx,[flame_incr]
	mov	dx,2
	mov	di,320*2
	mov	cx,(200-4)/2*(320)/2
@@loadbx:
	mov	bx,160
@@loop:
	cmp	di,320*2
	jb	@@next
	cmp	di,(199-2)*320
	ja	@@next
	mov	al,[es:di]
	add	al,[es:di+2]
	mov	ah,0
	adc	ah,0
	add	al,[es:di-2]
	adc	ah,0
;	add	al,[es:di-320*2]
;	adc	ah,0
	add	al,[es:di+320*2]
	adc	ah,0
	REPT	1
	cmp	ax,1
	adc	ax,-1
	ENDM
	shr	ax,2
	cmp	ah,1
	sbb	ah,ah
	and	al,ah
	mov	ah,al
	mov	[es:di],ax
	mov	[es:di+320],ax
@@next:
	add	di,dx
	dec	cx
	jz	@@done
	dec	bx
	jnz	@@loop
	add	di,320
	jmp	@@loadbx
@@done:
	mov	[flame_ofs],di
	mov	[flame_incr],dx
	pop	es ds
	pop	di dx cx bx ax
	ret
endp		make_flame

; -- start_flame_fade ------------------------------------------
;
		ufardata	FLAME
tmp_pal	db	300h dup(?)
		codeseg
public		start_flame_fade
proc		start_flame_fade	far
	push	ax cx dx di es
	mov	ax,SEG tmp_pal
	mov	es,ax
	waitvr
	mov	dx,03c7h
	mov	al,0
	out	dx,al
	inc	dx
	inc	dx
	mov	di,offset tmp_pal
	mov	cx,300h
	rep	insb
	pop	es di dx cx ax
	ret
endp		start_flame_fade
; -- fade_to_flame ---------------------------------------------
;
tmp_pal_seg	dw	SEG tmp_pal
public		fade_to_flame
proc		fade_to_flame	far
	push	ax bx cx dx si ds
	sub	al,64
	sbb	ah,ah
	and	al,ah
	add	al,64	; Not more than 64
	mov	bl,al
	mov	ax,[tmp_pal_seg]
	mov	ds,ax
	mov	cx,100h
	mov	dx,03c8h
	mov	al,0
	out	dx,al
	inc	dx
	mov	si,offset tmp_pal
@@loop:
	mov	al,63
	sub	al,[si]
	imul	bl
	sar	ax,6
	add	al,[si]
	out	dx,al
	mov	al,63
	sub	al,[si+1]
	imul	bl
	sar	ax,6
	add	al,[si+1]
	out	dx,al
	mov	al,63
	sub	al,[si+2]
	imul	bl
	sar	ax,6
	add	al,[si+2]
	out	dx,al
	add	si,3
	dec	cx
	jnz	@@loop
	pop	ds si dx cx bx ax
	ret
endp		fade_to_flame
; -- fade_to_black ---------------------------------------------
;
public		fade_to_black
proc		fade_to_black	far
	push	ax bx cx dx si ds
	mov	bl,64
	sub	al,bl
	sbb	ah,ah
	and	al,ah
	add	al,bl	; Not more than 64
	sub	bl,al
	mov	ax,[tmp_pal_seg]
	mov	ds,ax
	mov	cx,300h
	mov	dx,03c8h
	mov	al,0
	out	dx,al
	inc	dx
	mov	si,offset tmp_pal
@@loop:
	lodsb
	imul	bl
	sar	ax,6
	out	dx,al
	dec	cx
	jnz	@@loop
	pop	ds si dx cx bx ax
	ret
endp		fade_to_black
; -- wait_vr ---------------------------------------------------
;
public		wait_vr
proc		wait_vr	far
	push	dx ax
	waitvr
	pop	ax dx
	ret
endp		wait_vr
; -- get_fade_pal_ptr ------------------------------------------
;
public		get_fade_pal_ptr
proc		get_fade_pal_ptr
	mov	es,[tmp_pal_seg]
	mov	di,offset tmp_pal
	ret
endp		get_fade_pal_ptr
		end
; -- make_flame ------------------------------------------------
;
public		make_flame
proc		make_flame	far
	push	ax bx cx dx di
	push	ds es
	mov	ax,SEG flame_incr
	mov	ds,ax
	mov	ax,0a000h
	mov	es,ax
	mov	cx,8000
	mov	di,[flame_ofs]
	mov	dx,[flame_incr]
@@loop:
	cmp	di,320
	jb	@@next
	cmp	di,198*320
	ja	@@next
	mov	ax,[es:di]
	add	al,ah
	mov	ah,0
	adc	ah,0
	add	al,[es:di-1]
	adc	ah,0
	add	al,[es:di-320]
	adc	ah,0
	add	al,[es:di+320]
	adc	ah,0
	REPT	3
	cmp	ax,1
	adc	ax,-1
	ENDM
	shr	ax,2
	cmp	ah,1
	sbb	ah,ah
	and	al,ah
	mov	[es:di],al
@@next:
	add	di,dx
	inc	dx
	dec	cx
	jnz	@@loop
	mov	[flame_ofs],di
	mov	[flame_incr],dx
	pop	es ds
	pop	di dx cx bx ax
	ret
endp		make_flame

