/*
 * Copyright (C) 1998, 1999 Wolfgang Moser
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Commodore CBM 1581 floppy disk copy util for PC's, FRMHEADR.C
 *
 * Redirected contact addresses:
 *   Wolfgang Moser <womo@mindless.com>
 *   Wolfgang Moser <womo@fairlight.to>
 *    http://www.dollar8000.de/womo
 *
 * Current workplace (up to Dezember 1999):
 *   Wolfgang Moser <womo@advm2.gm.fh-koeln.de>
 *    http://advm2.gm.fh-koeln.de/~womo
 *
 *
 * Basic informations from Dan Fandrich <dan@fch.wimsey.bc.ca>.
 *   His readme of the cbmfs-0.3 driver for Linux explained me, what the
 *   difference between a DOS formatted 800 kb disk and a CBM 1581 disk is.
 *   (check: http://vanbc.wimsey.com/~danf/software/)
 *
 *
 * Basic implementations by Ciriaco Garca de Celis <ciri@gui.uva.es>
 *   His util 765Debug, Version 5.0 is great for learning dma based
 *   direct floppy disk controller programming.
 *   (check: ftp://ftp.gui.uva.es/pub/pc/2m/765d50sr.zip)
 *
 * Check out for his floppy disk utils 2M and 2MGUI, the last words
 * in improving floppy disk storage capacity.
 *   http://www.gui.uva.es/2m, ftp://ftp.gui.uva.es/pub/pc/2m
 *
 *
 * For additional informations to FDC programming check:
 *     http://developer.intel.com/design/periphrl/datashts/290468.htm
 *   and get the intel 82078 CHMOS Single-Chip Floppy Disk Controller
 *   PDF document:
 *     http://www.intel.nl/design/periphrl/datashts/29047403.pdf
 *   National Semiconductor has also some pages about their PC
 *   compatible controllers:
 *     http://www.national.com/pf/DP/DP8473.html
 *     http://www.national.com/pf/DP/DP8477B.html
 *
 * Another good source for floppy disk controller programming information
 * are the linux kernal sources, you could have a look into:
 *     http://www.cs.utexas.edu/users/peterson/linux/include/linux/fdreg.h
 *     http://www.cs.utexas.edu/users/peterson/linux/drivers/block/floppy.c
 *
 * Now, that I started talking about Linux: Check out the most massive
 * attack against floppy disks ever made, Alain Knaff's fdutils:
 *     http://fdutils.linux.lu/
 *     http://alain.knaff.linux.lu/
 */

#include "frmheadr.h"

const unsigned char D81_BAM[]={
     2,  4,  1, 40,  3, 68,  0, 49, 53, 56, 49, 32, 67, 79, 80, 89,
    32, 70, 79, 82, 77, 65, 84,160,160, 48, 48,160, 51, 68,160,160,
     1,225,  0, 40,  2, 68,187, 48, 48,192,  1,  7,  0,  1,232,255,
    36,240,  1,  2,255,  0,255, 68,187, 48, 48,192,  1,  7,  0,  1,
   232,255, 40,  1,  3,255,  0,255,  4, 16,252,  0 };

const unsigned char D2M_BAM[]={
     2,  3,  2,  2,254,  0,  1, 34, 72,  0, 49, 53, 56, 49, 32, 67,
    79, 80, 89, 32, 70, 79, 82, 77, 65, 84,160,160, 48, 48,160, 49,
    72,160,160,  2,  1,  0,  1,  1,  2,222,  0, 72,183, 48, 48,192,
     0, 25,  2, 25,  0, 31,  3, 31,217,255,  0,255,  3,  5,252,  0
    };

const unsigned char D2M_SYS[]={
     2,  5,  4,  5,  4,255,  0,  4, 53,255,  0,  0,  4, 52,255,  0,
    12,  4, 52,255,  0,128,  4, 52,255,  0,  0,  1,  1,  4, 10,  0,
    67, 77, 68, 32, 70, 68, 32, 83, 69, 82, 73, 69, 83,  4,  1, 32,
     5,  1,254,  0,  1,  1,255,  0,  0, 83, 89, 83, 84, 69, 77,  4,
     8,160,  4, 11,  0,  1,  0,  0, 80, 65, 82, 84, 73, 84, 73, 79,
    78, 32, 49,  4,  3,160,  4,  7,  0, 12,128,  4,190,  0,  1,  2,
     4,252,  0,  1,  3,  4,253,  0,255,  5, 28,252,  0 };

void deRLE(const unsigned char *in, int size, unsigned char huge *out){
	int i, jump[5];
   unsigned char signs[5], maxS, c;
   unsigned long int len;
   enum jmpConsts{
	   Wrong=-1,
      Subst=5,
      Pow1=1,
      Pow2=2,
      Pow3=3,
      Pow4=4
	   };

	c=*in++;
	size--;
	for(i=4;i>=0;--i) jump[i]=Wrong;

   if(c){
	   maxS=(c&0x07)+((c&0x10)?1:0);
      for(i=0;i<maxS;++i) signs[i]=*in++, size--;
		for(;i<5;i++) signs[i]=*signs;

		if(c&0x10) jump[maxS-1]=Subst;
      for(i=maxS-((c&0x10)?2:1);i>=0;--i) jump[i]=maxS-((c&0x10)?1:0)-i;
      }

   for(;size>0;size--){
   	c=*in++;
   		// if c is in signs
   	for(i=maxS-1;i>=0;--i) if(signs[i]==c) break;
      if(i>=0){	// c is in signs
      	switch(jump[i]){
				default:
				case Wrong:
               return;
				case Subst:
            	*out++=*in++, size--;
               break;
				case Pow4:
				case Pow3:
				case Pow2:
				case Pow1:
					for(len=0ul,i=jump[i];i>0;--i) len<<=8, len|=*in++, size--;
					c=*in++, size--;
					for(len+=2;len;--len) *out++=c;
         	}
      	}
      else *out++=c;
   	}
	}

// create an empty CMD FD2000 style BAM
//
// input:  buffer:	a pointer to the buffer location,
//							where the BAM should be created (0x2400 bytes)
// output: none
//
void FD2000createBAM(unsigned char huge *buffer){
	deRLE(D2M_BAM,	sizeof(D2M_BAM), buffer);
	}

// create a CMD FD2000 style system partition
//
// input:  buffer:	a pointer to the buffer location,
//							where the partition should be created (0x0c00 bytes)
// output: none
//
void FD2000createSYS(unsigned char huge *buffer){
	deRLE(D2M_SYS, sizeof(D2M_SYS), buffer);
	}

// create an empty CBM 1581 style BAM
//
// input:  buffer:	a pointer to the buffer location,
//							where the BAM should be created (0x400 bytes)
// output: none
//
void C1581createBAM(unsigned char huge *buffer){
	int i;
   unsigned char huge *p1;

	deRLE(D81_BAM, sizeof(D81_BAM), buffer);

   p1=buffer+0x110;
   for(i=0x26;i>=0;--i){
		*p1=*(p1+0x100)=0x28;
      p1+=6;
      }
	}

