//
// Key class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Key.h"




Key::Key()
{
    // defaults
    m_code = UNDEFINED;
    m_alt = false;
    m_shift = false;
    m_control = false;
}


Key::Key(int code)
{
    // setup data
    m_code = code;
    m_alt = false;
    m_shift = false;
    m_control = false;
}


Key::Key(int id,bool alt,bool shift,bool control)
{
    // setup data
    m_code = id;
    m_alt = alt;
    m_shift = shift;
    m_control = control;
}




int Key::code() const
{
    // get key code
    return m_code;
}




bool Key::alt() const
{
    // get alt flag
    return m_alt;
}


bool Key::shift() const
{
    // get shift flag
    return m_shift;
}


bool Key::control() const
{
    // get control flag
    return m_control;
}
