;
;
; Shock integrated Virtual Video Engine (SIVE) 1.3
;
; Developed by Tsc/Shock! in 1995-96
;
;
;
; (Non) Linear Framebuffer & (Non) Truecolor Routines
;
; Hivetest        - Checking, Detecting, etc.
; Set640x480x8    - Sets real 640x480 (linear) mode
; Set640x480x24   - Sets real 640x480 linear truecolor mode
; Set320x200x24   - Sets real 320x200 linear truecolor mode
; Set320x200x24p  - Sets 320x200 linear pseudo-truecolor mode
; Disp320x200x24p - Displays a 320x200 pseudo-truecolor image
; Disp640x480x8   - Displays a 640x480x8 image
; Setpal8         - Sets a 8 bit color palette
; Setpal4         - Sets a 4 bit color palette
; DarkenPal       - Clears the actual 8 bit pal
; Set80x25x16     - Sets dos textmode
; Addpic          - Esi, Edi, Ecx - Adds two truecolor images
; Subpic          - Esi, Edi, Ecx - Subtracts two truecolor images
; ExchangeRB      - Esi, Ecx - Exchgs the Red and Blue components of the image
; Palmorph        - Morphs two palettes
; Rasterwait      - Guess what?
;
;

                truecolor320    db 0    ;0 - 32bit truecolor, vbe2 linear
                                        ;1 - 24bit truecolor, vbe2 linear
                                        ;2 - pseudo, vbe2 linear
                                        ;3 - pseudo, mode_x planar

                needsvesa20     db 0    ;0 - nope
                                        ;1 - yes

;

                public  hivetest
                public  set640x480x8
                public  set640x480x24
                public  set320x200x24p
                public  set80x25x16
                public  setpal8
                public  setpal4
                public  darkenpal
                public  disp640x480x8
                public  exchangerb
                public  addpic
                public  subpic
                public  rasterwait
                public  palmorph

                extrn   vesa_addy       :dword
                extrn   vesa_granularity:dword

;
;
; Real Truecolor 640x480 routines for Watcom C protected mode
;
; by Tsc/Shock!
;
;

addpic:         pushad
                mov     eax,0
addpicloop:     lodsb
                jz      addpicnuller
                movzx   ebx,byte ptr [edi]
                add     ebx,eax
                cmp     ebx,255
                ja      addpicoverflow
                add     [edi],al
                jmp     addpicnuller
addpicoverflow: mov     byte ptr [edi],255
addpicnuller:   inc     edi
                loop    addpicloop
                popad
                ret

subpic:         pushad
subpicloop:     lodsb
                jz      subpicnuller
                cmp     al,byte ptr [edi]
                jae     subpicoverflow
                sub     byte ptr [edi],al
                jmp     subpicnuller
subpicoverflow: mov     byte ptr [edi],0
subpicnuller:   inc     edi
                loop    subpicloop
                popad
                ret

addbox:         pushad
                push    eax             ;esi - kep
                push    ebx             ;eax, ebx: x1,y1
                push    edx             ;ecx, edx: x2,y2
                xchg    eax,ebx
                mov     ebp,640
                mul     ebp
                add     eax,ebx         ;creating offset
                mov     ebp,3
                mul     ebp             ;mul by 3 becoz of truecolor mode
                add     esi,eax         ;got the final offset
                pop     edx
                pop     ebx
                pop     eax             ;back to the initial state ;)
                sub     ecx,eax
                sub     edx,ebx
                lea     ecx,[ecx+2*ecx] ;ecx=3*ecx
                xchg    edx,ecx
addboxloop1:    push    ecx
                mov     ecx,edx
addboxloop2:    shr     byte ptr [esi+ecx],1
                loop    addboxloop2
                shr     byte ptr [esi],1
                pop     ecx
                add     esi,640*3       ;should be *4 for 32bit color cards
                loop    addboxloop1
                popad
                ret

subbox:         pushad
                push    eax
                push    ebx
                push    edx
                xchg    eax,ebx
                mov     ebp,640
                mul     ebp
                add     eax,ebx         ;creating offset
                mov     ebp,3
                mul     ebp             ;mul by 3 becoz of truecolor mode
                add     esi,eax         ;got the final offset
                pop     edx
                pop     ebx
                pop     eax             ;back to the initial state ;)
                sub     ecx,eax
                sub     edx,ebx
                lea     ecx,[ecx+2*ecx] ;ecx=3*ecx
                xchg    edx,ecx
subboxloop1:    push    ecx
                mov     ecx,edx
subboxloop2:    shl     byte ptr [esi+ecx],1
                loop    subboxloop2
                shl     byte ptr [esi],1
                pop     ecx
                add     esi,640*3       ;should be *4 for 32bit color cards
                loop    subboxloop1
                popad
                ret

mem2screen24:   pushad
                mov     edi,vesa_addy
                mov     ecx,921600/4
                rep     movsd
                popad
                ret

exchangerb:     pushad
exchloop:       mov     al,byte ptr [esi]
                xchg    al,byte ptr [esi+2]
                mov     byte ptr [esi],al
                add     esi,3
                sub     ecx,3
                jnz     exchloop
                popad
                ret

set640x480x8:   pushad
                cmp     vesa_addy,0
                jne     l640go
                mov     bx,101h
                mov     ax,4f02h
                int     10h
                cmp     al,4fh
                je      settok
                lea     edx,verror005
                jmp     hiveerror

l640go:         mov     bx,4101h
                jmp     vesamodeset

set640x480x24:  pushad
                mov     bx,4112h
                jmp     vesamodeset

vesamodeset:    mov     ax,4f02h
                int     10h
                cmp     al,4fh
                je      settok
                lea     edx,verror001           ; absolutely no vesa present
                jmp     hiveerror
settok:         cmp     ah,0
                je      truesupp
                lea     edx,verror002           ; cant do linear frame buffering
                jmp     hiveerror
truesupp:       popad
                ret

set80x25x16:    pushad
                mov     ax,3
                int     10h
                popad
                ret

hivetest:       pushad
                mov     ax,1600h             ; Windows alatt vagyunk ?
                int     2fh
                or      al,80h
                cmp     al,80h
                je      windowsok
                lea     edx,verror006
                jmp     hiveerror
windowsok:      lea     edx,emmname
                mov     ax,3d00h
                int     21h
                jc      emsok
                lea     edx,verror007
                jmp     hiveerror
emsok:          mov     ax,1687h
                int     2fh
                or      ax,ax
                jnz     dpmiok
                lea     edx,verror008
                jmp     hiveerror
dpmiok:         smsw    ax
                test    al,1
                jnz     v86ok
                lea     edx,verror003
                jmp     hiveerror
v86ok:          mov     ax,3
                int     10h
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                cmp     vesa_addy,0
                je      csaktweak
                mov     truecolor320,2
                jmp     conts
csaktweak:      mov     truecolor320,3
conts:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                ;call    siveasking
                popad
                ret

hiveerror:      mov     ax,3
                int     10h
                push    edx
                lea     edx,vesaerror1
                mov     ah,9
                int     21h
                pop     edx
                mov     ah,9
                int     21h
                lea     edx,vesaerror2
                mov     ah,9
                int     21h
                mov     ax,4c00h
                int     21h

siveasking:     lea     edx,siveasking0
                mov     ah,9
                int     21h
setupredo:      mov     ax,0
                int     16h
                cmp     al,30h
                jb      setupredo
                cmp     al,33h
                ja      setupredo
                sub     al,30h
                mov     truecolor320,al
                ret

;
;
; SVGA 8 bit routines for Watcom C protected mode
;
; by Tsc/Shock!
;
;

grantemp        dd      0

disp640x480x8:  mov     esi,[esp+4]
                cmp     vesa_addy,0
                je      dispvesa12
                mov     edi,vesa_addy
                mov     ecx,307200/4
                rep     movsd
                ret

dispvesa12:     xor     edx,edx
                mov     eax,64
                div     vesa_granularity
                mov     grantemp,eax
                mov     ecx,16384
                mov     eax,0
                call    vesa_640_loop
                mov     ecx,16384
                mov     eax,1
                call    vesa_640_loop
                mov     ecx,16384
                mov     eax,2
                call    vesa_640_loop
                mov     ecx,16384
                mov     eax,3
                call    vesa_640_loop
                mov     ecx,45056/4
                mov     eax,4
                call    vesa_640_loop
                ret

vesa_640_loop:  mul     grantemp
                mov     edx,eax
                mov     ebx,0
                mov     eax,4f05h
                int     10h
                mov     edi,0a0000h
                rep     movsd
                ret

setpal8:        mov     esi,[esp+4]
                mov     edx,3c8h
                mov     al,0
                out     dx,al
                inc     edx
                mov     ecx,768
                rep     outsb
                ret

setpal4:        mov     esi,[esp+4]
                mov     edx,3c8h
                mov     al,0
                out     dx,al
                inc     edx
                mov     ecx,48
                rep     outsb
                ret

darkenpal:      mov     edx,3c8h
                mov     al,0
                out     dx,al
                inc     edx
                mov     al,0
                mov     ecx,768
clrpl:          out     dx,al
                loop    clrpl
                ret

palmorph:       mov     esi,[esp+4]
                mov     edi,[esp+8]
                mov     ecx,0
palmorpl:       mov     al,[esi+ecx]
                cmp     al,[edi+ecx]
                je      overmorph
                ja      amorph
                inc     byte ptr [esi+ecx]
                jmp     overmorph
amorph:         dec     byte ptr [esi+ecx]
overmorph:      inc     ecx
                cmp     ecx,768
                jne     palmorpl
                ret

;
;
; Pseudo-Truecolor routines for Watcom C protected mode
;
; by Tsc/Shock!
;
;

set320x200x24p:
                cmp     truecolor320,3
                je      setxtrue
                cmp     truecolor320,2
                je      setltrue
                mov     ax,4f02h        ; vesa 320x200 linear truecolor mode
                mov     bx,410fh
                int     10h
                ret
setltrue:       mov     ax,4f02h        ; vesa 320x400 linear 256 color mode
                mov     bx,4155h
                int     10h
cont001:        mov     edx,3C8h
                mov     eax,0
                out     dx,al
                inc     edx
                mov     ecx,768
                lea     esi,truepal     ; setting palette for pseudo truecolor
                rep     outsb
                ret

setxtrue:       call    set320x400x256  ; mode_x 320x400 planar mode
                mov     edx,3C8h
                mov     eax,0
                out     dx,al
                inc     edx
                mov     ecx,768
                lea     esi,truepal     ; setting palette for pseudo truecolor
                rep     outsb
                ret

disp320x200x24p:
                pushad
                call    displogo
                mov     esi,edi         ; ebp - picture (64000 bytes)
                cmp     truecolor320,3
                je      disptcx
                mov     edi,vesa_addy   ; esi - buffer (128000 bytes)
                cmp     truecolor320,2
                je      disptcl
                call    rasterwait
                mov     ecx,192000/4
                rep     movsd
                popad
                ret
disptcl:        call    rasterwait
                mov     ecx,128000/4
                rep     movsd
                popad
                ret

displogo:       pushad
                mov     edi,truebuf
                add     edi,(320*20)+(320-120)
                lea     esi,statelogo   ; logo option agybaszas?
                mov     ecx,25
bugo1:          push    ecx
                mov     ecx,110
bugo11:         lodsb
                cmp     al,0
                jz      bugo2
                mov     [edi],al
bugo2:          inc     edi
                loop    bugo11
                pop     ecx
                add     edi,320-110
                loop    bugo1
                popad
                ret

disptcx:        call    disp320x400x256
                popad
                ret

mov320x200x24p: cmp     truecolor320,1
                je      mov320x200x24
                pushad
                mov     ecx,67
truecalc1:      push    ecx
                mov     ecx,2
truerow:        push    ecx
                mov     ecx,320/2
truerowplus:    push    ecx

                xor     ecx,ecx
                mov     cl,[ebp]
                lea     ecx,[ecx+2*ecx]
                mov     eax,dword ptr [esi+ecx]
                mov     dl,[edi+20]
                mov     [edi],al
                shr     eax,8
                or      ax,64+(256*128)
                mov     dl,[edi+320+20]
                mov     [edi+320],al
                inc     ebp
                mov     dl,[edi+640+20]
                mov     [edi+640],ah
                inc     edi

                xor     ecx,ecx
                mov     cl,[ebp]
                lea     ecx,[ecx+2*ecx]
                mov     eax,dword ptr [esi+ecx]
                mov     dl,[edi+320+20]
                mov     [edi+320],al
                shr     eax,8
                or      ax,64+(256*128)
                mov     dl,[edi+320+320+20]
                mov     [edi+320+320],al
                inc     ebp
                mov     dl,[edi+640+320+20]
                mov     [edi+640+320],ah
                inc     edi

                pop     ecx
                dec     ecx
                jnz     truerowplus
                add     edi,640
                pop     ecx
                dec     ecx
                jnz     truerow
                add     ebp,320
                pop     ecx
                dec     ecx
                jnz     truecalc1
                popad
                ret

add320x200x24p: cmp     truecolor320,1
                je      add320x200x24
                pushad
                mov     ecx,67
                xor     edx,edx
truecalc2:      push    ecx
                mov     ecx,2
truerow2:       push    ecx
                mov     ecx,320/2
truerowplus2:   push    ecx
                xor     ecx,ecx
                mov     cl,[ebp]
                lea     ecx,[ecx+2*ecx]
                mov     eax,dword ptr [esi+ecx]
                mov     dl,[edi]
                lea     edx,[edx+2*edx]
                add     dl,al
                shr     dl,2
                mov     [edi],dl
                shr     eax,8
                mov     dl,[edi+320]
                and     dl,63
                lea     ebx,[edx+2*edx]
                add     bl,al
                shr     bl,2
                or      bl,64
                mov     dl,[edi+640]
                and     dl,127
                lea     edx,[edx+2*edx]
                add     dl,ah
                shr     dl,2
                or      dl,128
                xor     ecx,ecx
                mov     [edi+640],dl
                mov     cl,[ebp+1]
                lea     ecx,[ecx+2*ecx]
                mov     eax,[esi+ecx]
                mov     dl,[edi+320+1]
                lea     edx,[edx+2*edx]
                add     dl,al
                shr     dl,2
                mov     bh,dl
                mov     [edi+320],bx
                shr     eax,8
                mov     dl,[edi+640+1]
                and     dl,63
                lea     edx,[edx+2*edx]
                add     dl,al
                shr     dl,2
                or      dl,64
                mov     [edi+640+1],dl
                mov     dl,[edi+960+1]
                and     dl,127
                lea     edx,[edx+2*edx]
                add     dl,ah
                shr     dl,2
                or      dl,128
                mov     [edi+960+1],dl
                add     ebp,2
                add     edi,2
                pop     ecx
                dec     ecx
                jnz     truerowplus2
                add     edi,640
                pop     ecx
                dec     ecx
                jnz     truerow2
                add     ebp,320
                pop     ecx
                dec     ecx
                jnz     truecalc2
                popad
                ret

add320x200x24p2:cmp     truecolor320,1
                je      add320x200x24
                pushad
                mov     ecx,67
                xor     edx,edx
truecalc22:     push    ecx
                mov     ecx,2
truerow22:      push    ecx
                mov     ecx,320/2
truerowplus22:  push    ecx
                xor     ecx,ecx
                mov     cl,[ebp]
                or      cl,cl
                je      bugjes1
                lea     ecx,[ecx+2*ecx]
                mov     eax,dword ptr [esi+ecx]
                mov     dl,[edi]
                lea     edx,[edx+2*edx]
                add     dl,al
                shr     dl,2
                mov     [edi],dl
                shr     eax,8
                mov     dl,[edi+320]
                and     dl,63
                lea     ebx,[edx+2*edx]
                add     bl,al
                shr     bl,2
                or      bl,64
                mov     dl,[edi+640]
                and     dl,127
                lea     edx,[edx+2*edx]
                add     dl,ah
                shr     dl,2
                or      dl,128
                xor     ecx,ecx
                mov     [edi+640],dl
bugjes1:        mov     cl,[ebp+1]
                or      cl,cl
                je      bugjes2
                lea     ecx,[ecx+2*ecx]
                mov     eax,[esi+ecx]
                mov     dl,[edi+320+1]
                lea     edx,[edx+2*edx]
                add     dl,al
                shr     dl,2
                mov     bh,dl
                mov     [edi+320],bx
                shr     eax,8
                mov     dl,[edi+640+1]
                and     dl,63
                lea     edx,[edx+2*edx]
                add     dl,al
                shr     dl,2
                or      dl,64
                mov     [edi+640+1],dl
                mov     dl,[edi+960+1]
                and     dl,127
                lea     edx,[edx+2*edx]
                add     dl,ah
                shr     dl,2
                or      dl,128
                mov     [edi+960+1],dl
bugjes2:        add     ebp,2
                add     edi,2
                pop     ecx
                dec     ecx
                jnz     truerowplus22
                add     edi,640
                pop     ecx
                dec     ecx
                jnz     truerow22
                add     ebp,320
                pop     ecx
                dec     ecx
                jnz     truecalc22
                popad
                ret

truepal:
db 000h,000h,000h,001h,000h,000h,001h,000h,000h,003h
db 000h,000h,004h,000h,000h,005h,000h,000h,006h,000h
db 000h,007h,000h,000h,009h,000h,000h,00ah,000h,000h
db 00bh,000h,000h,00ch,000h,000h,00dh,000h,000h,00fh
db 000h,000h,010h,000h,000h,011h,000h,000h,012h,000h
db 000h,013h,000h,000h,015h,000h,000h,016h,000h,000h
db 017h,000h,000h,018h,000h,000h,01ah,000h,000h,01bh
db 000h,000h,01ch,000h,000h,01dh,000h,000h,01eh,000h
db 000h,020h,000h,000h,021h,000h,000h,022h,000h,000h
db 023h,000h,000h,024h,000h,000h,026h,000h,000h,026h
db 000h,000h,027h,000h,000h,028h,000h,000h,029h,000h
db 000h,02ah,000h,000h,02ah,000h,000h,02bh,000h,000h
db 02ch,000h,000h,02dh,000h,000h,02eh,000h,000h,02eh
db 000h,000h,02fh,000h,000h,030h,000h,000h,031h,000h
db 000h,032h,000h,000h,033h,000h,000h,033h,000h,000h
db 034h,000h,000h,035h,000h,000h,036h,000h,000h,037h
db 000h,000h,037h,000h,000h,038h,000h,000h,039h,000h
db 000h,03ah,000h,000h,03bh,000h,000h,03bh,000h,000h
db 03ch,000h,000h,03dh,000h,000h,03eh,000h,000h,03fh
db 000h,000h,000h,000h,000h,000h,001h,000h,000h,001h
db 000h,000h,003h,000h,000h,004h,000h,000h,005h,000h
db 000h,006h,000h,000h,007h,000h,000h,009h,000h,000h
db 00ah,000h,000h,00bh,000h,000h,00ch,000h,000h,00dh
db 000h,000h,00fh,000h,000h,010h,000h,000h,011h,000h
db 000h,012h,000h,000h,013h,000h,000h,015h,000h,000h
db 016h,000h,000h,017h,000h,000h,018h,000h,000h,01ah
db 000h,000h,01bh,000h,000h,01ch,000h,000h,01dh,000h
db 000h,01eh,000h,000h,020h,000h,000h,021h,000h,000h
db 022h,000h,000h,023h,000h,000h,024h,000h,000h,026h
db 000h,000h,026h,000h,000h,027h,000h,000h,028h,000h
db 000h,029h,000h,000h,02ah,000h,000h,02ah,000h,000h
db 02bh,000h,000h,02ch,000h,000h,02dh,000h,000h,02eh
db 000h,000h,02eh,000h,000h,02fh,000h,000h,030h,000h
db 000h,031h,000h,000h,032h,000h,000h,033h,000h,000h
db 033h,000h,000h,034h,000h,000h,035h,000h,000h,036h
db 000h,000h,037h,000h,000h,037h,000h,000h,038h,000h
db 000h,039h,000h,000h,03ah,000h,000h,03bh,000h,000h
db 03bh,000h,000h,03ch,000h,000h,03dh,000h,000h,03eh
db 000h,000h,03fh,000h,000h,000h,000h,000h,000h,001h
db 000h,000h,001h,000h,000h,003h,000h,000h,004h,000h
db 000h,005h,000h,000h,006h,000h,000h,007h,000h,000h
db 009h,000h,000h,00ah,000h,000h,00bh,000h,000h,00ch
db 000h,000h,00dh,000h,000h,00fh,000h,000h,010h,000h
db 000h,011h,000h,000h,012h,000h,000h,013h,000h,000h
db 015h,000h,000h,016h,000h,000h,017h,000h,000h,018h
db 000h,000h,01ah,000h,000h,01bh,000h,000h,01ch,000h
db 000h,01dh,000h,000h,01eh,000h,000h,020h,000h,000h
db 021h,000h,000h,022h,000h,000h,023h,000h,000h,024h
db 000h,000h,026h,000h,000h,026h,000h,000h,027h,000h
db 000h,028h,000h,000h,029h,000h,000h,02ah,000h,000h
db 02ah,000h,000h,02bh,000h,000h,02ch,000h,000h,02dh
db 000h,000h,02eh,000h,000h,02eh,000h,000h,02fh,000h
db 000h,030h,000h,000h,031h,000h,000h,032h,000h,000h
db 033h,000h,000h,033h,000h,000h,034h,000h,000h,035h
db 000h,000h,036h,000h,000h,037h,000h,000h,037h,000h
db 000h,038h,000h,000h,039h,000h,000h,03ah,000h,000h
db 03bh,000h,000h,03bh,000h,000h,03ch,000h,000h,03dh
db 000h,000h,03eh,000h,000h,03fh


db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h
db 000h,000h,000h,000h,000h,000h,03fh,03fh,03fh,03dh
db 03dh,03dh,03ah,03ah,03ah,038h,038h,038h,036h,036h
db 036h,034h,034h,034h,032h,032h,032h,030h,030h,030h
db 02eh,02eh,02eh,02ch,02ch,02ch,029h,029h,029h,027h
db 027h,027h,025h,025h,025h,023h,023h,023h,021h,021h
db 021h,01fh,01fh,01fh,01dh,01dh,01dh,01bh,01bh,01bh
db 018h,018h,018h,016h,016h,016h,014h,014h,014h,012h
db 012h,012h,010h,010h,010h,00eh,00eh,00eh,00ch,00ch
db 00ch,00ah,00ah,00ah,007h,007h,007h,005h,005h,005h
db 003h,003h,003h,001h,001h,001h,000h,000h,000h,03fh
db 03fh,03fh
                
;
;
; Real truecolor 320x200 mode routines for Watcom C protected mode
;
; by Tsc/Shock!
;
;

mov320x200x24:  pushad
                mov     ecx,320*200
tc320rowloop:   push    ecx
                xor     ecx,ecx
                mov     cl,[ebp]
                lea     ecx,[ecx+2*ecx]
                mov     eax,dword ptr [esi+ecx]
                xchg    al,ah
                shl     eax,2
                mov     [edi],eax
                inc     ebp
                add     edi,3
                pop     ecx
                dec     ecx
                jnz     tc320rowloop
                popad
                ret

add320x200x24:  pushad
                mov     ecx,320*200
addrealtcloop:  push    ecx
                xor     ecx,ecx
                mov     cl,[ebp]
                lea     ecx,[ecx+2*ecx]
                mov     eax,dword ptr [esi+ecx]
                xor     edx,edx
                mov     dl,[edi+1]
                shr     dl,2
                lea     ecx,[edx+2*edx]
                add     cl,al
                mov     ch,cl
                shr     eax,8
                xor     edx,edx
                mov     dl,byte ptr[edi]
                shr     dl,2
                lea     edx,[edx+2*edx]
                add     dl,al
                mov     cl,dl
                xor     edx,edx
                mov     dl,byte ptr[edi+2]
                shr     dl,2
                lea     edx,[edx+2*edx]
                add     dl,ah
                mov     [edi],cx
                mov     [edi+2],dl
                add     edi,3
                inc     ebp
                pop     ecx
                dec     ecx
                jnz     addrealtcloop
                popad
                ret

;
;
; Mode_X routines for Watcom C protected mode
;
; by Tsc/Shock!
;
;

; Sequencer registers 

                Seq_Index   =  3C4h      ; Sequencer Registers Adress
                CrtC_Index  =  3D4h      ; CRTC Adress Register
                Graph_Index =  3CEh      ; Graphics Adress Register
                Attr_Index  =  3C0h      ; Atribute Controller Write
                Misc_Output =  3C2h      ; Miscellaneous Output Register

; Plane definitions 

                PLANE_0     =  0102h
                PLANE_1     =  0202h
                PLANE_2     =  0402h
                PLANE_3     =  0802h
                ALL_PLANES  =  0F02h
                READ_PLANE_0=  0004h
                READ_PLANE_1=  0104h
                READ_PLANE_2=  0204h
                READ_PLANE_3=  0304h

; Mode definitions 

Label data320x400x256
                DW      04009h           ; Cellheight (1)
                DW      00014h           ; Underline Location (disable dword mode)
                DW      0e317h           ; Mode Control (enable byte mode)

; Mode settings 

set320x400x256:
                pushad
                mov     ax,0013h         ; Videomode 13h  320*200*256
                int     10h              ; Set the mode
                mov     dx,Seq_Index     ; Sequencer Address Register
                mov     al,04h           ; Index 4 - Memory mode
                out     dx,al
                inc     dx               ; 03c5h - Data register => set the mem mode here
                in      al,dx
                and     al,11110111b     ; Disable 3rd bit will give us unchained memory
                or      al,00000100b     ; Bit 2 enabled => no odd/even-scheme
                out     dx,al
                cld                      ; Clear direction flag (si increased)
                xor     ax,ax            ; Empty ax
                mov     dx,CrtC_Index    ; Port 03d4h
                mov     cx,3             ; Number of entries
                lea     esi,data320x400x256
ParamLoop:      lodsw                    ; Load pair of index/data values
                out     dx,ax            ; Out them to CrtC Register
                loop    ParamLoop
                mov     dx,Seq_Index     ; Select port 03c4h
                mov     ax,00f02h        ; Map Mask Register (select all planes)
                out     dx,ax
                mov     edi,0a0000h      ; Set es:di to point to screenmem  di=0
                xor     eax,eax          ; Color to store = usually black = 0
                mov     cx,16384         ; 32768 (words) * 2 = 65536 bytes = 1 plane
                cld                      ; Clear dirflag => di is increased
                rep     stosd            ; Clear all 4 planes using wordwrites
                popad
                ret

; Displaying 

actscreen       dd      0

disp320x400x256:pushad
                mov     eax,actscreen
                mov     dx,3d4h
                mov     ah,al
                mov     al,0dh
                out     dx,ax
                mov     eax,actscreen
                mov     al,0ch
                out     dx,ax
                xor     actscreen,8000h
                mov     ebp,esi
                call    rasterwait
                mov     dx,Seq_Index
                mov     ax,PLANE_0
                call    oneplane
                mov     ax,PLANE_1
                inc     ebp
                call    oneplane
                mov     ax,PLANE_2
                inc     ebp
                call    oneplane
                mov     ax,PLANE_3
                inc     ebp
                call    oneplane
                popad
                ret

oneplane:       out     dx,ax
                mov     esi,ebp
                mov     edi,0a0000h
                add     edi,actscreen
                mov     ecx,8000
dlo1:           mov     al,[esi]
                mov     ah,[esi+4]
                shl     eax,16
                mov     al,[esi+8]
                mov     ah,[esi+12]
                rol     eax,16
                mov     [edi],eax
                add     edi,4
                add     esi,16
                dec     ecx
                jnz     dlo1
                ret

; Other Routines 

rasterwait:     push    ax dx            ;ez a rutin megvrja, hogy
                mov     dx,3dah          ;az elektronsugr a kperny
ras11:          in      al,dx            ;tetejhez rjen
                and     al,8
                je      ras11
ras22:          in      al,dx
                and     al,1
                je      ras22
                pop     dx ax
                ret

ki:             push    ax dx
                mov     dx,3c8h
                mov     al,0
                out     dx,al
                inc     dx
                mov     al,0
                out     dx,al
                out     dx,al
                out     dx,al
                pop     dx ax
                ret

be:             push    ax dx
                mov     dx,3c8h
                mov     al,0
                out     dx,al
                inc     dx
                mov     al,0
                out     dx,al
                out     dx,al
                mov     al,63
                out     dx,al
                pop     dx ax
                ret

; Data & Messages 

emmname         db      'EMMXXXX0',0

vesaerror1      db      'ͻ'
                db      '          Shock Integrated Virtual Video Engine (SIVE) error message:         '
                db      '͹'
                db      '                                                                              ','$'
verror001       db      '            Vesa 2.0 or higher not detected. Please install UNIVBE!           ','$'
verror002       db      '            Your videocard does not support linear frame buffering!           '
                db      '        Please load UNIVBE first, that will probably solve the problem.       ','$'
verror003       db      '   Your system is already in V86 mode! Linear frame buffering is impossible!  ','$'
verror004       db      '               Your videocard does not support true color modes!              ','$'
verror005       db      '                  Not enough video memory for requested mode!                 ','$'
verror006       db      '        This software is not able to run under Microsoft Windows (tm)!        ','$'
verror007       db      ' You have to remove your EMM manager to make linear frame buffering possible! ','$'
verror008       db      '  You must remove your DPMI manager to make linear frame buffering possible!  ','$'
vesaerror2      db      '                                                                              '
                db      'ͼ','$'
siveasking0     db      'ͻ'
                db      '         Shock Integrated Virtual Video Engine (SIVE) Initialization:         '
                db      '͹'
                db      '                                                                              '
                db      ' Key  Res.  Colors  Hardware Requirements [+ pentium 12o cpu assumed - hehe]  '
                db      '                                                                              '
                db      '  0. 320x200 32bit  UniVBE, 32bit color vga card (like S3), linear fr.buffer  '
                db      '  1. 320x200 24bit  UniVBE, 24bit color vga card (generic), linear fr.buffer  '
                db      '  2. 320x200 18bit  UniVBE, 256 color vga card (hehe), linear fr. buffer      '
                db      '  3. 320x200 18bit  Will run on any vga card, but rather slow...              '
                db      '                                                                              '
                db      'ͼ','$'
