//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-09
// Revision (please increase number) : A1
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________

#ifndef __SHINEPLUGIN_H
#define __SHINEPLUGIN_H

#include "simage.h"
#include "slib.h"

//________________________________________________________________________________________________________________________________________________________________________

#define cMaxPluginParameterSize 1024

//________________________________________________________________________________________________________________________________________________________________________

enum eShinePluginEvent_t {
	cSPNoEvent, cSPMouseOver, cSPMouseAway, cSPMouseLeft
};

//________________________________________________________________________________________________________________________________________________________________________

enum eShineAction_t {
	cSANoAction, cSAFollowLink
};

//________________________________________________________________________________________________________________________________________________________________________

struct rShinePluginInformation_t {
	float			Version;
	long			xres, yres;
	long			refreshTime;
	char			parameter[cMaxPluginParameterSize];
	long*			renderBuffer;
	long			backColor;
	long			color;
	char			libraryName[256];
	int				ID;
	char			link[cMaxPluginParameterSize];
};

//________________________________________________________________________________________________________________________________________________________________________

struct rShinePluginUpdate_t {
	int				musicVolume;
	int				musicLeft;
	int				musicRight;
	int				mouseX;
	int				mouseY;
};

//________________________________________________________________________________________________________________________________________________________________________

struct rShinePluginAction_t {
	eShineAction_t eShineAction;
	union {
		char linkFilename[256];
	}u;
};

//________________________________________________________________________________________________________________________________________________________________________

typedef void  (* FUNCPTR)( int ID );
typedef void  (* FUNCPTR2)( rShinePluginInformation_t rShinePluginInformation );
typedef void  (* FUNCPTR3)( int timer, int ID, rShinePluginUpdate_t rShinePluginUpdate );
typedef rShinePluginAction_t* (* FUNCPTR4)( eShinePluginEvent_t eShinePluginEvent, int mouseX, int mouseY, int ID );

//________________________________________________________________________________________________________________________________________________________________________

class shinePlugin {
	private:
	public:
		shinePlugin*	pNext;
		shinePlugin*	pPrev;
		int				width;
		int				height;
		unsigned long	interval;
		int				ID;
		HINSTANCE		Lib;
		shineImage*		Image;
		eShinePluginEvent_t eLastEvent;

		FUNCPTR  close;
		FUNCPTR2 open;
		FUNCPTR3 update;
		FUNCPTR4 event;

		shinePlugin()
		{
			Image = new shineImage();
			eLastEvent = cSPNoEvent;
		}

		~shinePlugin()
		{
			close( ID );
			delete Image;
		}
};

//________________________________________________________________________________________________________________________________________________________________________

#endif