//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-29
// Revision (please increase number) : A2
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________
//
// Description:
//   
//  This file has wrapper functions for the win32 Window handling, User Input and GDI.
//
//  [2000-11-30] Fixed by Otis

#include <stdio.h>

#include "sgdi.h"
#include "sbase.h"

// WINVER 0x500...
#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL                   0x020A
#endif

//________________________________________________________________________________________________________________________________________________________________________

static long* pBuffer = NULL;
static char className[1024];

static LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
	static char string[10900];
	sgdiInternal.Event = cNoEvent;
	switch( message )
	{
		case WM_KEYUP:
			sgdiInternal.keyUp = wParam;
			sgdiInternal.Event = cKeyUp;
			sgdiInternal.keyDown = 0;
			break;
		case WM_KEYDOWN:
			sgdiInternal.keyDown = wParam;
			sgdiInternal.Event = cKeyDown;
			break;
		case WM_CLOSE:
			sgdiClose();
			sgdiInternal.Event = cExit;
			break;
		case WM_SIZE:
			sgdiInternal.Event = cWindowResized;
			sgdiInternal.xRes = LOWORD(lParam);
			sgdiInternal.yRes = HIWORD(lParam);

			if( NULL != pBuffer )
			{
				delete [] pBuffer;
				pBuffer = NULL;
			}

			pBuffer = new long[sgdiInternal.xRes*sgdiInternal.yRes];

			break;
/*
		case WM_SYSCOMMAND:
			if( (wParam&0xFFF0) == SC_MAXIMIZE )
			{
				sgdiInternal.Event = cWindowResized;
				sgdiInternal.xRes = LOWORD(lParam);
				sgdiInternal.yRes = HIWORD(lParam);

				if( NULL != pBuffer )
				{
					delete [] pBuffer;
					pBuffer = NULL;
				}
				pBuffer = new long[sgdiInternal.xRes*sgdiInternal.yRes];

			}
			break;
*/
		case WM_SETFOCUS:
			sgdiInternal.Event = cFocus;
			break;
		case WM_MOUSEMOVE:
			sgdiInternal.Event = cMouseMove;
			sgdiInternal.mouseX = LOWORD(lParam);
			sgdiInternal.mouseY = HIWORD(lParam);
			break;
		case WM_LBUTTONDOWN:
			sgdiInternal.Event = cMouseLeftButtonPress;
			break;
		case WM_LBUTTONUP:
			sgdiInternal.Event = cMouseLeftButton;
			break;
		case WM_RBUTTONUP:
			sgdiInternal.Event = cMouseRightButton;
			break;
		case WM_MOUSEWHEEL:
			sgdiInternal.mouseWheel = wParam;
			sgdiInternal.mouseWheel/=7000000;
			sgdiInternal.Event = cMouseWheel;
			break;
		case WM_PAINT:
			sgdiInternal.Event = cFocus;
			break;
	}

	shineEvent( sgdiInternal.Event );
	return DefWindowProc(hWnd, message, wParam, lParam);
};

//________________________________________________________________________________________________________________________________________________________________________

static long windowStyle;
int _sgdiOpen( char* title, int xres, int yres )
{
	RECT	windowSize;
	int		iCMWidth, iCMHeight;

	// Set window class information
	ZeroMemory( &sgdiInternal.wc, sizeof( sgdiInternal.wc ) );
	sgdiInternal.wc.style = CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
	sgdiInternal.wc.lpfnWndProc = WndProc;
	sgdiInternal.wc.cbClsExtra = 0;
	sgdiInternal.wc.cbWndExtra = 0;
	sgdiInternal.wc.hInstance = GetModuleHandle(0);
	//wc.hIcon = LoadIcon(sgdiInternal.wc.hInstance, NULL);
	sgdiInternal.wc.hIcon = NULL;
	sgdiInternal.wc.hCursor = LoadCursor(0,IDC_ARROW);
	sgdiInternal.wc.hbrBackground = NULL;
	sgdiInternal.wc.lpszMenuName = NULL;
	sgdiInternal.wc.lpszClassName = title;
	RegisterClass(&sgdiInternal.wc);
	strcpy( className, title );

	// Set window size
	windowSize.left = 0;
    windowSize.top = 0;
    windowSize.right = xres;
    windowSize.bottom = yres;

	AdjustWindowRect(&windowSize, windowStyle, 0);

	if( NULL != pBuffer )
	{
		delete [] pBuffer;
		pBuffer = NULL;
	}

	sgdiInternal.xRes = windowSize.right;
	sgdiInternal.yRes = windowSize.bottom;

	pBuffer = new long[sgdiInternal.xRes*sgdiInternal.yRes];

	// Create bitmapinfo
	ZeroMemory( &sgdiInternal.bi, sizeof( BITMAPINFO ) );
	sgdiInternal.bi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	sgdiInternal.bi.bmiHeader.biPlanes = 1;
	sgdiInternal.bi.bmiHeader.biBitCount = 32;
	sgdiInternal.bi.bmiHeader.biCompression = BI_RGB;
	sgdiInternal.bi.bmiHeader.biWidth = windowSize.right;
	sgdiInternal.bi.bmiHeader.biHeight = -windowSize.bottom;
	((unsigned long *)sgdiInternal.bi.bmiColors)[0] = 0x000000FF;

	// [OTIS] these 2 variables are not there. bmiColors consists of just 1 quad. this 
	// will otherwise overwrite other sgdiInternal parameters.
	//((unsigned long *)sgdiInternal.bi.bmiColors)[1] = 0x0000FF00;
	//((unsigned long *)sgdiInternal.bi.bmiColors)[2] = 0x00FF0000;

	// Create window
	iCMWidth=GetSystemMetrics( SM_CXSCREEN );
	iCMHeight=GetSystemMetrics( SM_CYSCREEN );


	// [OTIS] This seems to create the right window, but all the rendering is not taken place in
	// this window but simply at (0,0). I dunno why. 
	/*
	sgdiInternal.wnd = CreateWindowEx( WS_EX_APPWINDOW, title, 
							title, WS_OVERLAPPED | WS_SYSMENU | WS_MINIMIZEBOX,( iCMWidth - xres ) >>1, 
										( iCMHeight - yres ) >>1,
									   windowSize.right, windowSize.bottom, NULL, 0, NULL, 0 );

*/
	sgdiInternal.wnd = CreateWindowEx( WS_EX_APPWINDOW, title, 
							title, windowStyle,( iCMWidth - xres ) >>1, 
										( iCMHeight - yres ) >>1,
									   windowSize.right, windowSize.bottom, NULL, 0, NULL, 0 );

	
	// [OTIS] Moved some stuff to messagepump. Added checking for errors.
	if(sgdiInternal.wnd)
	{
		// window is created correctly. 
		// Get DC for this thread.
		sgdiInternal.hdc = GetDC( sgdiInternal.wnd );
		// Show the window.
		ShowWindow(sgdiInternal.wnd,SW_SHOW);
		// Do further init here.
		shineInitSystem();
		return sgdiOk;
	}
	else
	{
		// Window creation failed.
		MessageBox(NULL,"Shine:: Couldn't open window. Go Buy new hardware... NOW!", "Shine Fatal Error",
				MB_OK| MB_SYSTEMMODAL);
		return sgdiError;
	}
}

//________________________________________________________________________________________________________________________________________________________________________

void sgdiSetTitle( char* title )
{
	SetWindowText( sgdiInternal.wnd, title );
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiOpenPopup( char*title, int xres, int yres )
{
	windowStyle = WS_POPUP;
	return _sgdiOpen( title, xres, yres );
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiOpen( char* title, int xres, int yres )
{
	windowStyle = WS_OVERLAPPEDWINDOW;
	return _sgdiOpen( title, xres, yres );
}

//________________________________________________________________________________________________________________________________________________________________________

HDC sgdiGetDc()
{
	return sgdiInternal.hdc;
}


// [OTIS] Added for thread
HWND
sgdiGetWnd()
{
	return sgdiInternal.wnd;
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiClose()
{

	if( NULL != pBuffer )
	{
		delete [] pBuffer;
		pBuffer = NULL;
	}

	UnregisterClass( className, GetModuleHandle( 0 ) );
	DestroyWindow( sgdiInternal.wnd );
	ReleaseDC( sgdiInternal.wnd, sgdiGetDc() );

  return sgdiOk;
}

//________________________________________________________________________________________________________________________________________________________________________

bool sgdiKeyPressed()
{
	MSG message;
	//sgdiInternal.keyUp = 0;
    PeekMessage(&message,sgdiInternal.wnd,0,0,PM_REMOVE);
    TranslateMessage(&message);
    DispatchMessage(&message);
	
	if ( 0 == sgdiInternal.keyDown )
		return false;
	else
		return true;
}

//________________________________________________________________________________________________________________________________________________________________________

void sgdiWaitEvent()
{
	MSG message;
    GetMessage(&message,sgdiInternal.wnd,0,0);
    TranslateMessage(&message);
    DispatchMessage(&message);
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiGetKey()
{
	MSG message;
    PeekMessage(&message,sgdiInternal.wnd,0,0,PM_REMOVE);
    TranslateMessage(&message);
    DispatchMessage(&message);

	return sgdiInternal.keyDown;
}

//________________________________________________________________________________________________________________________________________________________________________

sgdiEvent_t sgdiGetEvent()
{
	MSG message;
	//sgdiInternal.keyUp = 0;
    PeekMessage(&message,sgdiInternal.wnd,0,0,PM_REMOVE);
    TranslateMessage(&message);
    DispatchMessage(&message);

	return sgdiInternal.Event;
}

//________________________________________________________________________________________________________________________________________________________________________

void sgdiClear( long color )
{
	RECT rect;
	HBRUSH brush = CreateSolidBrush( color );

	rect.left = 0;
	rect.top = 0;
	rect.right = sgdiInternal.xRes;
	rect.bottom = sgdiInternal.yRes;

	FillRect( sgdiGetDc(), &rect, brush );

	// [OTIS] delete brush we just created. Can be done savely because it's not selected
	DeleteObject(brush);
}

//________________________________________________________________________________________________________________________________________________________________________

void sgdiBox( int x1, int y1, int x2, int y2, long color )
{
	RECT rect;
	HBRUSH brush = CreateSolidBrush( color );

	rect.left = x1;
	rect.top = y1;
	rect.right = x2;
	rect.bottom = y2;

	FillRect( sgdiGetDc(), &rect, brush );

	// [OTIS] delete brush we just created. Can be done savely because it's not selected
	DeleteObject(brush);
}

//________________________________________________________________________________________________________________________________________________________________________

void sgdiScroll( int yscroll )
{
	RECT area;
	RECT clip;

	area.bottom = sgdiInternal.yRes;
	area.right = sgdiInternal.xRes - cBorders;
	area.top = 0;
	area.left = 0;

	clip.right = sgdiInternal.xRes;
	clip.top = 0;
	clip.left = 0;
	clip.bottom = sgdiInternal.yRes;

	//ScrollDC( sgdiGetDc(), 0, yscroll, &area, NULL, NULL, NULL );
	//ScrollWindowEx( sgdiInternal.wnd, 0, yscroll, &area, &area, NULL, NULL, SW_ERASE );
	ScrollWindowEx( sgdiInternal.wnd, 0, yscroll, &area, &clip, NULL, NULL, SW_ERASE );
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiGetXRes()
{
	return sgdiInternal.xRes;
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiGetYRes()
{
	return sgdiInternal.yRes;
}

//________________________________________________________________________________________________________________________________________________________________________

void sgdiClearEvent()
{
	sgdiInternal.Event = cNoEvent;
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiGetMouseWheel()
{
	return sgdiInternal.mouseWheel;
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiGetMouseX()
{
	return sgdiInternal.mouseX;
}

//________________________________________________________________________________________________________________________________________________________________________

int sgdiGetMouseY()
{
	return sgdiInternal.mouseY;
}

//________________________________________________________________________________________________________________________________________________________________________

long* sgdiGetBuffer()
{
	return pBuffer;
}

//________________________________________________________________________________________________________________________________________________________________________

