
float4x4 WorldViewProjection : WORLDVIEWPROJECTION;

float smoothness;   // 0->1
float alpha;

float brightness
<
	string UIName = "Brightness";
	string UIWidget= "slider";
	float UIMin = -1.0;
	float UIMax =  1.0;
	float UIStep = 0.05;
> = 0.0;

float contrast
<
	string UIName = "Contrast";
	string UIWidget= "slider";
	float UIMin =  0.0;
	float UIMax = 50.0;
	float UIStep = 0.1;
> = 8.5f;


texture texture1 : DiffuseMap <
    string ResourceName = "c:/oma/alt/spacek.jpg";
    string UIName = "Diffuse Texture";
    string ResourceType = "2D";
>;

 float2 poisson[8] = {  
  float2( 0.0,      0.0),
  float2( 0.527837,-0.085868),
  float2(-0.040088, 0.536087),
  float2(-0.670445,-0.179949),
  float2(-0.419418,-0.616039),
  float2( 0.440453,-0.639399),
  float2(-0.757088, 0.349334),
  float2( 0.574619, 0.685879)
};
float texScale = 1.0/64.0;


struct VS_OUTPUT
{
	float4 pos  : POSITION;
	float4 col : Color0;
	float2 tex1 : TEXCOORD0;
	float4 position: TEXCOORD1;
};

VS_OUTPUT VS(
	float4 pos1 : POSITION,
	float4 col : Color0,
	float2 tex1 : TEXCOORD0
	) 
{
	VS_OUTPUT Out;
	
	Out.col = col;
	Out.pos = mul( pos1, WorldViewProjection );
	Out.tex1 = tex1;
	Out.position = Out.pos;

	return Out;
}


sampler smp1 = sampler_state 
{
	texture = (texture1);
	AddressU  = CLAMP;       
	AddressV  = CLAMP;
 	AddressW  = CLAMP;
	MIPFILTER = LINEAR;
	MINFILTER = LINEAR;
	MAGFILTER = LINEAR;
};

float sigmoid ( float t, float contrast, float brightness )
{
//	return (1.0 / ( 1 + pow ( 2.718, - (t - 0.5 + brightness) * contrast )  ));
	return (1.0 / ( 1 + pow ( 2.718, - (t - 0.5 + brightness) * contrast )  ));
}

float4 PS_normal(VS_OUTPUT In) : COLOR
{
  return tex2D( smp1, In.tex1 ); 
}

float4 PS(VS_OUTPUT In) : COLOR
{
/*  float3 c = float3(0,0,0);
  float sm = 1.0 / 8.0;
  float s = (1-smoothness) * sm;
  float total = 0;
  float ts = texScale * (1.0+smoothness);
  for ( int a=0; a<8; a++ )
  {
    c += tex2D( smp1, In.tex1.xy + poisson[a] * ts ) * sm;
    total += sm;
    sm = clamp( sm-s, 0, 1 );
  }*/
    float3 c = tex2D( smp1, In.tex1.xy );
	c.x = sigmoid( c.x, contrast, brightness );
	c.y = sigmoid( c.y, contrast, brightness );
	c.z = sigmoid( c.z, contrast, brightness );
  
  if ( length( c.xyz ) == 0 ) alpha = 0;
//  return tex2D( smp1, In.tex1.xy );
//  return float4( c.xyz * (1.0/total), alpha ); 
  return float4( c.xyz, alpha ); 
}

float4 PS2(VS_OUTPUT In) : COLOR
{
  float4 c = float4(0,0,0,0);
  float sm = 1.0 / 8.0;
  float s = (1-smoothness) * sm;
  float total = 0;
  float ts = texScale * (1.0+smoothness);
  for ( int a=0; a<8; a++ )
  {
    c += tex2D( smp1, In.tex1.xy + poisson[a] * ts ) * sm;
    total += sm;
    sm = clamp( sm-s, 0, 1 );
  }
//	c.x = sigmoid( c.x, contrast, brightness );
//	c.y = sigmoid( c.y, contrast, brightness );
//	c.z = sigmoid( c.z, contrast, brightness );
  
  return c * alpha;
//    float3 YJR = c.xyz * (1.0/total);
//	return tex2D( smp1, In.tex1.xy ) * alpha;
//    return float4( YJR.xyz, 1.0 ); 
}

float4 PS_line(VS_OUTPUT In) : COLOR
{
	return In.col;	
}


technique main
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		AlphaBlendEnable = FALSE;
		ZEnable = false;
		Lighting = false;
//		cullmode = none;
	}
}

technique alpha
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS2();
		
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		ZEnable = false;
	}
}
technique additive
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS2();
		
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = ONE;
		
		ZEnable = false;
		Lighting = false;
//		cullmode = none;
	}
}

technique debug
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		Lighting = false;
        
	}
	pass p1
	{
		FillMode = wireframe;
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS_line();
		
		AlphaBlendEnable = true;
		BlendOp = add;
		DestBlend = srcalpha;
		SrcBlend = invsrcalpha;
	}
	pass p2
	{
		FillMode = point;
		pointscaleEnable = false;
		pointsize = 6;
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS_line();
		
		AlphaBlendEnable = false;
	}
}
