// Flat triangle filler coded by
//	 MasterBoy / Winter in July , Mistery, ZeroDefects (1999)
//
// contains: subpixel accuracy
//
// email: cobra11@netvision.net.il
// icq  : 14054887

#define XRES 320

typedef struct
{
        float x, y;
} Vertex;

float Left_dXdY, Right_dXdY, LeftX, RightX;

typedef unsigned char byte;

byte *dest_ptr, *dest;

#define SUB_PIX(a) (ceil(a)-a)

void DrawSegment(long y1, long y2, byte color);
void Swap (void * a, void * b);

void Flat_Triangle(Vertex *v1, Vertex *v2, Vertex *v3, byte color, byte *where)
{

        if (v1->y > v2->y) Swap(&v1, &v2);
        if (v1->y > v3->y) Swap(&v1, &v3);
        if (v2->y > v3->y) Swap(&v2, &v3);



        long y1i=ceil(v1->y);
        long y2i=ceil(v2->y);
        long y3i=ceil(v3->y);

	if (y1i==y3i) return;

        float prestep;

        dest_ptr = &where[y1i*XRES];

        float dXdY_V1V3=(v3->x - v1->x) / (v3->y - v1->y);
        float dXdY_V2V3=(v3->x - v2->x) / (v3->y - v2->y);
        float dXdY_V1V2=(v2->x - v1->x) / (v2->y - v1->y);

        bool mid = dXdY_V1V3<dXdY_V1V2;

	// if dXdY_V1V3 slope is bigger than dXdY_V1V2
	// then v2 is at the left side of triangle
        if (!mid) {
                  // v2 is at the left side

		prestep = SUB_PIX(v1->y);

                Right_dXdY = dXdY_V1V3;
 
                if (y1i==y2i) {
                
                        Left_dXdY = dXdY_V2V3;
                        LeftX = v2->x + SUB_PIX(v2->y)*Left_dXdY;
                        RightX = v1->x + prestep*Right_dXdY;
                        DrawSegment(y1i, y3i, color);
                        return;
                }

                if (y1i<y2i) {
                        
			Left_dXdY = dXdY_V1V2;

			LeftX = v1->x + prestep*Left_dXdY;
			RightX = v1->x + prestep*Right_dXdY;
			DrawSegment(y1i, y2i, color);
		}

		if (y2i<y3i) {

			Left_dXdY = dXdY_V2V3;

			LeftX = v2->x + SUB_PIX(v2->y)*Left_dXdY;
			DrawSegment(y2i, y3i, color);
		}

	}
	 else

	if (mid) {
		  // v2 is at the right side

		prestep = SUB_PIX(v1->y);

		Left_dXdY = dXdY_V1V3;

		if (y1i==y2i) {

			Right_dXdY = dXdY_V2V3;
			LeftX = v1->x + prestep*Left_dXdY;
			RightX = v2->x + SUB_PIX(v2->y)*Right_dXdY;
			DrawSegment(y1i, y3i, color);
			return;
		}


		if (y1i<y2i) {

			Right_dXdY = dXdY_V1V2;
			LeftX = v1->x + prestep*Left_dXdY;
			RightX = v1->x + prestep*Right_dXdY;
			DrawSegment(y1i, y2i, color);
		}

		if (y2i<y3i)
		{
                        Right_dXdY = dXdY_V2V3;
                        RightX = v2->x + SUB_PIX(v2->y)*Right_dXdY;
                        DrawSegment(y2i, y3i, color);
                }

        }

}

inline void DrawSegment(long y1, long y2, byte color)
{
        long x1, x2, y;

	for (y=y1;y<y2;y++)
        {
                x1 = ceil(LeftX);
                x2 = ceil(RightX);

		dest = dest_ptr+x1;

		
                while (x1++<x2)	 *dest++=color;

                LeftX+=Left_dXdY;
                RightX+=Right_dXdY;
                dest_ptr+=XRES;
        }

}


#pragma aux Swap = \
	"mov ebx, [eax]"\
	"mov ecx, [edx]"\
	"mov [edx], ebx"\
	"mov [eax], ecx"\
	parm [eax] [edx] \
	modify [ebx ecx];
