;NASM Win32 coding tutorial pt. 1.2beta  -  von T$ (ts@deinmeister.de)
;
;compile with:
;NASMW.EXE -fobj win001_n.asm
;link with:
;ALINK.EXE -c -oPE  -subsys gui win001_n win32.lib win001.res

;Alles was schon im Teil 0,5 drinsteht wird hier nicht wiederholt - wenn etwas unklar ist 
;also auch im ersten Teil nachschauen

		%include "win32n.inc"       

		EXTERN GetModuleHandleA
		IMPORT GetModuleHandleA kernel32.dll
		EXTERN RegisterClassExA
		IMPORT RegisterClassExA user32.dll
		EXTERN LoadIconA
		IMPORT LoadIconA user32.dll
		EXTERN LoadCursorA
		IMPORT LoadCursorA user32.dll
		EXTERN CreateWindowExA
		IMPORT CreateWindowExA user32.dll
		EXTERN GetMessageA
		IMPORT GetMessageA user32.dll
		EXTERN DispatchMessageA
		IMPORT DispatchMessageA user32.dll
		EXTERN ExitProcess
		IMPORT ExitProcess kernel32.dll
		EXTERN DefWindowProcA
		IMPORT DefWindowProcA user32.dll
		EXTERN PostQuitMessage
		IMPORT PostQuitMessage user32.dll
		EXTERN MessageBoxA
		IMPORT MessageBoxA user32.dll
		EXTERN SendMessageA
		IMPORT SendMessageA user32.dll

		segment .data USE32

;Definition der Fensterklasse (mit Menue):
;Die NASM-Syntax zur Verwendung von Structs ist bescheuert...

		UnsereFensterklasse:
		istruc WNDCLASSEX
		    at WNDCLASSEX.cbSize,          dd  WNDCLASSEX_size
		    at WNDCLASSEX.style,           dd  CS_VREDRAW + CS_HREDRAW
		    at WNDCLASSEX.lpfnWndProc,     dd  Fensterprozedur
		    at WNDCLASSEX.cbClsExtra,      dd  0
		    at WNDCLASSEX.cbWndExtra,      dd  0
		    at WNDCLASSEX.hInstance,       dd  0
		    at WNDCLASSEX.hIcon,           dd  0
		    at WNDCLASSEX.hCursor,         dd  0
		    at WNDCLASSEX.hbrBackground,   dd  COLOR_HIGHLIGHT
		    at WNDCLASSEX.lpszMenuName,    dd  Menuname
		    at WNDCLASSEX.lpszClassName,   dd  Fensterklassenname
		    at WNDCLASSEX.hIconSm,         dd  0
	    	iend

		Fensterhandle dd 0

;Folgende Konstanten beschreiben die Lage der MSG-Struktur auf dem Stack:
		MSGhWnd   equ 0
		MSGmsg    equ 4
		MSGwParam equ 8
		MSGlParam equ 12

;GetMessage bentigt einen Puffer fuer eine eingehende Message (eine Message = 7 DWORDS):
		MessageBuffer dd 0,0,0,0,0,0,0

		Fenstertitel db "ordinres Standardfenster",0
		Fensterklassenname db "UnsereFensterklasse",0
		Fenstername db "Oooooh... Ein Fenster",0

;Namen der Ressourcen:
		Menuname db "Win002menu",0
		Bildchenname db "Nuke",0
		Zeigername db "Fisch" 

		Garnix db 0

;diese Konstanten sind Selbsterklaerend ;-)
		FenstergroesseInX equ 300
		FenstergroesseInY equ 200
		FensterpositionInX equ 100
		FensterpositionInY equ 120


		segment .code USE32

		..start

;viele Funktionen benoetigen ein Handle, das dieses laufende Programm identifiziert
;GetModuleHandle (0) erledigt dies

		push dword 0
		call [GetModuleHandleA]
		mov [UnsereFensterklasse+WNDCLASSEX.hInstance],eax

;zwei Ressourcen werden geladen (die Menueressource wird automatisch geladen,
;wenn sie in der Fensterklasse definiert wurde
		push dword Bildchenname
		push dword [UnsereFensterklasse+WNDCLASSEX.hInstance]
		call [LoadIconA]
		mov [UnsereFensterklasse+WNDCLASSEX.hIcon],eax
		push dword Zeigername
		push dword [UnsereFensterklasse+WNDCLASSEX.hInstance]
		call [LoadCursorA]
		mov [UnsereFensterklasse+WNDCLASSEX.hCursor],eax

;schicke dem OS die Definition der Fensterklasse
		push dword UnsereFensterklasse
		call [RegisterClassExA]


;erzeuge ein Fenster nach der Fensterklasse:
		push dword 0
		push dword [UnsereFensterklasse+WNDCLASSEX.hInstance]
		push dword 0
		push dword 0
		push dword FenstergroesseInY
		push dword FenstergroesseInX
		push dword FensterpositionInY
		push dword FensterpositionInX
		push dword WS_CAPTION + WS_MAXIMIZEBOX + WS_MINIMIZEBOX + WS_SIZEBOX + WS_SYSMENU + WS_VISIBLE
		push dword Fenstername
		push dword Fensterklassenname
		push dword WS_EX_CLIENTEDGE + WS_EX_WINDOWEDGE
		call [CreateWindowExA]
		mov [Fensterhandle],eax

;Die wichtigste Stelle eines Windows-Programms: Die Message Pump / Message Loop. Hier werden
;die eingehenden Meldungen vorverarbeitet und an das entsprechende Fenster verschickt

		MessagePumpStart:
		push dword 0
		push dword 0
		push dword 0
		push dword MessageBuffer
		call [GetMessageA]
		or eax,eax
		jz WM_QUIT_empfangen
		push dword MessageBuffer
		call [DispatchMessageA]
		jmp MessagePumpStart


		WM_QUIT_empfangen:
		push dword 0
		call [ExitProcess]

;------------
;Die Fensterprozedur wird jedesmal durch DispatchMessage aufgerufen, wenn die Message zu diesem
;Fenster gehrt. Die Message und ihre Parameter liegen dabei auf dem Stack. Mit der 4 in 
; [esp+4+MSGmsg] wird der auf dem Stack liegende EIP uebersprungen

		Fensterprozedur:

;nur 2 Meldungen werden ueberprueft: WM_COMMAND fuer aktivierte Menues und WM_DESTROY, die
;anzeigt, das das Fenster vernichtet wird.
;Den Rest arbeitet DefaultWndProc von Windows ab.

		cmp dword [esp+4+MSGmsg],WM_COMMAND
		jne keineInteressanteMeldung

		 cmp dword [esp+4+MSGwParam],999h
		 je Selbstzerstoerung

		 cmp dword [esp+4+MSGwParam],666h
		 je Nixwissmeldung

		 mov ecx,titel1
		  cmp dword [esp+4+MSGwParam],123h
		  je Willwasmeldung

		  mov ecx,titel2
		  jmp Willwasmeldung

		keineInteressanteMeldung:

		cmp dword [esp+4+MSGmsg],WM_DESTROY
		jne [DefWindowProcA]

		Selbstzerstoerung:
		push dword MB_OK | MB_APPLMODAL
		push dword Fenstertitel
		push dword SagNein
		push dword [Fensterhandle]
		call [MessageBoxA]
		push dword 0
		call [PostQuitMessage]
;setze Rueckgabewert = 0
		xor eax,eax
;die "RET imm"-Version der RET Instruktion holt beim Ruecksprung noch "imm" Bytes vom Stack
;mit imm = 16 holen wir genau die 4 DWORDS herunter, die die Fensterprozedur als Parameter erhielt
		ret 16

		Willwasmeldung:
		push dword MB_OK
		push ecx
		push dword textdrin
		push dword [Fensterhandle]
		call [MessageBoxA]
		ret 16

		Nixwissmeldung:
		push dword MB_OK
		push dword Garnix
		push dword Garnix
		push dword [Fensterhandle]
		call [MessageBoxA]
		ret 16

		segment .data USE32
;Ein paar Texte fuer ein paar Dialogboxen...
		titel1 db "Ficken",0
		titel2 db "Blasen",0
		textdrin db "Kein Wunder, das sieht man schon an der Art in der du das Men ausfhrst :-)",0
		SagNein db "Nei i i i i i i i i i i i i i i n !",0
