/* DemoSystem by Defiance^BSR, a small demo framework to use for your productions. */
/* This software is licensed under the Zero-Clause BSD license and dedicated to the public domain.*/

#define GLFW_EXPOSE_NATIVE_WIN32

// #include <iostream>
#include <fstream>
#include <windows.h>
#include <wtypes.h>
#include <math.h>

#include "resources\include\GL\glfw.h"
#include "resources\include\GL\glfwnative.h"
#include "resources\include\Bass\bass.h"

int x;
int y;

int width;
int height;

int widthoriginal;
int heightoriginal;

int centerwindow;

int desktopwidth;
int desktopheight;

int fullscreen;
int multisampling;
int vsync;
int cinematicframerate;
int framerate;
int infointitle;
int fullscreendialog;

// int settingsexists;

// int usesettings;

// int n;

float xM; // The cube's x Matrix.
float yM; // The cube's y Matrix.
int setinitialposition;

int pause;

double rfpscurrentTime;
double rfpslastTime;

int enablefpscounterfirsttime = 1;
int frameCount;

double firstTime;
double currentTime;

std::string title;
// std::string settings;

GLFWwindow* window;
HWND hMainwindow;

HSTREAM stream;
const char* track;

QWORD totaltracklengthbytes;
double totaltracklength;

QWORD currenttrackpositionbytes;
double currenttrackposition;

void GLDraw();
void GetDesktopResolution(int &desktopwidth, int &desktopheight);
void CenterWindow(GLFWwindow* window, GLFWmonitor* monitor);
void InfoInTitle();
// void WriteSettings();
// void ReadSettings();

/* Our main function */
int main(){

	x = 0;
	y = 0;

	width = 1024;
	height = 768;

	widthoriginal = 0;
	heightoriginal = 0;

	centerwindow = 1;

	fullscreen = 0;
	multisampling = 4;
	vsync = 1;
	framerate = 60;
	infointitle = 0;
	fullscreendialog = 1;

	// settingsexists = 0;
	// usesettings = 0;

	//n = 0;

    xM = 0;
    yM = 0;

    setinitialposition = 1;

    pause = 0;

	title = "DemoSystem";

    track = "track.ogg";

	// settings = "settings.conf";

	GetDesktopResolution(desktopwidth, desktopheight);

	/* std::string resolution = "Your screen resolution is " + std::to_string(desktopwidth) + " x " + std::to_string(desktopheight) + ".";

	const int msgboxresolution = MessageBox(NULL, resolution.c_str(), title.c_str(), MB_OK);

	if (msgboxresolution == IDOK){

	} */

	/* if (usesettings == 1){

	ReadSettings();

	} */

    /* Ask if the application will run in Fullscreen or Windowed mode */
    if (fullscreendialog == 1){

    const int msgboxfullscreen = MessageBox(NULL, "Would you like to run in Fullscreen?", title.c_str(), MB_YESNOCANCEL);

	if (msgboxfullscreen == IDYES){

    fullscreen = 1;

	}

    if (msgboxfullscreen == IDNO){

    fullscreen = 0;

	}

    if (msgboxfullscreen == IDCANCEL){

    return(0);

	}

    }

	/* Initialize the graphics library */
	if (!glfwInit()){

	return -1;

	}

    /* Start the window hidden and with no size border */
	glfwWindowHint(GLFW_RESIZABLE, GLFW_FALSE);
	glfwWindowHint(GLFW_VISIBLE, GLFW_FALSE);

    /* Set the number of samples used for anti-aliasing */
	if (multisampling == 0){

	glfwWindowHint(GLFW_SAMPLES, 0);

	}else if (multisampling == 2){

	glfwWindowHint(GLFW_SAMPLES, 2);

	}else if (multisampling == 4){

	glfwWindowHint(GLFW_SAMPLES, 4);

	}else if (multisampling == 8){

	glfwWindowHint(GLFW_SAMPLES, 8);

	}else if (multisampling == 16){

	glfwWindowHint(GLFW_SAMPLES, 16);

	}else if (multisampling == 32){

	glfwWindowHint(GLFW_SAMPLES, 32);

	}

    /* Create the application in Fullscreen or Windowed mode */
	if (fullscreen == 1){

	widthoriginal = width;
	heightoriginal = height;

	width = desktopwidth;
	height = desktopheight;

	window = glfwCreateWindow(width, height, title.c_str(), glfwGetPrimaryMonitor(), NULL);

	while(ShowCursor(false)>=0);

	}else{

	window = glfwCreateWindow(width, height, title.c_str(), NULL, NULL);

	}

    /* Center the window if it was created for the first time */
	HWND hMainwindow = glfwGetWin32Window(window);

	if (fullscreen == 1){

	/* if (settingsexists == 0){

	centerwindow = 1;

	} */

	}else{

	SetWindowPos(hMainwindow, NULL, x, y, width, height, SWP_NOSIZE);

	if (centerwindow == 1){

	CenterWindow(window, glfwGetPrimaryMonitor());

	centerwindow = 0;

	}

	}

    /* If our application failed to create a window then shutdown the graphics library and throw an error */
	if (!window){

	glfwTerminate();

	return -1;

	}

	/* Make the window's context current */
	glfwMakeContextCurrent(window);

    /* Enable or disable the vertical synchronization */
    if (vsync == 0){

    glfwSwapInterval(0);

    }else if (vsync == 1){

    glfwSwapInterval(1);

    }

	/* Enable Z buffer depth test */
	glEnable(GL_DEPTH_TEST);

    /* Show the main window */
    glfwShowWindow(window);

    /* Initialize the BASS Sound library */
    BASS_Init(-1, 44100, 0, hMainwindow, NULL);

    /* Create a stream to play our music track */
    stream = BASS_StreamCreateFile(FALSE, track, 0, 0, 0);

    /* Get the track's overall duration, first in bytes and then in seconds */
    totaltracklengthbytes = BASS_ChannelGetLength(stream, BASS_POS_BYTE); // the total length in bytes
    totaltracklength = BASS_ChannelBytes2Seconds(stream, totaltracklengthbytes); // the total length in seconds

    /* std::string timestring = "The track's overall length is " + std::to_string(time) + " seconds.";

    const int msgboxlength = MessageBox(NULL, timestring.c_str(), title.c_str(), MB_OK);

    if (msgboxlength == IDOK){

	} */

    /* Start audio playback */
    BASS_ChannelPlay(stream, 1);

	/* Loop until the user closes the window */
	while (!glfwWindowShouldClose(window)){

    /* Render the defined frames per second */
    rfpscurrentTime = glfwGetTime();

	if(rfpscurrentTime - rfpslastTime >= 1.0 / framerate)
	{
		rfpslastTime = rfpscurrentTime;
		GLDraw();
	}

    /* Get the current track position, first in bytes and then in seconds */
    currenttrackpositionbytes = BASS_ChannelGetPosition(stream, BASS_POS_BYTE);
    currenttrackposition = BASS_ChannelBytes2Seconds(stream, currenttrackpositionbytes);

    /* If the track has finished playing, close the window and exit */
    if(currenttrackposition == totaltracklength){

    glfwSetWindowShouldClose(window, 1);

    }

    HWND hForegroundwindow = GetForegroundWindow();

	if(hMainwindow == hForegroundwindow && GetAsyncKeyState(VK_ESCAPE)){

    glfwSetWindowShouldClose(window, 1);

	}

	}

    /* Save the current window position */
	if (fullscreen == 1){

	}else{

	bool minimized = IsIconic(hMainwindow);

	if (minimized == 0){

	RECT mainwindow;

	GetWindowRect(hMainwindow, &mainwindow);

	x = mainwindow.left;
	y = mainwindow.top;

	}

	}

    /* Shutdown the graphics library */
	glfwTerminate();

    /* Save the settings to settings.conf and exit the application */
    /* if (usesettings == 1){

    WriteSettings();

    } */

	return 0;

}

/* Main drawing function */
void GLDraw(){

    /* Show info in the title */
    if (fullscreen == 0){

    if (infointitle == 0){

    }else{

    InfoInTitle();

    }

    }

	/* Render here */
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    HWND hMainwindow = glfwGetWin32Window(window);
    HWND hForegroundwindow = GetForegroundWindow();

    if(hMainwindow == hForegroundwindow && GetAsyncKeyState(0x33) & 0x01){ //3 - set framerate to 30fps (cinematic framerate)

    framerate = 30;

    }

    if(hMainwindow == hForegroundwindow && GetAsyncKeyState(0x35) & 0x01){ //5 - set framerate to 50fps (pal)

    framerate = 50;

    }

    if(hMainwindow == hForegroundwindow && GetAsyncKeyState(0x36) & 0x01){ //6 - set framerate to 60fps (ntsc)

    framerate = 60;

    }

    if(hMainwindow == hForegroundwindow && GetAsyncKeyState(0x49) & 0x01){ //i - enable/disable info in title

    if (fullscreen == 0){

    if (infointitle == 0){

    infointitle = 1;

    }else{

    if (infointitle == 1){

    HWND hMainwindow = glfwGetWin32Window(window);

    SetWindowTextA(hMainwindow, title.c_str());

    }

    infointitle = 0;

    }

    }else{

    }

    }

    if(hMainwindow == hForegroundwindow && GetAsyncKeyState(VK_SPACE) & 0x01){ //spacebar - reset the demo

    xM = 0;
    yM = 0;

    glPopMatrix();
	glPushMatrix();

	glRotatef(xM, 1, 0, 0);
	glRotatef(yM, 0, 1, 0);

    BASS_ChannelPlay(stream, 1);

	}

    if(hMainwindow == hForegroundwindow && GetAsyncKeyState(0x50) & 0x01){ //p - pause the demo

    if (pause == 0){

    pause = 1;

    }else{

    pause = 0;

    }

    }

    if (pause == 0){

    glPopMatrix();
	glPushMatrix();

	//n++;

	//glRotatef(n, 1, 1, 1);

    xM += 0.3;
    yM += 0.3;

    glRotatef(xM, 1, 0, 0); //this is actual rotation
	glRotatef(yM, 0, 1, 0);

	BASS_ChannelPlay(stream, 0);

    }else{

    glPopMatrix();
	glPushMatrix();

	//n++;

	//glRotatef(n, 1, 1, 1);

    glRotatef(xM, 1, 0, 0); //this is actual rotation
	glRotatef(yM, 0, 1, 0);

	BASS_ChannelPause(stream);

    }

	/* Let's create our cube */

	// Yellow side - FRONT
	glBegin(GL_POLYGON);
	glColor3f(   1.0,  1.0,  0.0 ); //yellow
	glVertex3f( -0.5, -0.5, -0.5 );
	glVertex3f( -0.5,  0.5, -0.5 );
	glColor3f(   1.0,  0.0,  1.0 ); //purple
	glVertex3f(  0.5,  0.5, -0.5 );
	glVertex3f(  0.5, -0.5, -0.5 );
	glEnd();

	// White side - BACK
	glBegin(GL_POLYGON);
	glColor3f(   1.0,  1.0,  0.0 ); //yellow
	glVertex3f(  0.5, -0.5,  0.5 );
	glVertex3f(  0.5,  0.5,  0.5 );
	glColor3f(   1.0,  0.0,  1.0 ); //purple
	glVertex3f( -0.5,  0.5,  0.5 );
	glVertex3f( -0.5, -0.5,  0.5 );
	glEnd();

	// Purple side - RIGHT
	glBegin(GL_POLYGON);
	glColor3f(   1.0,  1.0,  1.0 ); //white
	glVertex3f(  0.5, -0.5, -0.5 );
	glVertex3f(  0.5,  0.5, -0.5 );
	glColor3f(   1.0,  0.0,  1.0 ); //purple
	glVertex3f(  0.5,  0.5,  0.5 );
	glVertex3f(  0.5, -0.5,  0.5 );
	glEnd();

	// Green side - LEFT
	glBegin(GL_POLYGON);
	glColor3f(   0.0,  1.0,  0.0 ); //green
	glVertex3f( -0.5, -0.5,  0.5 );
	glVertex3f( -0.5,  0.5,  0.5 );
	glColor3f(   0.0,  0.0,  1.0 ); //blue
	glVertex3f( -0.5,  0.5, -0.5 );
	glVertex3f( -0.5, -0.5, -0.5 );
	glEnd();

	// Blue side - TOP
	glBegin(GL_POLYGON);
	glColor3f(   0.0,  0.0,  1.0 ); //blue
	glVertex3f(  0.5,  0.5,  0.5 );
	glVertex3f(  0.5,  0.5, -0.5 );
	glColor3f(   1.0,  1.0,  1.0 ); //white
	glVertex3f( -0.5,  0.5, -0.5 );
	glVertex3f( -0.5,  0.5,  0.5 );
	glEnd();

	// Red side - BOTTOM
	glBegin(GL_POLYGON);
	glColor3f(   1.0,  0.0,  0.0 ); //red
	glVertex3f(  0.5, -0.5, -0.5 );
	glVertex3f(  0.5, -0.5,  0.5 );
	glColor3f(   1.0,  1.0,  1.0 ); //white
	glVertex3f( -0.5, -0.5,  0.5 );
	glVertex3f( -0.5, -0.5, -0.5 );
	glEnd();

	/* Swap front and back buffers */
	glfwSwapBuffers(window);

	/* Poll for and process events */
	glfwPollEvents();

}

/* This function retrieves the desktop resolution */
void GetDesktopResolution(int &desktopwidth, int &desktopheight){

	// Get a handle to the desktop window
	HWND hDesktopwindow = GetDesktopWindow();

	RECT desktopwindow;

	// Get the size of screen to the variable desktop
	GetWindowRect(hDesktopwindow, &desktopwindow);

	// The top left corner will have coordinates (0,0)
	// and the bottom right corner will have coordinates
	// (horizontal, vertical)
	desktopwidth = desktopwindow.right;
	desktopheight = desktopwindow.bottom;

}

/* This function centers the main window */
void CenterWindow(GLFWwindow* window, GLFWmonitor* monitor){

	if (!monitor)
		return;

	const GLFWvidmode* mode = glfwGetVideoMode(monitor);

	if (!mode)
		return;

	int monitorX, monitorY;

	glfwGetMonitorPos(monitor, &monitorX, &monitorY);

	int windowWidth, windowHeight;

	glfwGetWindowSize(window, &windowWidth, &windowHeight);

	glfwSetWindowPos(window, monitorX + (mode->width - windowWidth)/2, monitorY + (mode->height - windowHeight)/2);

}

/* This function shows info in the title (FPS - current track position / total track duration */
void InfoInTitle(){

    // Calculate current minutes/seconds passed
    int overallseconds = floor(currenttrackposition);
    int minutes = (overallseconds/60);
    int seconds = overallseconds - (minutes*60);

    // Calculate total minutes/seconds of the track
    int totaloverallseconds = floor(totaltracklength);
    int totalminutes = (totaloverallseconds/60);
    int totalseconds = totaloverallseconds - (totalminutes*60);

    // Convert everything to string
    std::string minutesstring;
    std::string secondsstring;

    std::string totalminutesstring;
    std::string totalsecondsstring;

    // Format the display of single digits by adding an extra zero in front of them
    if(minutes < 10){

    minutesstring = std::to_string(0) + std::to_string(minutes);

    }else{

    minutesstring = std::to_string(minutes);

    }

    if(seconds < 10){

    secondsstring = std::to_string(0) + std::to_string(seconds);

    }else{

    secondsstring = std::to_string(seconds);

    }

    if(totalminutes < 10){

    totalminutesstring = std::to_string(0) + std::to_string(totalminutes);

    }else{

    totalminutesstring = std::to_string(totalminutes);

    }

    if(totalseconds < 10){

    totalsecondsstring = std::to_string(0) + std::to_string(totalseconds);

    }else{

    totalsecondsstring = std::to_string(totalseconds);

    }

    // When the fps counter is displayed for the first time start from zero
    if(enablefpscounterfirsttime == 1){

    firstTime = glfwGetTime();
    frameCount = 0;

    std::string frameCountstring;

    frameCountstring = std::to_string(frameCount);

    std::string titlewithinfo;

    // Display the frame count and the duration in the window title
    titlewithinfo = title + " - " + frameCountstring + " FPS" +
    " - " + minutesstring + ":" + secondsstring + " / " +
    totalminutesstring + ":" + totalsecondsstring;

    HWND hMainwindow = glfwGetWin32Window(window);

    SetWindowTextA(hMainwindow, titlewithinfo.c_str());

    enablefpscounterfirsttime = 0;

    }else{

    // Measure speed
    currentTime = glfwGetTime();
    frameCount++;

    // If a second has passed
    if(currentTime - firstTime >= 1.0){

    std::string frameCountstring;

    frameCountstring = std::to_string(frameCount);

    std::string titlewithinfo;

    // Display the frame count and the duration in the window title
    titlewithinfo = title + " - " + frameCountstring + " FPS" +
    " - " + minutesstring + ":" + secondsstring + " / " +
    totalminutesstring + ":" + totalsecondsstring;

    HWND hMainwindow = glfwGetWin32Window(window);

    SetWindowTextA(hMainwindow, titlewithinfo.c_str());

    frameCount = 0;
    firstTime = currentTime;

    }

    }

}

/* This function writes the settings to the settings.conf file */
/* void WriteSettings(){

	std::ofstream writesettings (settings.c_str());

	if (writesettings.is_open()){

	if (fullscreen == 1 ){

	width = widthoriginal;
	height = heightoriginal;

	}

	writesettings << x << std::endl;
	writesettings << y << std::endl;
	writesettings << width << std::endl;
	writesettings << height << std::endl;
	writesettings << centerwindow << std::endl;
	writesettings << fullscreen << std::endl;
	writesettings << multisampling << std::endl;
	writesettings << vsync << std::endl;
	writesettings << framerate << std::endl;
	writesettings << infointitle << std::endl;
	writesettings << fullscreendialog;

	writesettings.close();

	}

} */

/* This function reads the settings from the settings.conf file */
/* void ReadSettings(){

	std::ifstream readsettings (settings.c_str());

	if (readsettings.is_open()){

	readsettings >> x;
	readsettings >> y;
	readsettings >> width;
	readsettings >> height;
	readsettings >> centerwindow;
	readsettings >> fullscreen;
	readsettings >> multisampling;
	readsettings >> vsync;
	readsettings >> framerate;
	readsettings >> infointitle;
	readsettings >> fullscreendialog;

	settingsexists = 1;

	}

	readsettings.close();

} */
