/*
                 __,,---,__ _    __,,--, __ _
                 |  ___/---,,__,-|  ___//___,,----,______,,---,__ __ _
       _ __ _____|  \_   _  \_   | \\_  __  \_  __   (___)      \ tdmHz
           \\_  __  _|   ____|_ \_/  |  \|   |  \|   | \_   |__//_
            _|  \|  \__  |/  _// |   |_  |  _|   |  _|  _|   |'  _/'' '
     ==== = \\     ___// '  _|   |____/' ' \\____| \\___\__      | = ====
   - -- ---- \____// \_____/__,,-'   \\__,,---'  |____/   \\_,,--' --- -- -
    daydream bbs : oneliners door v2.o by claywar, esc, and mercyful fate

    This is a cool mod, I suppose.  :)  I (esc) took claywar's old oneliner
    door for daydream, fixed it up a bit, added the user's handle, added
    the option for anonymous posting, and finally, added support for renegade
    style pipe color codes with mercyful fate's additions.  Thanks mercy!
    Lol I'd have never figured out how to parse pipe colors if you didn't
    show me.  Thanks dude.

*/


#include <stdio.h>
#include "ddlib.h"

#define HCHAR	"+"

int tot_liners() {
  FILE *liners;
  char fname[40], buf[256];
  int cnt=0;
  
  *fname = '\0';
  sprintf(fname, "%s/data/oneliners.dat", getenv("DAYDREAM"));
  if (!(liners = fopen(fname, "r")))
    return 0;
 
  
  while (!feof(liners)) {
    fgets(buf, 70, liners);
    if (buf) 
      cnt++;
  }
  
  return cnt;
} 

void add_oneliner(struct dif *d, int nl) {
  FILE *liners, *newfl;
  char fname[40], nfname[40], liner[256], buf[256]; //name[30];
  char *name;
  int cnt=0, tlines=tot_liners();
  int totSize=0, i=0, what=0;
    
  *liner = '\0';

  dd_sendstring(d, "\e[33mDo you wish to remain anonymous? \e[0m(\e[32myes\e[0m/\e[32mNo\e[0m) \e[36m:\e[0m ");
  what = dd_hotkey(d, HOT_NOYES);

  switch (what) {
    case 1:
	sprintf(name, "aNONYMOUS");
	totSize = (74 - strlen(name));
	break;
    case 2:
	dd_getstrval(d, name, USER_HANDLE);
	totSize = (74 - strlen(name));
	break;
    default:
	break;
  }

  dd_sendstring(d, "\e[34mEnter oneliner in space below\e[36m:\n");
  dd_sendstring(d, "\e[35m> \e[36m");
  dd_prompt(d, liner, 78, PROMPT_NOCRLF);
  dd_sendstring(d, "\n");


  for (i = totSize; i <= 80; i++)
  {
	liner[i] = '\0';
  }

  if (!liner || !strcmp(liner,"")) {
    dd_sendstring(d, "\e[36mEmpty oneliners not allowed.\n\e[0m");
    return;
  }

  *fname = '\0';
  sprintf(fname, "%s/data/oneliners.dat", getenv("DAYDREAM"));
  if (!(liners = fopen(fname, "r"))) {
    dd_sendstring(d, "\e[36mUnable to open oneliners.dat, inform op!\e[0m\n");
    dd_pause(d);
    return;
  }
  
  *nfname='\0';
  sprintf(nfname, "%s/data/oneliners.new", getenv("DAYDREAM"));
  if (!(newfl = fopen(nfname, "w+"))) {
    dd_sendstring(d, "\e[36mUnable to create oneliners.new, inform op!\e[0m\n");
    dd_pause(d);
    return;
  }
  
  cnt = 0;
  while (!feof(liners) && (cnt < nl)) {
    *buf = '\0';
    
    fgets(buf,1024,liners);
    if (buf && (cnt || (tlines <= nl))) 
      fprintf(newfl, "%s", buf);
    cnt++;
  }

  fprintf(newfl, "\e[0;37m%s\e[0;36m: \e[0;32m%s\n", name, liner);

  fclose(liners);
  fflush(newfl);
  fclose(newfl);
  unlink(fname);
  rename(nfname, fname);
}
  
    

void list_oneliners(struct dif *d, int nl) {
  FILE *liners;
  char fname[40];
  int cnt=0;
  char buf[256], format[256];
  
  *fname = '\0';
  sprintf(fname, "%s/data/oneliners.dat", getenv("DAYDREAM"));
  if (!(liners = fopen(fname, "r"))) {
    dd_sendstring(d, "\e[36mUnable to open oneliners.dat, inform op!\e[0m\n");
    dd_pause(d);
    return;
  }
  
  while (!feof(liners) && cnt < nl) {
    *buf = '\0';
    
    fgets(buf,256,liners);
    if (buf && !feof(liners)) {
      *format = '\0';
      sprintf(format, "\e[36m%s \e[32m%s\e[0m", HCHAR, buf);
      parsepipes(format);
      dd_sendstring(d, format);
    }
    cnt++;
  }
  
  fclose(liners);
  
}
  

void main(int argc, char *argv[]) {
  struct dif *d;
  int numlines=0;
  char buf[256];
  int what=0;

  if (argc==1) {
    printf("This is a DayDream door.\n");
    exit(1);
  }

  d = dd_initdoor(argv[1]);

  if (d == 0) {
    printf("Couldn't find socket!\n");
    exit(1);
  }

  if (!argv[2]) {
    dd_sendstring(d, "\e[36mNumber of oneliners to list was not specified!\e[0m\n");
    dd_pause(d);
    dd_close(d);
    exit(1);
  } else numlines=atoi(argv[2]);


  dd_changestatus(d, "Listing oneliners.");

  dd_typefile(d, "onelntop", TYPE_MAKE|TYPE_WARN);

  list_oneliners(d, numlines);

  dd_typefile(d, "onelnbot", TYPE_MAKE|TYPE_WARN);

  *buf='\0';
  sprintf(buf, "\n\e[33mDo you wish to add a oneliner? \e[0m(\e[32myes\e[0m/\e[32mNo\e[0m) \e[36m:\e[0m ");
  dd_sendstring(d, buf);
  what = dd_hotkey(d, HOT_NOYES);

  switch (what) {
    case 1:
      add_oneliner(d, numlines);
      break;
    default:
      break;
  }

  dd_close(d);

}

// Ansi Forground Escape Sequences
void ansi_fg(char *data, int fg) {

    switch (fg) {
        case 0:
            strcat(data, "\e[0;30m");
            break;
        case 1:
            strcat(data, "\e[0;34m");
            break;
        case 2:
            strcat(data, "\e[0;32m");
            break;
        case 3:
            strcat(data, "\e[0;36m");
            break;
        case 4:
            strcat(data, "\e[0;31m");
            break;
        case 5:
            strcat(data, "\e[0;35m");
            break;
        case 6:
            strcat(data, "\e[0;33m");
            break;
        case 7:
            strcat(data, "\e[0;37m");
            break;
        case 8:
            strcat(data, "\e[1;30m");
            break;
        case 9:
            strcat(data, "\e[1;34m");
            break;
        case 10:
            strcat(data, "\e[1;32m");
            break;
        case 11:
            strcat(data, "\e[1;36m");
            break;
        case 12:
            strcat(data, "\e[1;31m");
            break;
        case 13:
            strcat(data, "\e[1;35m");
            break;
        case 14:
            strcat(data, "\e[1;33m");
            break;
        case 15:
            strcat(data, "\e[1;37m");
            break;
        default :
            break;
    }
}

// Ansi Background Escape Sequences
void ansi_bg(char *data, int bg) {

    switch (bg) {
        case 16:
            strcat(data, "\e[40m");
            break;
        case 17:
            strcat(data, "\e[44m");
            break;
        case 18:
            strcat(data, "\e[42m");
            break;
        case 19:
            strcat(data, "\e[46m");
            break;
        case 20:
            strcat(data, "\e[41m");
            break;
        case 21:
            strcat(data, "\e[45m");
            break;
        case 22:
            strcat(data, "\e[43m");
            break;
        case 23:
            strcat(data, "\e[47m");
            break;
        // Default to none.
        case 24:
            strcat(data, "\e[0m");
            break;
        default : break;
    }
}

// Parsepipes, parses all |01 - |23 codes
void parsepipes(char* szString) {
	
    char szReplace[1024]    = {0};  // Holds Ansi Sequence
    char szStrBuilder[2048] = {0};  // Holds new String being built

	
	int size  = strlen(szString);   // get size of string we are parsing,
	int index = 0;	                // Index of Pipe Char in String
	char* pch;                      // Pointer to Pipe Char in String if found
	
	// Generic Counters
	int i = 0;  
	int j = 0;
	
  	// Search Initial String for Pipe Char, if not found exit, else continue
    pch = (char*) memchr (szString, '|', size);  
  	if (pch != NULL)
  	{
 		// Calculate Index Position of | char found in string.
		index = pch-szString;   
		//printf("Pipe Code found!: %d, size %d \r\n", index, size);	
	}
	else
	{
	 	// No Pipe Code in String 
		// no need to test further, so return
    	return;
	}

    // Setup Loop through String to test and replace pipe codes with
    // Ansi ESC Sequences.
    for (  ; index < size; index++)
	{
        // Make sure pipe can't possibly extend past the end of the string.
        // End of String reached, no possiable pipe code.
        if (index +2 >= size)
           return;
           
        // Test if Current Index is a Pipe Code.
        if (szString[index] == '|') 
		{
            memset(&szReplace,0,sizeof(szReplace));
            memset(&szStrBuilder,0,sizeof(szStrBuilder));
                  
		    // Make Sure Both Chars after Pipe Code are Digits or Numbers.
			// Else Pass through and Ignore.            
            if ( isdigit(szString[index+1]) && isdigit(szString[index+2]) )
			{
                switch (szString[index+1]) 
				{                    
                    case '0' : // Parse First Digit 0
                        switch (szString[index+2]) 
						{			// Parse Second Digit 0 - 9
                            case '0' : ansi_fg(szReplace, 0); break;
                            case '1' : ansi_fg(szReplace, 1); break;
                            case '2' : ansi_fg(szReplace, 2); break;
                            case '3' : ansi_fg(szReplace, 3); break;
                            case '4' : ansi_fg(szReplace, 4); break;
                            case '5' : ansi_fg(szReplace, 5); break;
                            case '6' : ansi_fg(szReplace, 6); break;
                            case '7' : ansi_fg(szReplace, 7); break;
                            case '8' : ansi_fg(szReplace, 8); break;
                            case '9' : ansi_fg(szReplace, 9); break;
                            default : 
								break;
                        }
                        break;
					
                    case '1' : // Parse First Digit 1
                        switch (szString[index+2]) 
						{			// Parse Second Digit 10 - 19
                            case '0' : ansi_fg(szReplace, 10); break;
                            case '1' : ansi_fg(szReplace, 11); break;
                            case '2' : ansi_fg(szReplace, 12); break;
                            case '3' : ansi_fg(szReplace, 13); break;
                            case '4' : ansi_fg(szReplace, 14); break;
                            case '5' : ansi_fg(szReplace, 15); break;
                            case '6' : ansi_bg(szReplace, 16); break;
                            case '7' : ansi_bg(szReplace, 17); break;
                            case '8' : ansi_bg(szReplace, 18); break;
                            case '9' : ansi_bg(szReplace, 19); break;
                            default : 
								break;
                        }
                        break;

                    case '2' : // Parse First Digit 2
                        switch (szString[index+2]) 
						{			// Parse Second Digit 20 - 23
                            case '0' : ansi_bg(szReplace, 20); break;
                            case '1' : ansi_bg(szReplace, 21); break;
                            case '2' : ansi_bg(szReplace, 22); break;
                            case '3' : ansi_bg(szReplace, 23); break;
                            default :
								break;
                        }
                    break;
                    
                } // End Switch

                // Check if we matched an Ansi Sequence
                // If we did, Copy string up to, not including pipe,
                // Then con cat new ansi sequence to replace pipe in 
				// our new string And copy remainder of string back 
				// to run through Search for next pipe sequence.
                
                if (strcmp(szReplace,"") != 0)
                {
					//printf("szReplace found! \r\n");				   						 
				   						 
				    // Sequence found.
					// 1. Copy String up to pipe into new string.
					for (i = 0; i < index; i++)
						szStrBuilder[i] = szString[i];
						
					// ConCat New Ansi Sequence into String
					strcat(szStrBuilder,szReplace);
				   						 
					// Skip Past 2 Digits after pipe, and copy over remainder of 
					// String into new string so we have a complete string again.
					// used to be szStrBuilder)-1
					for (i = strlen(szStrBuilder), j = index+3; j < size; i++, j++)					
						szStrBuilder[i] = szString[j];
						
					// Not reaassign new string back to Original String.
					sprintf(szString,"%s",szStrBuilder);
										
					// Reset new size of string since ansi sequence is longer
					// Then a pipe code.					
					size = strlen(szString);
					
					// then test again
					// if anymore pipe codes exists,  if they do repeat process.
		            pch = (char*) memchr (szString, '|', size);  
  					if (pch != NULL)
				  	{
				 		// Calculate Index Position of | char found in string.
						index = pch-szString;   
						--index; // Loop will incriment this so we need to set it down 1.
						//printf("Found second sequence ! index %d, size %d\r\n",index, size);	
					}
					else
					{
					 	//printf("Not Found second sequence ! \r\n");	
					 	// No Pipe Code in String 
						// no need to test further, so return
				    	return;
					}

                }
            }         	
        }        
    } // End of For Loop, Finished.
}

