{
 ____________     _  ________________________________   /\   ________________
____    __  \     __________      /    ____________ \ /  \__\________      /
.:/     \     \  ____ |:   _/    _/     \/:    \  :\ Y _______/:   _/    _/:
:/      :Y     \_  ____     \    \      \      /    \ /     \_     \    \:
/        |______/   .:|___________/____________/      Y________/___________/:
\________|: [ DA A BOMB CREW PRESENTS YA ] :\_________|: [ UART ROUTiNES  ]..

}
UNIT UartUnit;

INTERFACE

USES DOS, CRT, Uartine;

PROCEDURE InitPort(ComPort,
                   Parity,
                   Stop,
                   WLength : Byte;
                   Speed   : Word);

FUNCTION CharReady(ComPort : Byte) : Boolean;

{This procedure  writes a char to desired port}
PROCEDURE SendChar(Ch : Char; ComPort : Byte);

{This function reads a char from the serial port by dequeueing and element}
FUNCTION GetChar(ComPort : Byte) : Char;

PROCEDURE ShutDown(ComPort : Byte);

PROCEDURE UartWrite(S: String; Comport : Byte);

PROCEDURE UartClrScr(Comport : Byte);

TYPE
  UART = RECORD
     THR : Integer; {Transmit Holding Register}
     RBR : Integer; {Receive Holding Register}
     IER : Integer; {Interrupt enable Regeister}
     LCR : Word;    {Line Control Register}
     MCR : Integer; {Modem Control Register}
     LSR : Integer; {Line Status Register}
     MSR : Integer; {Modem Status Register}
     IRQ : Integer;
     DLL : Word;
     DLM : WOrd;
  END;

  {This array holds the buffers for each port}
  BufferArray  = ARRAY[1..4] OF Queue;
  {Here is where we save the old interrupt vectors}
  PointerArray = ARRAY[1..4] OF Pointer;


CONST
{The following are constants used in initialization, and for port adressing}
  COM1 = 1;
  COM2 = 2;
  COM3 = 3;
  COM4 = 4;

{Baud rate divisors}
  B600  = 192;
  B1200 = 96;
  B2400 = 48;
  B4800 = 24;
  B9600 = 12;
  B19200 = 6;
  B38400 = 3;  {If your really feeling frisky}

{Parity masks}
  NoParity   = 0;
  OddParity  = $8;
  EvenParity = $18;

{Stop bit masks}
  OneStopBit = 0;
  TwoStopBit = 2;

{OR-Mask to set divisor latch in line control register}
  DLatch      = $80;

{Port address for interrupt mask port of 8259A}
  IntMaskPort = $21;

{Port address for 8259 interrupt control, used to send EOI}
  IntCtlPort  = $20;

{Masks for different word lengths}
  Word5 = 0;
  Word6 = 1;
  Word7 = 2;
  Word8 = 3;

IMPLEMENTATION

CONST
{Typed constant that contains all registers addresses for Com1..Com4}
  RS232 : ARRAY[1..4] OF UART =

((THR:$3F8;RBR:$3F8;IER:$3F9;LCR:$3FB;MCR:$3FC;LSR:$3FD;MSR:$3FE;IRQ:4;DLL:$3F8),

(THR:$2F8;RBR:$2F8;IER:$2F9;LCR:$2FB;MCR:$2FC;LSR:$2FD;MSR:$2FE;IRQ:3;DLL:$2F8),

(THR:$3E8;RBR:$3E8;IER:$3E9;LCR:$3EB;MCR:$3EC;LSR:$3ED;MSR:$3EE;IRQ:4;DLL:$3E8),

(THR:$2E8;RBR:$2E8;IER:$2E9;LCR:$2EB;MCR:$2EC;LSR:$2ED;MSR:$2EE;IRQ:3;DLL:$2E8));


VAR
  Buffers     : BufferArray;
  IntVecsSave : PointerArray;

{Inline Macros}
PROCEDURE DisableInterrupts ;   inline( $FA {cli} ) ;
PROCEDURE EnableInterrupts ;    inline( $FB {sti} ) ;

{Here is the interrupt procedure for com3, its address is put int the int
 Vec table by InitPort}
PROCEDURE Com13ISR; INTERRUPT;

BEGIN
{Read the character from the port and put it in the queue}
  Enqueue(Buffers[Com3],Char(Port[RS232[Com3].RBR]));
  Port[IntCtlPort] := $20;  {Non-specific EOI}
END;

PROCEDURE Com24ISR; INTERRUPT;

BEGIN
{Read the character from the port and put it in the queue}
  Enqueue(Buffers[Com3],Char(Port[RS232[Com3].RBR]));
  Port[IntCtlPort] := $20;  {Non-specific EOI}
END;

PROCEDURE InitPort(ComPort,
                   Parity,
                   Stop,
                   WLength : Byte;
                   Speed   : Word);

VAR
  LineFormat : Byte;


BEGIN
  MakeQueueEmpty(Buffers[ComPort],2048);
  LineFormat := 0;
{Build the line format byte}
  LineFormat := LineFormat OR WLength OR Stop OR Parity;
{Set divisor latch so we can set baud rate}
  Port[RS232[ComPort].LCR] := LineFormat AND DLatch;
{Now we set baud rate, least sig part of divisor sent first then most sig}
  Port[RS232[ComPort].DLL] := Low(Speed);
  Port[RS232[ComPort].DLM] := Hi(Speed);
{Now set line format}
  Port[RS232[ComPort].LCR] := LineFormat;
{Must set out2 of modem control reg for interrupts, so we do it here}
  Port[RS232[ComPort].MCR] := $0B;
{Save interrupt vector so we can restore it later, then set vector to
 point at our ISR}

{Now we must unmask appropriate int line in 8259A interrupt controller
 We are using IRQ4 for com1 and 3, and IRQ3 for com2 and 4, use of any
 other IRQ line will require changes to the code}
  IF ODD(ComPort) THEN BEGIN
    GetIntVec(RS232[ComPort].IRQ+8,IntVecsSave[ComPort]);
    SetIntVec(RS232[ComPort].IRQ+8,@Com13ISR);
    Port[IntMaskPort] := Port[IntMaskPort] AND $EF
  END ELSE BEGIN
    GetIntVec(RS232[ComPort].IRQ+8,IntVecsSave[ComPort]);
    SetIntVec(RS232[ComPort].IRQ+8,@Com24ISR);
    Port[IntMaskPort] := Port[IntMaskPort] AND $F7;
  END;
{Here we tell 8250 UART to interrupt on received chars}
  DisableInterrupts;
    Port[Rs232[ComPort].IER] := 1;
  EnableInterrupts;

END;

{This function returns true if there are any chars in the buffer}
FUNCTION CharReady(ComPort : Byte) : Boolean;

BEGIN
  CharReady := NOT QueueIsEmpty(Buffers[ComPort]);
END;

{This procedure  writes a char to desired port}
PROCEDURE SendChar(Ch : Char; ComPort : Byte);

BEGIN
  {Loop until transmit holding register empty}
  WHILE (Port[RS232[ComPort].LSR] AND $20) <> $20 DO
    Delay(1);
  Port[RS232[ComPort].THR] := Byte(Ch);
END;

{This function reads a char from the serial port by dequeueing and element}
FUNCTION GetChar(ComPort : Byte) : Char;

VAR
  Ch : Char;

BEGIN
  Dequeue(Buffers[ComPort],Ch);
  GetChar := Ch;
END;


PROCEDURE ShutDown(ComPort : Byte);

BEGIN
  SetIntVec(RS232[ComPort].IRQ+8,IntVecsSave[ComPort]);
END;

PROCEDURE UartWrite(S: String; Comport : Byte);
VAR
    A : INTEGER;
BEGIN;
FOR A := 1 to length(s) do sendchar(s[A],Comport);
for a := 1 to length(s) do write(s[A]);
END;

PROCEDURE UartClrScr(Comport : Byte);
BEGIN
UartWrite(#27'[2J',Comport);
END;

END.

