function _init()
	pattern={
		0b0000000001,
		0b0000000101,
		0b0010100011,
		0b0001100001,
		0b0011100101,
		0b0000010011,
		0b0000001001,
		0b0100100101,
		0b0010010011,
		0b1111111111
	}
	pt = {}
	local scale = 3.5
	for row = 0, 18 do
		for col = 0, 18 do
			local pattern_row, pattern_col
			if row <= 9 then pattern_row = row
			else pattern_row = 18 - row end
			if col <= 9 then pattern_col = col
			else pattern_col = 18 - col end
			local bit = (pattern[pattern_row+1] >> (9 - pattern_col)) & 1
			if bit == 1 then
				local p = {}
				p.x = (col - 9) * 0.1 * scale
				p.y = (row - 9) * 0.1 * scale
				p.z = 0
				p.org_x = p.x
				p.org_y = p.y
				p.org_z = p.z
				local dist = sqrt(p.x*p.x + p.y*p.y)
				p.col = 8 + ((p.x*10 + p.y*7 + dist*5) % 7)
				p.highlight = 7
				add(pt, p)
			end
		end
	end
	rot_x_speed = 0.01
	rot_y_speed = 0.016
	rot_z_speed = 0.01
	animation_timer = 0
end

function rot(x, y, a)
	local x0 = x
	x = cos(a)*x - sin(a)*y
	y = cos(a)*y + sin(a)*x0
	return x, y
end

function _update()
	animation_timer += 1/30
	rot_x_speed = mid(-0.05, rot_x_speed, 0.05)
	rot_y_speed = mid(-0.05, rot_y_speed, 0.05)
end

function _draw()
	cls()
	local t = animation_timer
	for p in all(pt) do
		local x, y, z = p.x, p.y, p.z
		local breath = 1 + sin(t * 2 + p.x * 3) * 0.1
		x = p.org_x * breath
		y = p.org_y * breath
		z = p.org_z + sin(t * 3 + p.y * 2) * 0.1
		x, z = rot(x, z, t * rot_y_speed)
		y, z = rot(y, z, t * rot_x_speed)
		x, y = rot(x, y, t * rot_z_speed)
		z = z + 3.5 + cos(t/3) * 0.5
		p.cx, p.cy, p.cz = x, y, z
	end
	for pass = 1, 2 do
		for i = 1, #pt - 1 do
			if pt[i].cz < pt[i+1].cz then
				pt[i], pt[i+1] = pt[i+1], pt[i]
			end
		end
	end
	local base_rad = 3 + cos(t/2) * 1.5
	for p in all(pt) do
		if p.cz > 0.5 then
			local sx = 64 + p.cx * 64 / p.cz
			local sy = 64 + p.cy * 64 / p.cz
			local rad = base_rad / p.cz
			if rad > 0.5 then
				local color = p.col
				local dist_from_center = sqrt(p.org_x*p.org_x + p.org_y*p.org_y)
				if dist_from_center < 0.3 then
					color = 7
				end
				circfill(sx, sy, rad, color)
				local highlight_rad = max(1, rad * 0.3)
				local highlight_x = sx + rad/3
				local highlight_y = sy - rad/3
				circfill(highlight_x, highlight_y, highlight_rad, p.highlight)
			end
		end
	end
end