; Vintage Computing Christmas Challenge 2025 - v1
; Jose Moreno Prieto 'Xeleh' - 02/12/2025

main:
            org     100h
            mov     bh,-9           ; initial row
.row        mov     bl,-9           ; initial column
.col        cmp     bl,0            ; central column?
            je      .star           ; yes -> print * char
            cmp     bh,0            ; central row?
            je      .star           ; yes -> print * char
            mov     al,bh           ; al = row
            imul    bh              ; al = row * row
            mov     dl,al           ; dl = row * row
            mov     al,bl           ; al = column
            imul    bl              ; al = column * column
            mov     dh,al           ; dh = column * column
            add     al,dl           ; al = (col * col) + (row * row)
            js      .next           ; if diagonal excedent -> skip print
            cmp     dh,dl           ; diagonal?
            je      .star           ; yes -> print * char
            mov     di,data         ; set data pointer
            mov     cl,6            ; set data length
            repne   scasb           ; find determinant in data
            jne     .next           ; not found? -> skip print
.star       mov     ax,02h<<8|'*'   ; ah = 02h (bios function) | al = '*' char
            push    bx              ; save coords
            mov     dx,bx           ; get coords
            xor     bx,bx           ; clear bx (required by int 10h)
            add     dl,9            ; convert to screen column
            add     dh,9            ; convert to screen row
            int     10h             ; set cursor position
            int     29h             ; print star
            pop     bx              ; restore coords
.next       inc     bl              ; next column
            cmp     bl,9+1          ; end column?
            jne     .col            ; no -> loop
            inc     bh              ; next row
            cmp     bh,9+1          ; end row?
            jne     .row            ; no -> loop

%ifdef      debug
            waitkey
            ret
%endif

data        db      17,29,50,61,68,74