; VCCC 2025
; Snowflake
; Start with INK USR 53513
; 33 bytes

; The contest allows to use default memory after resetting the computer.
; This code uses NOP's in memory after reset for final table value and endless loop to end

	org	53505

; displaytable in reverse to match Y-coordinate
	db	%01000000
	db	%10001010
	db	%00001100
	db	%01001110
	db	%10010000
	db	%00100000
	db	%01001001
	db	%10010010
start	ld	h,b			; set highbyte of table, also first fake value in table	
; all bytes above are part of the table and will be erased by the program

; on start C=A=9

	db	#fa			; JP M, creates an infinite loop when display is done
cloop	add	a,a			; 2x9=18
	sub	b
	ld	b,c
	ld	c,a
	call	#200a			; PRINT AT c,b 
	ld	a,"*"
	rst	16			; display a star
	add	a,h			; A=9 now
	dec	e
	jr	z,rot			; exit when E reaches 0
bloop	jr	c,cloop			; the C from above or shift allows the jump back up to print a star
rot	ld	l,c
	sla	(hl)			; test next display, 10th wil always be a space. (hl) becomes 0 in the end
	djnz	bloop			; next X and test display
	dec	c			; next Y, exit when MINUS above
	jp	(hl)			; jump back to now empty field in table