ctx.textAlign = "center"
ctx.textBaseline = "middle"

const r = (seed[0]*seed[3]) & 0xFF;
const g = (seed[1]*seed[2]) & 0xFF;
const b = (seed[2]*seed[3]) & 0xFF;

const sf = 0.4
const base_color = `rgb(${r}, ${g}, ${b})`;
const shade = `rgb(${r*sf}, ${g*sf}, ${b*sf})`

ctx.fillStyle = "black";
ctx.fillRect(0, 0, 100, 100);
ctx.strokeStyle = `rgb(${seed[0]}, ${seed[0]}, ${seed[0]})`;

function drawShape(points, fill) {
  ctx.beginPath();
  ctx.moveTo(...points[0]);
  points.slice(1).forEach(p => ctx.lineTo(...p));
  ctx.closePath();
  ctx.fillStyle = fill;
  ctx.fill();
  ctx.stroke();
}

const shapeData = [
  { fill: shade, points: [[17,27],[18,64],[27,70],[27,34]]},
  { fill: shade, points: [[39,42],[39,79],[49,86],[49,49]]},
  { fill: base_color, points: [[17,27],[27,34],[49,21],[62,28],[39,42],[49,49],[82,27],[49,10]]},
  { fill: shade, points: [[49,21],[62,28],[52,34],[49,32]]},
  { fill: "black", points: [[27,34],[27,70],[36,64],[36,40],[49,32],[49,21]]},
  { fill: "black", points: [[49,49],[49,86],[71,70],[71,79],[82,70],[82,27]]}, 
  { fill: shade, points: [[64,75],[71,79],[71,70]]},
  { fill: shade, points: [[60,54],[71,59],[71,46]]},
  { fill: base_color, points: [[60,54],[60,67],[71,59]]},
];

shapeData.forEach(shape => {
  drawShape(shape.points, shape.fill);
});