	;
	; MONSTER STRUCTURE:
	; TYPE:	BYTE		(1)
	; CURFR: LOW NIBBLE	(1/2)
	; MAXFR: HI NIBBLE	(1/2)
	; ANGLE: WORD		(2)
	; POSX:	WORD		(2)
	; POSY:	WORD		(2)
	; IN MAP OFFSET: WORD	(2)
	;
	; NOTE:	CURFR -	CURRENT	ANIMATION FRAME
	;	MAXFR -	NUMBER OF ANIMATION FRAMES
	; TYPE:
	; 0: DO	NOT PROCESS (EMPTY SLOT)
	; 1: HUNTER
	; 2: HIT
	; 3: PROJECTILE	PLAYER->HUNTER
	; 4: PROJECTILE	HUNTER->PLAYER
	; 5: AMMO
	;
	; SUBROUTINES FOR 1 STEP MOVE
MNPRCS:	.WORD MHNTR,MHIT,MPROJ1,MPROJ2,MAMMO
	;
	; CLEAR	ACTORS BUFFER
CLMNBF:	MOV #MNBF,R5
1$:	CLR (R5)+
	CMP #MNBFE,R5
	BNE 1$
	RET
	;
	; SET POSITION (SAME PROC.FOR ALL)
SETIPS:	CALL FRN
	MOV RAN,R0
	BIC #176000,R0
	CALL FRN
	MOV RAN,R1
	BIC #176000,R1
	CALL CHECK
	BNE SETIPS
	CALL CHECKP		; GET OFFSET
	CMPB VIS(R2),FRCNTR	; DO NOT RESPAWN IN
	BEQ SETIPS		; VISIBLE AREA
	MOV R0,4.(R5)		; POSX
	MOV R1,6.(R5)		; POSY
	MOV R2,8.(R5)		; SAVE OFFSET
	; RANDOMIZE ANIMATIONS
	MOVB 1.(R5),R3
	ASR R3
	ASR R3
	ASR R3
	ASR R3
	BIC #177760,R3
	MOV R3,-(SP)
	CALL FRN
	MOV RAN,R3
	BIC #177760,R3
	CMP R3,(SP)+
	BLO 1$
	CLR R3
1$:	BICB #15.,1.(R5)	; CLEAR	OLD CNTR
	BISB R3,1.(R5)
	; ANGLE	SETUP
	CALL FRN
	MOV RAN,R3
	BIC #177000,R3		; 0..511
	MOV R3,2.(R5)		; ANGLE
	RET
	;
	; SET HUNTERS
SETHNT:	MOV #MNBF,R5
1$:	MOVB #1.,(R5)		; TYPE=HUNTER
	MOVB HNTRS,1.(R5)	; FRAME,NUMBER OF FRAMES
	CALL SETIPS
	MOVB #255.,MAP(R2)	; TEMP MARK
	ADD #MNRS,R5
	CMP #MNBFS,R5
	BNE 1$
	RET
	;
	; SET AMMOS
SETAMM:	MOV #MNBFX,R5
1$:	MOVB #5.,(R5)		; TYPE=AMMO
	MOVB AMMOS,1.(R5)	; FRAME,NUMBER OF FRAMES
	CALL SETIPS
	MOVB #255.,MAP(R2)	; TEMP MARK
	ADD #MNRS,R5
	CMP #MNBFE,R5
	BNE 1$
	RET
	;
	; CLEAR	TEMP MARKS
CLTMRK:	MOV #MAP,R5
	MOV #256.,R4
1$:	CMPB (R5),#255.
	BNE 2$
	CLRB (R5)
2$:	INC R5
	SOB R4,1$
	RET
	;
	; ACTORS INITIAL SETUP
MNSET:	CALL MSKSIN
	CALL CLMNBF
	CALL SETHNT
	CALL SETAMM
	CALL CLTMRK
	RET
	;
NEXTFR:	CALL @SNDPR
	BITB TKCNTR,#1		; SLOW BY 2
	BNE 1$
	MOVB 1.(R5),R0
	BEQ 1$
	MOVB R0,R1
	BICB #360,R1
	INCB R1
	ASR R0
	ASR R0
	ASR R0
	ASR R0
	BICB #360,R0
	BICB #17,1.(R5)
	CMPB R0,R1
	BEQ 1$
	BISB R1,1.(R5)
1$:	RET
	;
MHNTR:	CALL @SNDPR
	MOV 2.(R5),R0		; ANGLE
	CALL GSNCS
	ASR R0			; SLOW BY X2
	ASR R1			; SLOW BY X2
	ADD 4.(R5),R0
	ADD 6.(R5),R1
	CALL CHECK
	BNE 1$
	MOV R0,4.(R5)
	MOV R1,6.(R5)
	CALL CHECKP
	MOV R2,8.(R5)
	BR 2$
1$:	CALL @SNDPR
	CALL FRN
	MOV RAN,R2
	BIC #177000,R2		; 0..127
	MOV R2,2.(R5)		; NEW ANGLE
	CMP GSTATE,#GSHTWN
	BNE 2$
	CMP R5,#MNBF
	BNE 2$
	CALL CORRA
2$:	CALL NEXTFR
	RET
MHIT:	CALL NEXTFR
	BNE 1$
	CLRB (R5)		; GOTO INTO EMPTY
1$:	RET
	; HUNTER->PLAYER
	; IN R0,R1 COORDS
	; OUT R2=0 NO HIT OR R2>0 HIT
HPCHK:	CLR R2
	CMP GSTATE,#GSGAME
	BNE 5$
	MOV R0,-(SP)
	MOV R1,-(SP)
	SUB PLX,R0
	BPL 1$
	NEG R0
1$:	SUB PLY,R1
	BPL 2$
	NEG R1
2$:	CMP R0,#HITRAD
	BHI 4$
	CMP R1,#HITRAD
	BHI 4$
	MOVB SCORE,R0
	INCB R0
	CMPB R0,#SCLIM
	BLO 3$
	; HUNTERS WON: CHANGE GAME STATE,PRINT MESSAGE
	MOV #GSHTWN,GSTATE
	MOV R0,-(SP)
	MOV R2,-(SP)
	MOV R3,-(SP)
	MOV R5,-(SP)
	MOV #2,R5
	CALL PRNMS
	MOV #3,R5
	CALL PRNMS
	CALL CORRA
	MOV (SP)+,R5
	MOV (SP)+,R3
	MOV (SP)+,R2
	MOV (SP)+,R0
	;
3$:	MOVB R0,SCORE
	INC R2
4$:	MOV (SP)+,R1
	MOV (SP)+,R0
5$:	RET
	; DESTROY ALL HUNTERS
DALL:	MOV #MNBF,R5
1$:	TSTB (R5)
	BEQ 2$
	MOVB #2.,(R5)
	MOVB HITS,1.(R5)	; FRAME,NUMBER OF FRAMES
	BIS #4.,SNDBM
2$:	ADD #MNRS,R5
	CMP #MNBFS,R5
	BNE 1$
	RET
	; PLAYER->HUNTER
	; IN R0,R1 COORDS
	; OUT R2=0 IF NO HIT ELSE R2=MONSTER PTR
PHCHK:	CLR R2
	CMP GSTATE,#GSGAME
	BNE 7$
	MOV R0,-(SP)
	MOV R1,-(SP)
	MOV R5,-(SP)
	MOV #MNBF,R5
1$:	TSTB (R5)
	BEQ 2$
	MOV 4(SP),R0
	MOV 2(SP),R1
	SUB 4(R5),R0
	BPL 3$
	NEG R0
3$:	SUB 6(R5),R1
	BPL 4$
	NEG R1
4$:	CMP R0,#HITRAD
	BHI 2$
	CMP R1,#HITRAD
	BHI 2$
	MOVB SCORE+1,R0
	INCB R0
	CMPB R0,#SCLIM
	BLO 5$
	; PLAYER WON: CHANGE GAME STATE,PRINT MESSAGE
	MOV #GSPLWN,GSTATE
	MOV R0,-(SP)
	MOV R3,-(SP)
	MOV #1,R5
	CALL PRNMS
	MOV #3,R5
	CALL PRNMS
	CALL DALL
	MOV (SP)+,R3
	MOV (SP)+,R0
	CLR R5
	;
5$:	MOVB R0,SCORE+1
	MOV R5,R2
	BR 6$
2$:	ADD #MNRS,R5
	CMP #MNBFS,R5
	BNE 1$
6$:	MOV (SP)+,R5
	MOV (SP)+,R1
	MOV (SP)+,R0
7$:	RET
MPROJ1:	CALL @SNDPR
	MOV 2.(R5),R0		; ANGLE
	CALL GSNCS2
	ADD 4.(R5),R0
	ADD 6.(R5),R1
	; CHECK	HITS TARGET
	CMPB (R5),#4.
	BNE 4$
	CALL HPCHK
	TST R2
	BEQ 5$			; NO HIT
	; EFFECT - DROP	PLAYER BACKWARD
	MOV 2.(R5),R0		; ANGLE
	CALL GSNCS
	CALL DUP2
	BR 1$  ; HIT SOUND&FL.EFFECT
4$:	CALL PHCHK
	TST R2
	BEQ 5$
	; COPY POSITION
	MOV 4.(R2),4.(R5)
	MOV 6.(R2),6.(R5)
	; WE HIT MONSTER->SPAWN	NEW ONE
	MOV R5,-(SP)
	MOV R2,R5
	CALL SETIPS
	MOV (SP)+,R5
	BR 1$
5$:	CALL CHECK
	BNE 1$
	MOV R0,4.(R5)
	MOV R1,6.(R5)
	CALL CHECKP
	MOV R2,8.(R5)
	BR 2$
1$:	CALL @SNDPR
	MOVB #2.,(R5)		; GOTO INTO HIT
	MOVB HITS,1.(R5)	; FRAME,NUMBER OF FRAMES
	BIS #4.,SNDBM		; HIT SOUND
	BR 3$
2$:	CALL NEXTFR
3$:	RET
MPROJ2:	JMP MPROJ1		; SAME AS MPROJ1
MAMMO:	CMPB AMMO,#30.		; IF ALWAYS FULL AMMO
	BHIS 3$			; DO NOTHING
	MOV PLX,R0
	MOV PLY,R1
	SUB 4.(R5),R0
	BPL 1$
	NEG R0
1$:	SUB 6.(R5),R1
	BPL 2$
	NEG R1
2$:	CMP R0,#HITRAD
	BHI 3$
	CMP R1,#HITRAD
	BHI 3$
	MOVB AMMO,R0		; ADD +5. AMMO
	ADD #5.,R0
	CMP R0,#30.
	BLOS 4$
	MOV #30.,R0
4$:	MOVB R0,AMMO
	CALL SETIPS		; RESPAWN AT NEW POS
	BIS #1.,SNDBM		; TAKE AMMO SOUND
3$:	JMP NEXTFR		; ONLY NEXT FRAME
	;
	; MAKE 1 STEP MOVE
MNMOV:	MOV #MNBF,R5
1$:	CALL @SNDPR
	MOVB (R5),R0
	BEQ 2$
	ASL R0
	CALL @MNPRCS-2(R0)
2$:	ADD #MNRS,R5
	CMP #MNBFE,R5
	BNE 1$
	RET
	;
	; DO FIRE (PLAYER->HUNTER)
DPROJ1:	CMP GSTATE,#GSHTWN
	BEQ 3$
	TSTB AMMO
	BEQ 3$
	DECB AMMO
	MOV #MNBFS,R5
1$:	TSTB (R5)
	BNE 2$
	MOVB #3.,(R5)
	CLRB 1.(R5)		; FRAME,NUMBER OF FRAMES
	MOV PLX,R0
	MOV PLY,R1
	MOV R0,4.(R5)
	MOV R1,6.(R5)
	MOV PLA,2.(R5)		; ANGLE
	CALL CHECKP
	MOV R2,8.(R5)
	BIS #8.,SNDBM		; FIRE SOUND
	BR 3$
2$:	CALL @SNDPR
	ADD #MNRS,R5
	CMP #MNBFX,R5
	BNE 1$
3$:	RET
	;
	; DO FIRE (HUNTER->PLAYER)
	; NEED SAVE&RESTORE REGISTERS
	; IN R5	- HUNTER THAT FIRES INTO PLAYER
DPROJ2:	;RET			 ; FOR DEBUG MODE
	;
	CMPB #1.,(R5)
	BNE 3$			; IF NOT HUNTER->SKIP
	CMP GSTATE,#GSHTWN
	BEQ 3$
	CALL FRN
	CMP RAN,#4096.
	BHI 3$ ; RANDOM	DELAY
	MOV R0,-(SP)
	MOV R1,-(SP)
	MOV R2,-(SP)
	MOV R4,-(SP)
	; NOW FIND EMPTY SLOT
	MOV #MNBFS,R4
1$:	TSTB (R4)
	BNE 2$
	MOVB #4.,(R4)
	CLRB 1.(R4)		; FRAME,NUMBER OF FRAMES
	MOV 4.(R5),R0
	MOV 6.(R5),R1
	MOV R0,4.(R4)
	MOV R1,6.(R4)
	CALL CHECKP
	MOV R2,8.(R4)
	CALL GETANG
	BIS #8.,SNDBM		; FIRE SOUND
	BR 4$
2$:	CALL @SNDPR
	ADD #MNRS,R4
	CMP #MNBFX,R4
	BNE 1$
4$:	MOV (SP)+,R4
	MOV (SP)+,R2
	MOV (SP)+,R1
	MOV (SP)+,R0
3$:	RET
	;
	.END

 