org 100h

main:
    mov     al, 40
    out     40h, al                     ; write PIT counter divisor low byte
    mov     al, 50
    out     40h, al                     ; write PIT counter divisor high byte (freq = 1,19318181818 MHz / divisor)
    mov     dx, interrupt
    mov     ax, 251Ch
    int     21h
.main:
    jmp   main ; sorry for the infinite loop; if you start your entry on Friday 22 pm there's no time make nice shit

interrupt:
    mov     bp, base
    mov     ax, 0x0120 ; enable other waveforms than just sine
    call    bp
    dec     word [time+bp-base]
    jnz     .skip
    mov     ax, word [time2+bp-base]
    test    ax, ax
    jnz     .time2dec
    mov     word [time+bp-base], 12
    inc     byte [.load]
    mov     al, byte [melody-1]
.load equ $-2
.foo:
    mov     ah, 0xA0
    call    bp
    mov     cx, 10
    mov     si, commands
.loop:
    lodsw
    call    bp
    loop .loop
.skip:
    iret
.time2dec:
    sub  ax, 16
    mov  word [time2+bp-base], ax
    inc  ax
    mov  word [time+bp-base], ax
    mov  al, 50
    jmp  .foo

base equ $

writereg:
    mov dx, 0x220
    xchg ah, al
    out dx, al
    inc dx
    xchg ah, al
    out dx, al
    ret

commands:
    dw 0xB000
    dw 0xB030
    dw 0x2022
    dw 0x2322
    dw 0x6066
    dw 0x6366
    dw 0x8066
    dw 0x8366
    dw 0xE001
    dw 0xE301

time:
    dw 1

time2:
    dw 16*16

melody:
    db 127, 142, 169, 142, 213, 0, 0, 213, 0, 0, 190, 0, 0, 0, 0, 0, 127, 142, 169, 142, 190, 0, 0, 190, 0, 0, 169, 0, 0, 0, 0, 0, 127, 142, 169, 142, 169, 0, 0, 0, 190, 0, 160, 0, 0, 142, 127, 0, 0, 0, 127, 0, 190, 0, 0, 0, 169, 0, 0, 0, 0, 0, 0, 127, 142, 169, 142, 213, 0, 0, 213, 0, 0, 190, 0, 0, 0, 0, 0, 127, 142, 169, 142, 254, 0, 0, 0, 160, 0, 169, 0, 0, 160, 142, 0, 127, 142, 169, 142, 169, 0, 0, 0, 190, 0, 160, 0, 0, 142, 127, 0, 0, 0, 127, 0, 190, 0, 0, 0, 169
