lmpr:          EQU  &FA
hmpr:          EQU  &FB
vmpr:          EQU  &FC
rom0_off:      EQU  %00100000
;mode_4:        EQU  %01100000

AMP: 			EQU 14
SINEDATA:		EQU &9000

autoexec
ORG	&8000
DUMP &8000

pageIndex:
di
ld sp,0

mainloop:

	waitVsync:
		in a,(249)
		and 8		; 249 read, 8 = FRAME
	jr nz,waitVsync

	;xor a
	ld h,a
	ld l,a
	ld d,h
	ld e,h
	inc e
	ld (hl),a
	ld bc,24576
	ldir

	ld b,SINEDATA/256
	ld c,0
	sineX:

		push bc

		ld a,(bc)
		add 128
		ld e,a

		ld a,c
		add 64
		ld c,a
		ld a,(bc)
		add 96
		ld h,a

		;call plotpixel
		;e,h
		plotpixel:
			ld l,0
			ld d,l
			srl h
			rr l

			;ld a,15
			srl e
			jr c,noLeftPix
			add a
			add a
			add a
			add a
		noLeftPix:

			add hl,de
			or (hl)
			ld (hl),a

		pop bc
	dec c
	jr nz,sineX



; Sinegen
	ld h,c	; This will set hl=0, as long as the above stays. That's why 4096 and not 4095
	; is l zero?

nframe:
	ld de,0	; AMP*&3f + AMP/2 (but winape fails this so I typed manually the value)
	ld bc,-AMP
	ld ix,SINEDATA + &80
singen:
	xor a
	sub h
	ld (ix+0),a
	ld (ix-&80),h
	add hl,de
	ex de,hl
	add hl,bc
	ex de,hl
	inc ixl
	jr nz,singen

	ld hl,(nframe+1)
	ld de,8
	add hl,de
	ld a,h
	and 15
	ld h,a
	ld (nframe+1),hl

	;call swapPage
	ld a,(pageIndex)
	inc a
	and 1
	ld (pageIndex),a
	or a
	ld a,%11111110
	ld b,%00111100
	jr nz,show_page0
		ld a,%11111100
		ld b,%00111110
	show_page0:
	out (vmpr),a
	ld a,b
	out (lmpr),a	

jr mainloop
