#version 420 core

uniform float fGlobalTime; // in seconds
uniform vec2 v2Resolution; // viewport resolution (in pixels)
uniform float fFrameTime; // duration of the last frame, in seconds

uniform sampler1D texFFT; // towards 0.0 is bass / lower freq, towards 1.0 is higher / treble freq
uniform sampler1D texFFTSmoothed; // this one has longer falloff and less harsh transients
uniform sampler1D texFFTIntegrated; // this is continually increasing
uniform sampler2D texPreviousFrame; // screenshot of the previous frame
uniform sampler2D texChecker;
uniform sampler2D texInercia2025;
uniform sampler2D texInerciaBW;
uniform sampler2D texInerciaID;
uniform sampler2D texNoise;
uniform sampler2D texTex1;
uniform sampler2D texTex2;
uniform sampler2D texTex3;
uniform sampler2D texTex4;

layout(r32ui) uniform coherent uimage2D[3] computeTex;
layout(r32ui) uniform coherent uimage2D[3] computeTexBack;

layout(location = 0) out vec4 out_color; // out_color must be written in order to see anything
float bpm = 120*fGlobalTime/60;
vec4 getTexture(sampler2D sampler, vec2 uv){

     vec2 size = textureSize(sampler,0);
     float ratio = size.x/size.y;
     return texture(sampler,uv*vec2(1.,-1.*ratio)-.5);
}
vec3 hash3d(vec3 p){
    uvec3 q = floatBitsToUint(p);
    q +=((q>>16u)^q.yzx)*1111111111u;
    q +=((q>>16u)^q.yzx)*1111111111u;
    q +=((q>>16u)^q.yzx)*1111111111u;
  return vec3(q)/float(-1U);
}
vec4 scroller(vec2 uv){  
   uv*=5.;

   return getTexture(texInerciaBW,uv);
  
}
vec3 erot(vec3 p,vec3 ax,float t){return mix(dot(ax,p)*ax,p,cos(t))+cross(ax,p)*sin(t);}
void main(void)
{
	vec2 uv = vec2(gl_FragCoord.x / v2Resolution.x, gl_FragCoord.y / v2Resolution.y);
	uv -= 0.5;
	uv /= vec2(v2Resolution.y / v2Resolution.x, 1);
  
  vec4 inerciabw = scroller(uv);
  vec4 inercia = getTexture(texInercia2025,uv);
vec3 rnd = hash3d(vec3(floor(uv.x*9.),0x898989,-1u));
  vec3 col = vec3(0.);
  float seq = uv.y+rnd.x-sqrt(texture(texFFTSmoothed,mix(.01,.4,rnd.z)).r)*5;
   col = mix(col,sqrt(inercia.rgb),inercia.a)*inerciabw.a*5*exp(-5*fract(seq+bpm)) ;
  
  
  vec3 ro = vec3(uv,-1)*5,rd=vec3(0,0,1);
  
  for(float i=0.,e=0.,g=0.;i++<99.;){
    
       vec3 p= ro+rd*g;
    
       float h=  length(p)-1.;
       g+=e=max(.001,h);
      col +=vec3(1.)*.0125/exp(i*i*e);
    }
  
  
	out_color = vec4(col,1.);
}