local M={}
local frames={}
local poopImgs={}
local poop={}
local emitAcc=0
local t0=nil
local nowTime=0
local function randf(a,b) return a+(b-a)*math.random() end
local function getLegInfo()
if not t0 then return 0,1 end
local elapsed=nowTime-t0
if elapsed<0 then elapsed=0 end
if elapsed<7.680 then
local u=elapsed/7.680
return u,1
else
local e2=elapsed-7.680
local u=math.min(1,e2/7.680)
return u,2 end end
local function getFrameImage()
if not t0 then return frames[1] end
local elapsed=nowTime-t0
if elapsed<0 then elapsed=0 end
local idx=(math.floor(elapsed/0.48)%#frames)+1
return frames[idx] end
local function birdPosition(img)
local iw,ih=img:getWidth(),img:getHeight()
local W,H=love.graphics.getWidth(),love.graphics.getHeight()
local y=math.floor(H*0.18-60+0.5)
local u,leg=getLegInfo()
if leg==1 then
local startX=W+iw
local endX=-iw
local x=math.floor((1-u)*startX+u*endX+0.5)
return x,y,iw,ih,1
else
local startX=-iw
local endX=W+iw
local x0=(1-u)*startX+u*endX
local x=math.floor(x0+iw+0.5)
return x,y,iw,ih,-1 end end
local function emitterPosition(img)
local x,y,iw,ih,flip=birdPosition(img)
local tailY=y+ih*0.56
if flip==1 then
local tailX=x+iw
return tailX-64,tailY-150
else
local tailX=x-iw
return tailX+24,tailY-150 end end
local function emitDroplets(img,n)
if #poopImgs==0 or not img or n<=0 then return end
local ex,ey=emitterPosition(img)
for _=1,n do
local p={
x=ex+randf(-6,6),
y=ey,
vy=randf(45,150),
scl=randf(0.25,2),
life=randf(2.00,4.00),
age=0,
phase=randf(0,0.48) }
table.insert(poop,p) end end
local function updateDroplets(dt)
if dt<=0 then return end
local i=1
while i<=#poop do
local p=poop[i]
p.vy=p.vy+270*dt
p.y=p.y+p.vy*dt
p.age=p.age+dt
local dead=(p.age>=p.life) or (p.y>love.graphics.getHeight()+64)
if dead then
poop[i]=poop[#poop]
poop[#poop]=nil
else
i=i+1 end end end
local function drawDroplets()
if #poopImgs==0 then return end
for i=1,#poop do
local p=poop[i]
local a=1.0-(p.age/p.life)
if a<0 then a=0 elseif a>1 then a=1 end
love.graphics.setColor(1,1,1,a)
local idx=(math.floor((p.age+p.phase)/0.16)%#poopImgs)+1
local img=poopImgs[idx]
local w2=img:getWidth()*0.5*p.scl
local h2=img:getHeight()*0.5*p.scl
love.graphics.draw(img,math.floor(p.x+0.5),math.floor(p.y+0.5),0,p.scl,p.scl,w2/p.scl,h2/p.scl) end end
function M.load()
frames={}
for i=1,#{"seagullflying-01.png","seagullflying-02.png"} do
local img=love.graphics.newImage(({"seagullflying-01.png","seagullflying-02.png"})[i])
img:setFilter("nearest","nearest")
frames[i]=img end
poopImgs={love.graphics.newImage("seagullpoop-01.png"),love.graphics.newImage("seagullpoop-02.png"),love.graphics.newImage("seagullpoop-03.png"),love.graphics.newImage("seagullpoop-04.png"),love.graphics.newImage("seagullpoop-05.png")}
for i=1,#poopImgs do
poopImgs[i]:setFilter("nearest","nearest") end
t0,nowTime=nil,0
poop,emitAcc={},0 end
function M.start(startTime)
t0=startTime or 0
emitAcc=0 end
function M.update(dt,timePassed)
nowTime=timePassed or nowTime
if t0 then
local elapsed=nowTime-t0
if elapsed>=0 and elapsed<=15.36 then
emitAcc=emitAcc+dt*12
local count=math.floor(emitAcc)
if count>0 then
emitAcc=emitAcc-count
emitDroplets(getFrameImage(),count) end end end
updateDroplets(dt) end
function M.draw()
drawDroplets()
if not t0 or #frames==0 then return end
local img=getFrameImage()
local x,y,iw,ih,flip=birdPosition(img)
love.graphics.setColor(1,1,1,1)
if flip==1 then
love.graphics.draw(img,x,y)
else
love.graphics.draw(img,x,y,0,-1,1) end end
function M.isFinished()
if not t0 then return false end
return (nowTime-t0)>=15.36 end
return M
