local M={}
local frames={}
local bursts={}
local cachedTimePassed=0
function M.load()
frames[1]=love.graphics.newImage("seagullalert-01.png")
frames[2]=love.graphics.newImage("seagullalert-02.png")
frames[3]=love.graphics.newImage("seagullalert-03.png")
for i=1,3 do
frames[i]:setFilter("nearest","nearest") end
bursts={}
cachedTimePassed=0 end
function M.fire(now_demo_time)
local t0=now_demo_time or cachedTimePassed
table.insert(bursts,{t0=t0}) end
function M.update(dt,timePassed)
cachedTimePassed=timePassed or cachedTimePassed
local i=1
while i<=#bursts do
local b=bursts[i]
local elapsed=cachedTimePassed-b.t0
if elapsed>=0.75 then
table.remove(bursts,i)
else
i=i+1 end end end
local function drawCentered(img)
if not img then return end
local W,H=love.graphics.getWidth(),love.graphics.getHeight()
local iw,ih=img:getWidth(),img:getHeight()
local x=math.floor((W-iw)*0.5)
local y=math.floor((H-ih)*0.5)
love.graphics.setColor(1,1,1,1)
love.graphics.draw(img,x,y) end
function M.draw()
local now=cachedTimePassed
for _,b in ipairs(bursts) do
local elapsed=now-b.t0
if elapsed>=0 and elapsed<0.75 then
local index=math.floor(elapsed/0.25)+1
if index<1 then index=1 end
if index>3 then index=3 end
drawCentered(frames[index]) end end end
return M
