local birddots={}
local headImg=nil
local headOK=false
local headOX,headOY=0,0
local gridsize=9
local warpmin=50
local warpmax=250
local speed=1.12
local time=0
local vortexstrength=1
local randomseed=1.00
local extrapadding=50
local hueshiftspeed=0.05
local dotsX,dotsY
local spacingX,spacingY
local imageScale
local spriteAlpha
dotsX,dotsY=128,128
spacingX,spacingY=30,30
imageScale=1.0
spriteAlpha=1.0
local function smooth01(x)
if x<0 then x=0 elseif x>1 then x=1 end
return x*x*(3-2*x) end
local function currentTargetSize()
local target=love.graphics.getCanvas()
if target then return target:getWidth(),target:getHeight() end
return love.graphics.getWidth(),love.graphics.getHeight() end
function birddots.load()
gridsize=9
warpmin=50
warpmax=250
speed=1.12
time=0
vortexstrength=1
randomseed=1.00
extrapadding=50
hueshiftspeed=0.05
dotsX=128
dotsY=128
spacingX=30
spacingY=30
imageScale=1.0
spriteAlpha=1.0
headOK=false
headImg=nil
local ok,img=pcall(love.graphics.newImage,"seagullhead.png")
if ok and img then
headImg=img
headImg:setFilter("nearest","nearest")
headOX,headOY=headImg:getWidth()*0.5,headImg:getHeight()*0.5
headOK=true
else
headOK=false end end
function hsvtorgb(h,s,v)
local r,g,b
local i=math.floor(h*6)
local f=h*6-i
local p=v*(1-s)
local q=v*(1-f*s)
local t=v*(1-(1-f)*s)
i=i%6
if i==0 then r,g,b=v,t,p
elseif i==1 then r,g,b=q,v,p
elseif i==2 then r,g,b=p,v,t
elseif i==3 then r,g,b=p,q,v
elseif i==4 then r,g,b=t,p,v
elseif i==5 then r,g,b=v,p,q end
return r,g,b end
function birddots.update(dt)
time=time+dt*speed
local randomfactor=math.sin(time*0.2+randomseed)*0.5+0.5
warpamount=warpmin+(warpmax-warpmin)*randomfactor
vortexstrength=1+math.sin(time*0.1)*0.2 end
function birddots.draw()
local width,height=currentTargetSize()
local fadestart=90.00
local fadeend=96.00
local fadefactor=1
if time>fadestart then
fadefactor=math.max(0,1-(time-fadestart)/(fadeend-fadestart)) end
local bgr=(30/255)*fadefactor
local bgg=(30/255)*fadefactor
local bgb=(64/255)*fadefactor
love.graphics.setBackgroundColor(bgr,bgg,bgb)
local totalW=(dotsX-1)*spacingX
local totalH=(dotsY-1)*spacingY
local originX=(width-totalW)*0.5
local originY=(height-totalH)*0.5
local maxR=math.min(width,height)*0.5
for ix=0,dotsX-1 do
for iy=0,dotsY-1 do
local baseX=originX+ix*spacingX
local baseY=originY+iy*spacingY
local dx=baseX-width/2
local dy=baseY-height/2
local dist=math.sqrt(dx*dx+dy*dy)
local angle=math.atan2(dy,dx)+vortexstrength*dist*0.0005
local radius=dist+warpamount*math.sin(time*speed+dist*0.01)
local wavex=math.cos(angle)*radius-dx
local wavey=math.sin(angle)*radius-dy
local hue=(time*hueshiftspeed+(baseX+baseY)*0.0005)%1
local cr,cg,cb=hsvtorgb(hue,1,1)
local drawX=baseX+wavex
local drawY=baseY+wavey
local cdx=drawX-width*0.5
local cdy=drawY-height*0.5
local postDist=math.sqrt(cdx*cdx+cdy*cdy)
local n=postDist/(maxR*2.5)
n=(n<0) and 0 or ((n>1) and 1 or n)
local weight=(1-smooth01(n))*1.0
if weight>1 then weight=1 end
local r=cr*(1-weight)+0.3764705882352941*weight
local g=cg*(1-weight)+0.2196078431372549*weight
local b=cb*(1-weight)+0.10980392156862745*weight
love.graphics.setColor(r,g,b,spriteAlpha*fadefactor)
if headOK and headImg then
love.graphics.draw(headImg,drawX,drawY,0,imageScale,imageScale,headOX,headOY) else
love.graphics.circle("fill",drawX,drawY,3) end end end
if not headOK then
love.graphics.setColor(1,0.2,0.2,0.85*fadefactor)
love.graphics.rectangle("fill",10,10,math.min(width-20,820),36,6,6)
love.graphics.setColor(1,1,1,1*fadefactor)
love.graphics.print(msg,20,20) end end
return birddots
