import sys, os

def main(fn):
    try:
        with open(fn, 'rb') as fh:
            content = fh.read()
    except Exception as e:
        print(f'Exception while reading file with filename {fn}\n{e}', file=sys.stderr)
        raise

    try:
        with open(fn, 'wb') as fh:
            fh.write(content[2:])
    except Exception as e:
        print(f'Exception while writing file with filename {fn}\n{e}', file=sys.stderr)
        raise
              
if __name__ == '__main__':
    if len(sys.argv) == 2:
        main(sys.argv[1])
    else:
        print(f'Wrong params : {len(sys.argv)}', file=sys.stderr)
        exit(1)
