#type vertex
#version 330 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aTexCoords;

out vec2 TexCoords;

void main (void)
{
TexCoords = aTexCoords;
gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0); 
}

#type fragment
#version 330 core
// This shader needs 2 color attachments
layout (location = 0) out vec4 FragColor;
layout (location = 1) out vec4 BrightColor;

in vec2 TexCoords;
uniform sampler2D screenTexture;


void main()
{           
    vec3 color = texture(screenTexture, TexCoords).rgb;
    FragColor = vec4(color, 1.0);
	float brightness = dot(color, vec3(0.1, 1, 0.1));//vec3(0.1126, 0.1152, 0.0722));
	if(brightness > 0.6)
		BrightColor = vec4(color, 1.0);
	else
		BrightColor = vec4(0.0, 0.0, 0.0, 1.0);
 
}