.import source "common.iasm"
.import source "vic.iasm"
.import source "demo_constants.iasm"

.const SPRITES = 11
.const FRAMES_Y = 16
.const FRAMES_X = 11
.const SIN_DEGREE_X = 40
.const ZP_XINDEX = AllocateZP( "ZP_XINDEX" )

.const BACKGROUND = LIGHT_GRAY;
.const TRANSPARENT_BACKGROUND = CYAN;

.pc = FIRST_SOURCE_LOCATION "main code"
.if ( !GENERATE_CODE_FOR_TEST )
{
      WaitForFrame( FRAME_MERGE_SCROLL_ENTER )
}
else
{
      lda #0
      sta $d011
}
      lda #0
      sta SPRITES_VISIBLE_REGISTER
      lda #0
      sta ZP_XINDEX
      lda #$06
      sta $d020
      sta $d021
      FillMem( $d800, 6, 1000 )
      ldx #0
!loop:
.for ( var rept = 0; rept < 5; rept++ )
{
      lda $6000+200*rept,x
      and #$0f
      asl
      asl
      asl
      sta layout_offscreen+200*rept+$400,x
      lda $6000+200*rept,x
      and #$f0
      lsr
      sta layout_offscreen+200*rept,x
      lda #$06
      sta $6000+200*rept,x
      sta $6400+200*rept,x
}
      inx
      cpx #200
      beq !finished+
      jmp !loop-
!finished:
      lda #SCRY_DEFAULT_MODE_BM 
      sta SCREEN_CONTROL_REGISTER_Y
      lda #SCRX_DEFAULT_MODE_MC
      sta SCREEN_CONTROL_REGISTER_X
      lda #calculateDisplayValue( $4000, $6000 )
      sta SCREEN_CHARACTER_MEMORY_ADDRESS
      lda #VIC_BANK_4000
      sta VIC_BANK_SELECT_REGISTER

      lda #$00
      sta SPRITES_MULTICOLOR_ENABLED
      sta $d001
      sta $d003
      sta $d005
      sta $d007
      sta $d009
      sta $d00b
      sta $d00d
      sta $d00f
      sta SPRITES_PRIORITY_REGISTER
      lda #$ff
      sta SPRITES_STRETCHX_ENABLED
      sta SPRITES_STRETCHY_ENABLED
.const ZP_SPRITE_CACHE = AllocateRangeZP( 2*SPRITES, "ZP_SPRITE_CACHE" )
.const ZP_CACHE_S = AllocateRangeZP( SPRITES, "ZP_CACHE_S" )
      lda #SpriteIndex( spritefont )
      ldx #0
!loop:
      sta ZP_SPRITE_CACHE,x
      sta ZP_SPRITE_CACHE+SPRITES,x
      sta ZP_CACHE_S,x
      inx
      cpx #SPRITES
      bne !loop-
      ldx #3
!loop:
      lda #LIGHT_RED
      sta $d027,x
      lda #$02
      sta $d02b,x
      dex
      bpl !loop-

.const ZP_XPOS = AllocateZP( "ZP_XPOS_1" )
      lda #10; sta ZP_XPOS
.const ZP_TEXT_INDEX = AllocateZP( "ZP_TEXT_INDEX" )
.const ZP_FADEIN_INDEX = AllocateZP( "ZP_FADEIN_INDEX" )
.const ZP_SIGNAL_SWAP = AllocateZP( "ZP_SIGNAL_SWAP" )
      lda #0
      sta ZP_TEXT_INDEX
      sta ZP_FADEIN_INDEX
      sta ZP_SIGNAL_SWAP
.const ZP_LAYOUT_DEST = AllocateRangeZP( 8, "ZP_LAYOUT_DEST" )
      ldx #$64
      lda #0
      sta ZP_LAYOUT_DEST+0
      stx ZP_LAYOUT_DEST+1
      inx
      sta ZP_LAYOUT_DEST+2
      stx ZP_LAYOUT_DEST+3
      inx
      sta ZP_LAYOUT_DEST+4
      stx ZP_LAYOUT_DEST+5
      inx
      sta ZP_LAYOUT_DEST+6
      stx ZP_LAYOUT_DEST+7

      InitSignal()
      SetNewIRQFromMain( irq_fadein, RASTERLINE_FIRST_OFFSCREEN )
fadein_mainloop:
      ldy #0
!loop:
.for ( var row = 0; row < 4; row++ )
{
      lda layout_offscreen+$400+row*$100,y
      clc
      adc ZP_FADEIN_INDEX
      tax
      lda fadein_tables,x
      sta d800_cache+row*$100,y

      lda layout_offscreen+row*$100,y
      clc
      adc ZP_FADEIN_INDEX
      tax
      lda fadein_tables,x
      sta (ZP_LAYOUT_DEST+2*row),y
}
      iny
      beq !finished+
      jmp !loop-
!finished:
      lda ZP_LAYOUT_DEST+1
      clc
      adc #4
      and #$64
      sta ZP_LAYOUT_DEST+1
      adc #1
      sta ZP_LAYOUT_DEST+3
      adc #1
      sta ZP_LAYOUT_DEST+5
      adc #1
      sta ZP_LAYOUT_DEST+7


      lda ZP_FADEIN_INDEX
      ldx #1
      stx ZP_SIGNAL_SWAP
!wait:
      cmp ZP_FADEIN_INDEX
      beq !wait-
      lda ZP_FADEIN_INDEX
      cmp #8
      beq !finished+
      jmp fadein_mainloop
!finished:
      WaitForSignal( SIGNAL_PART_FINISHED )
      lda #0
      sta SPRITES_VISIBLE_REGISTER
      jmp LOAD_AND_RUN

.const ZP_CACHE_X = AllocateRangeZP( 2*SPRITES, "ZP_CACHE_X" )
.const ZP_D010 = AllocateZP( "ZP_D010" )

.align $40
irq_top:
      jmp do_top
irq_row4:
      jmp do_row4
irq_row5:
      jmp do_row5
irq_row6:
      jmp do_row6
irq_row7:
      jmp do_row7
irq_row8:
      jmp do_row8
irq_row9:
      jmp do_row9
irq_row10:
      jmp do_row10

fadein_tables:
      .byte $6,$6,$6,$6,$0,$0,$0,$0 // 0
      .byte $6,$b,$4,$e,$5,$3,$d,$1 // 1
      .byte -1,-1,-1,-1,-1,-1,-1,-1 // 2
      .byte $6,$6,$6,$b,$4,$e,$5,$3 // 3
      .byte -1,-1,-1,-1,-1,-1,-1,-1 // 4
      .byte $6,$6,$6,$6,$b,$4,$e,$5 // 5
      .byte $6,$6,$6,$6,$6,$6,$6,$6 // 6
      .byte -1,-1,-1,-1,-1,-1,-1,-1 // 7
      .byte -1,-1,-1,-1,-1,-1,-1,-1 // 8
      .byte -1,-1,-1,-1,-1,-1,-1,-1 // 9
      .byte -1,-1,-1,-1,-1,-1,-1,-1 // A
      .byte $6,$6,$6,$6,$6,$6,$6,$b // B
      .byte $6,$6,$6,$6,$6,$b,$4,$c // C
      .byte -1,-1,-1,-1,-1,-1,-1,-1 // D
      .byte $6,$6,$6,$6,$6,$b,$4,$e // E
      .byte $6,$6,$6,$b,$4,$e,$5,$f // F

irq_fadein:
      StoreAXY( ret_fadein )
      lda #$3b
      sta $d011
      jsr FRAMEWORK_PERIODICAL
      lda #0
      cmp ZP_SIGNAL_SWAP
      beq !skip+
      sta ZP_SIGNAL_SWAP
      ldx #calculateDisplayValue( $4000, $6400 )
      lda ZP_LAYOUT_DEST+1
      cmp #$60
      beq !skip2+
      ldx #calculateDisplayValue( $4000, $6000 )
!skip2:
      stx SCREEN_CHARACTER_MEMORY_ADDRESS

      ldx ZP_FADEIN_INDEX
      lda fadein_tables+8*BACKGROUND,x
      sta $d021
      clc
      ldx #0
!loop:
.for ( var row = 0; row < 4; row++ )
{
      lda d800_cache+$100*row,x
      sta $d800+row*$100,x
}
      inx
      bne !loop-
      inc ZP_FADEIN_INDEX
      lda ZP_FADEIN_INDEX
      cmp #8
      bne !skip+
      lda #irq_top
      sta IRQ_JMP_LO
      lda #RASTERLINE_FIRST_ONSCREEN-8
      sta RASTERLINE_REGISTER
!skip:
ret_fadein:
      RestoreAXY_Return()

do_top:
      jsr START_INTERRUPT
.const ZP_YPOS = AllocateZP( "ZP_YPOS" )
      ldx ZP_YPOS
      
      lda #$ff
      sta SPRITES_VISIBLE_REGISTER

      lda plexertables+FRAMES_Y*0,x
      sta $d001
      sta $d009
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*0,x
      lda ZP_CACHE_X,y
      sta $d000
      sta $d008
      lda ZP_CACHE_X+SPRITES,y
      and #%00010001
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fc
      clc
      adc #1
      sta $63f8
      
      lda plexertables+FRAMES_Y*1,x
      sta $d003
      sta $d00b
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*1,x
      lda ZP_CACHE_X,y
      sta $d002
      sta $d00a
      lda ZP_CACHE_X+SPRITES,y
      and #%00100010
      ora ZP_D010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fd
      clc
      adc #1
      sta $63f9

      lda plexertables+FRAMES_Y*2,x
      sta $d005
      sta $d00d
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*2,x
      lda ZP_CACHE_X,y
      sta $d004
      sta $d00c
      lda ZP_CACHE_X+SPRITES,y
      and #%01000100
      ora ZP_D010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fe
      clc
      adc #1
      sta $63fa

      lda plexertables+FRAMES_Y*3,x
      sta $d007
      sta $d00f
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*3,x
      lda ZP_CACHE_X,y
      sta $d006
      sta $d00e
      lda ZP_CACHE_X+SPRITES,y
      and #%10001000
      ora ZP_D010
      sta $d010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63ff
      clc
      adc #1
      sta $63fb

      lda plexertables+FRAMES_Y*0,x
      clc
      adc #42
      cmp $d012
      bmi do_row4+5
      lda plexertables+FRAMES_Y*4,x
      sec
.const BUFFER_LINES = 3
      sbc #BUFFER_LINES
      sta $d012
      lda #irq_row4
      sta IRQ_JMP_LO
      jmp RETURN_FROM_INTERRUPT

do_row4:
      jsr START_INTERRUPT
      ldx ZP_YPOS
      lda plexertables+FRAMES_Y*4,x
      sta $d001
      sta $d009
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*4,x
      lda ZP_CACHE_X,y
      sta $d000
      sta $d008
      lda ZP_D010
      and #%11101110
      sta ZP_D010
      lda ZP_CACHE_X+SPRITES,y
      and #%00010001
      ora ZP_D010
      sta $d010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fc
      clc
      adc #1
      sta $63f8

      lda plexertables+FRAMES_Y*1,x
      clc
      adc #42
      cmp $d012
      bmi do_row5+5
      lda plexertables+FRAMES_Y*5,x
      sec
      sbc #BUFFER_LINES
      sta $d012
      lda #irq_row5
      sta IRQ_JMP_LO
      jmp RETURN_FROM_INTERRUPT

do_row5:
      jsr START_INTERRUPT
      ldx ZP_YPOS
      lda plexertables+FRAMES_Y*5,x
      sta $d003
      sta $d00b
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*5,x
      lda ZP_CACHE_X,y
      sta $d002
      sta $d00a
      lda ZP_D010
      and #%11011101
      sta ZP_D010
      lda ZP_CACHE_X+SPRITES,y
      and #%00100010
      ora ZP_D010
      sta $d010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fd
      clc
      adc #1
      sta $63f9

      lda plexertables+FRAMES_Y*2,x
      clc
      adc #42
      cmp $d012
      bmi do_row6+5
      lda plexertables+FRAMES_Y*6,x
      sec
      sbc #BUFFER_LINES
      sta $d012
      lda #irq_row6
      sta IRQ_JMP_LO
      jmp RETURN_FROM_INTERRUPT

do_row6:
      jsr START_INTERRUPT
      ldx ZP_YPOS
      lda plexertables+FRAMES_Y*2,x
      clc
      adc #42
      cmp $d012
      bpl *-3
      lda plexertables+FRAMES_Y*6,x
      sta $d005
      sta $d00d
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*6,x
      lda ZP_CACHE_X,y
      sta $d004
      sta $d00c
      lda ZP_D010
      and #%10111011
      sta ZP_D010
      lda ZP_CACHE_X+SPRITES,y
      and #%01000100
      ora ZP_D010
      sta $d010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fe
      clc
      adc #1
      sta $63fa

      lda plexertables+FRAMES_Y*3,x
      clc
      adc #42
      cmp $d012
      bmi do_row7+5
      lda plexertables+FRAMES_Y*7,x
      sec
      sbc #BUFFER_LINES
      sta $d012
      lda #irq_row7
      sta IRQ_JMP_LO
      jmp RETURN_FROM_INTERRUPT

do_row7:
      jsr START_INTERRUPT
      ldx ZP_YPOS
      lda plexertables+FRAMES_Y*7,x
      sta $d007
      sta $d00f
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*7,x
      lda ZP_CACHE_X,y
      sta $d006
      sta $d00e
      lda ZP_D010
      and #%01110111
      sta ZP_D010
      lda ZP_CACHE_X+SPRITES,y
      and #%10001000
      ora ZP_D010
      sta $d010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63ff
      clc
      adc #1
      sta $63fb
      lda plexertables+FRAMES_Y*4,x
      clc
      adc #42
      cmp $d012
      bmi do_row8+5
      lda plexertables+FRAMES_Y*8,x
      sec
      sbc #BUFFER_LINES
      sta $d012
      lda #irq_row8
      sta IRQ_JMP_LO
      jmp RETURN_FROM_INTERRUPT

do_row8:
      jsr START_INTERRUPT
      ldx ZP_YPOS
      lda plexertables+FRAMES_Y*8,x
      sta $d001
      sta $d009
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*8,x
      lda ZP_CACHE_X,y
      sta $d000
      sta $d008
      lda ZP_D010
      and #%11101110
      sta ZP_D010
      lda ZP_CACHE_X+SPRITES,y
      and #%00010001
      ora ZP_D010
      sta $d010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fc
      clc
      adc #1
      sta $63f8
      lda plexertables+FRAMES_Y*5,x
      clc
      adc #42
      cmp $d012
      bmi do_row9+5
      lda plexertables+FRAMES_Y*9,x
      sec
      sbc #BUFFER_LINES
      sta $d012
      lda #irq_row9
      sta IRQ_JMP_LO
      jmp RETURN_FROM_INTERRUPT

do_row9:
      jsr START_INTERRUPT
      ldx ZP_YPOS
      lda plexertables+FRAMES_Y*9,x
      sta $d003
      sta $d00b
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*9,x
      lda ZP_CACHE_X,y
      sta $d002
      sta $d00a
      lda ZP_D010
      and #%11011101
      sta ZP_D010
      lda ZP_CACHE_X+SPRITES,y
      and #%00100010
      ora ZP_D010
      sta $d010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fd
      clc
      adc #1
      sta $63f9
      lda plexertables+FRAMES_Y*6,x
      clc
      adc #42
      cmp $d012
      bmi do_row10+5
      lda plexertables+FRAMES_Y*10,x
      sec
      sbc #BUFFER_LINES
      sta $d012
      lda #irq_row10
      sta IRQ_JMP_LO
      jmp RETURN_FROM_INTERRUPT

do_row10:
      jsr START_INTERRUPT
      ldx ZP_YPOS
      lda plexertables+FRAMES_Y*10,x
      sta $d005
      sta $d00d
      ldy plexertables+SPRITES*FRAMES_Y+FRAMES_Y*10,x
      lda ZP_CACHE_X,y
      sta $d004
      sta $d00c
      lda ZP_D010
      and #%10111011
      sta ZP_D010
      lda ZP_CACHE_X+SPRITES,y
      and #%01000100
      ora ZP_D010
      sta $d010
      sta ZP_D010
      lda ZP_CACHE_S,y
      sta $63fe
      clc
      adc #1
      sta $63fa

      inx
      txa
      and #$0f
      sta ZP_YPOS
      bne !skip+
      dec ZP_XINDEX
      bpl !skip+
      lda #10
      sta ZP_XINDEX
!skip: 

      ldy ZP_XPOS
.const ZP_TEMP_CACHE_X = AllocateRangeZP( 4*SPRITES, "ZP_CACHE_X" )
.for ( var spr = 0; spr < SPRITES; spr++ )
{
      lda curve_x_lo+spr*FRAMES_X,y
      sta ZP_TEMP_CACHE_X+spr
      sta ZP_TEMP_CACHE_X+SPRITES+spr
      lda curve_x_hi+spr*FRAMES_X,y
      sta ZP_TEMP_CACHE_X+2*SPRITES+spr
      sta ZP_TEMP_CACHE_X+3*SPRITES+spr
}
      ldx ZP_XINDEX
.for( var spr = 0; spr < SPRITES; spr++ )
{
      lda ZP_TEMP_CACHE_X,x
      sta ZP_CACHE_X+spr
      lda ZP_TEMP_CACHE_X+2*SPRITES,x
      sta ZP_CACHE_X+SPRITES+spr
      lda ZP_SPRITE_CACHE,x
      sta ZP_CACHE_S+spr
      inx
}
      dey
      cpy #$ff
      beq !skip2+
      jmp !skip+
!skip2:

.for ( var spr = 0; spr < SPRITES-1; spr++ )
{
      lda ZP_SPRITE_CACHE+1+spr
      sta ZP_SPRITE_CACHE+0+spr
      sta ZP_SPRITE_CACHE+SPRITES+spr
}
!repeat:
      ldx ZP_TEXT_INDEX
      lda scrolltext,x
      cmp #$40
      bne !skip2+
      lda #TRANSPARENT_BACKGROUND
      sta $d027
      sta $d028
      sta $d029
      sta $d02a
      lda #$0f
      sta SPRITES_PRIORITY_REGISTER
      inc ZP_TEXT_INDEX
      jmp !repeat-
!skip2:
      cmp #$ff
      bne !skip4+
      NextInterrupt( FRAMEWORK_IRQ, RASTERLINE_FIRST_OFFSCREEN )
      lda #0
      sta $d011
      SetSignal( SIGNAL_PART_FINISHED )
      jmp RETURN_FROM_INTERRUPT_PERIODICAL
!skip4:
      inc ZP_TEXT_INDEX
      asl
      clc
      adc #SpriteIndex( spritefont )
      sta ZP_SPRITE_CACHE+SPRITES-1
      sta ZP_SPRITE_CACHE+2*SPRITES-1
!skip3:
      lda ZP_YPOS
      clc
      adc #FRAMES_Y
      and #$0f
      sta ZP_YPOS
      dec ZP_XINDEX
      lda ZP_XINDEX
      cmp #$ff
      bne !skip2+
      lda #10
      sta ZP_XINDEX
!skip2:
      ldy #FRAMES_X-1
!skip:
      sty ZP_XPOS

      lda #irq_top
      sta IRQ_JMP_LO
      lda #RASTERLINE_FIRST_ONSCREEN-8
      sta $d012
      jmp RETURN_FROM_INTERRUPT_PERIODICAL

scrolltext:
      .text "@@@@@@@@@@"
      .text "swimming@with@graceful@mammals@of@the@sea@"
      .text "@@@@@@@@@@"
      .byte $40
      .text "we@try@to@blend@in@with@higher@creatures@@@@"
      .text "but@they@see@through@our@lack@of@intelligence@@@@"
      .text "[[[[[[[[[[[["
      .text "@@@@@"
      .text "@@@@@@@@@@"
      .byte $ff

.align $100
sinus_x:
      .fill 512, (255.9*(1+sin(i*PI/128))/2);

.const TOTAL_FRAMES_X = SPRITES*FRAMES_X
.function SinusValue( i )
{
      .return i*(48+320-0.1)/TOTAL_FRAMES_X+SIN_DEGREE_X*sin(i*2*PI/TOTAL_FRAMES_X);
}

.function LoByte( i ) 
{
      .var v = SinusValue( i );
      .if ( v < 24 )
      {
            .return v+$f8-24;
      }
      .eval v = v - 24;
      .return v;
}

.function HiByte( i )
{
      .var v = SinusValue( i );
      .if ( v < 24 )
      {
            .return $ff
      }
      .eval v = v - 24;
      .if ( v >= 256 )
      {
            .return $ff
      }
      .return 0;
}

curve_x_lo:
      .fill SPRITES*FRAMES_X, LoByte( i )
curve_x_hi:
      .fill SPRITES*FRAMES_X, HiByte( i )

plexertables:
      .import binary "sprite-merge-scroll/plexertable.dat"

layout_offscreen:
      .fill $0800, 0
d800_cache:
      .fill $0400, $0
.pc = $4000 "koala data"
      .import binary "sprite-merge-scroll/background.dat"
.pc = $6000 "koala layout"
      .import binary "sprite-merge-scroll/background.lay"

.pc = $6800 "sprite font"
spritefont:
      .import binary "sprite-merge-scroll/font.spr"
