.import source "common.iasm"
.import source "vic.iasm"
.import source "macro.iasm"
.import source "background-data.iasm"
.import source "demo_constants.iasm"

.label layoutA = $c000
.label layoutB = $c400
.label spriteData = $c800
.label koala = $e000

.const INBUFFER_MODULO = 97
// image source size: 508x200

.const FONT_COLOR = LIGHT_BLUE
.const BACKGROUND_COLOR = BLUE
.const FONT_LINE = BLACK
.const SIGNAL_FULLSCREEN_READY = 1 << 4
.const SIGNAL_BORDER_READY = 1 << 5
.const FRAME_FINISHED_VSP = $07d0
.const FULLSCREEN_INDEX = $39

.pc = FIRST_SOURCE_LOCATION "main"
.if ( GENERATE_CODE_FOR_TEST )
{
	lda #(>FRAME_INTRO_START)
	jsr FORWARD_TO_FRAME

	lda #SCRX_DEFAULT_MODE
	sta SCREEN_CONTROL_REGISTER_X
	lda #SCRY_DEFAULT_MODE
	sta SCREEN_CONTROL_REGISTER_Y
	lda #calculateDisplayValue( $5000,$5000 )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS
	lda #VIC_BANK_4000
	sta VIC_BANK_SELECT_REGISTER
}
	InitSignal()
	FillMem( $5800, $ff, 63 )
	lda #SpriteIndex( $5800 )
	ldx #7
!loop:
	sta $53f8,x
	dex
	bpl !loop-
	lda #$0e
	ldx #7
!loop:
	sta $d027,x
	dex
	bpl !loop-

	FillMem( $d800, $66, 1024 )
	CopyMem( layoutB, $d800+40, 40*21 )
	CopyMem( layoutA, layoutB, 40*25 )
	lax #0
!loop:
	sta $fef8,x
	inx
	bne !loop-

	lda #$ff
	sta SPRITES_VISIBLE_REGISTER

.const ZP_COLUMN_INDEX = AllocateZP( "ZP_COLUMN_INDEX" )
.const ZP_CURRENT_SPRITE = AllocateZP( "ZP_CURRENT_SPRITE" )
.const ZP_JMP_TABLE_INDEX = AllocateZP( "ZP_JMP_TABLE_INDEX" )
	lda #0
	sta ZP_COLUMN_INDEX
	sta ZP_CURRENT_SPRITE
	sta ZP_JMP_TABLE_INDEX

.const ZP_FRAME_COUNT = AllocateWordZP( "ZP_FRAME_COUNT" )
	lda #0
	sta ZP_FRAME_COUNT+0
	sta ZP_FRAME_COUNT+1
.const ZP_CACHE_D010 = AllocateZP( "ZP_CACHE_D010" )
.const ZP_D010 = AllocateZP( "ZP_D010" )
.const ZP_CRUNCH_COUNT = AllocateZP( "ZP_CRUNCH_COUNT" )
.const ZP_VSP_INDEX = AllocateZP( "ZP_VSP_INDEX" )
.const ZP_VSP_CACHE = AllocateZP( "ZP_VSP_CACHE" )
.const ZP_VSP_INHIBIT = AllocateZP(" ZP_VSP_INHIBIT" )
.const ZP_SOFTSCROLL_VALUE = AllocateZP( "ZP_SOFTSCROLL_VALUE" )
.const ZP_SPRITE_SOFTSCROLL = AllocateZP( "ZP_SPRITE_SOFTSCROLL" )
.const ZP_VSP_SPEED_INDEX = AllocateZP( "ZP_VSP_SPEED_INDEX" )
.const ZP_FULLSCREEN_INDEX = AllocateZP( "ZP_FULLSCREEN_INDEX" )
.const ZP_SPRITE_ADD = AllocateZP( "ZP_SPRITE_ADD" )
.const ZP_POSX_BORDER_INDEX = AllocateZP( "ZP_POSX_BORDER_INDEX" )
	lda #0
	sta ZP_CRUNCH_COUNT
	sta ZP_VSP_INDEX
	sta ZP_VSP_CACHE
	sta ZP_SPRITE_SOFTSCROLL
	sta ZP_VSP_SPEED_INDEX
	sta ZP_FULLSCREEN_INDEX
	sta ZP_SPRITE_ADD
	sta ZP_POSX_BORDER_INDEX
	lda #1
	sta ZP_VSP_INHIBIT

	lda #0
	sta ZP_SOFTSCROLL_VALUE

.const ZP_BITMAP_STORE = AllocateWordZP( "ZP_BITMAP_STORE" )
.const ZP_STORE_CACHE = AllocateWordZP( "ZP_STORE_CACHE" )
.const ZP_BITMAP_FETCH = AllocateWordZP( "ZP_BITMAP_FETCH" )
	:LoadImm( ZP_BITMAP_STORE, koala )
	:LoadImm( ZP_BITMAP_FETCH, indata_bitmap )

.const ZP_BORDER_POS = AllocateWordZP( "ZP_BORDER_POS" )
	lda #0
	sta ZP_BORDER_POS
	sta ZP_BORDER_POS+1

	SetNewIRQFromMain( irq_fix_border, 0 )
	WaitForSignal( SIGNAL_BORDER_READY )
	lda #$ff
	sta SPRITES_MULTICOLOR_ENABLED
	lda #FONT_LINE
	sta $d025
	lda #BACKGROUND_COLOR
	sta $d026
	lda #FONT_COLOR
	ldx #7
!l:
	sta $d027,x
	dex
	bpl !l-
	WaitForFrame( FRAME_INTRO_START )
	SetNewIRQFromMain( irq_main, RASTERLINE_FIRST_OFFSCREEN )

mainloop:
	lda ZP_VSP_CACHE
	cmp ZP_VSP_INDEX
	beq *-2
	// update bitmap
	lda ZP_BITMAP_STORE
	sta ZP_STORE_CACHE
	clc
	adc #8
	sta ZP_BITMAP_STORE
	lda ZP_BITMAP_STORE+1
	sta ZP_STORE_CACHE+1
	adc #0
	sta ZP_BITMAP_STORE+1
	// clearing top line will remove crunch bugs (instead of $d011 tricks)
	ldy #7
	lda #0
!l1:
	sta (ZP_STORE_CACHE),y
	dey
	bpl !l1-

	AddWordConst( ZP_STORE_CACHE, $140 )
	// draw upper border for logo
	ldy #0
	lda #0
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	lda #%10101010
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	lda #%01010101
	sta (ZP_STORE_CACHE),y

	AddWordConst( ZP_STORE_CACHE, $140 )

	ldx #20
!l2:
	ldy #7
!l1:
	lda (ZP_BITMAP_FETCH),y
	sta (ZP_STORE_CACHE),y
	dey
	bpl !l1-
	AddWordConst( ZP_STORE_CACHE, $140 )
	AddWordConst( ZP_BITMAP_FETCH, 8 )
	dex
	bpl !l2-

	// draw lower border for logo
	ldy #0
	lda #%01010101
	sta (ZP_STORE_CACHE),y
	iny
	lda #%10101010
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	lda #0
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	iny
	sta (ZP_STORE_CACHE),y
	// Copy colors/layout
	ldx ZP_VSP_CACHE
	lda #FONT_COLOR | ( FONT_LINE<<4 )
	sta layoutA+40,x
	sta layoutA+23*40,x
	lda #$66
	sta $d800+40,x
	sta $d800+23*40,x

.for ( var row = 0; row < 21; row++ )
{
	lda indata_layout+INBUFFER_MODULO*row,x
.if ( row < 2 )
	sta layoutA+80+row*40,x
.if ( row >= 2 && row < 5 )
	sta layoutB+80+row*40,x
.if ( row >= 5 && row < 8 )
	sta layoutA+80+row*40,x
.if ( row >= 8 && row < 10 )
	sta layoutB+80+row*40,x
.if ( row >= 10 && row < 13 )
	sta layoutA+80+row*40,x
.if ( row >= 13 && row < 16 )
	sta layoutB+80+row*40,x
.if ( row >= 16 && row < 18 )
	sta layoutA+80+row*40,x
.if ( row >= 18 )
	sta layoutB+80+row*40,x

	lda indata_colors+INBUFFER_MODULO*row,x
	sta $d800+80+row*40,x
}
	inc ZP_VSP_CACHE
	lda ZP_VSP_CACHE
	cmp #$61
	beq !skip+
	jmp mainloop
!skip:
prepare_fullscreen:
	//create_fadeout_bordersprites
	ldx #17*3-1
!loop:
	lda #$ff
	sta $6400,x
	sta $6440+12,x
	lda #$aa
	sta $6480,x
	sta $6cc0+12,x
	dex
	bpl !loop-
	ldx #8
	lda #$aa
!loop:
	sta $6400+17*3,x
	sta $6480+17*3,x
	sta $6440+3,x
	sta $64c0+3,x
	dex
	bpl !loop-

	ldx #2
	lda #$55
!loop:
	sta $6400+60,x
	sta $6480+60,x
	sta $6440,x
	sta $64c0,x
	dex
	bpl !loop-

	ldx #62
	lda #$aa
!loop:
	sta $6500,x
	dex
	bpl !loop-

	// top/bottom
	ldx #$a0
!loop:
	lda koala_fadeout+ 2*320+0*$a0-1,x
	sta koala_fadeout+23*320+0*$a0-1,x
	lda koala_fadeout+ 2*320+1*$a0-1,x
	sta koala_fadeout+23*320+1*$a0-1,x
	lda koala_fadeout+ 2*320+2*$a0-1,x
	sta koala_fadeout+23*320+2*$a0-1,x
	lda koala_fadeout+ 2*320+3*$a0-1,x
	sta koala_fadeout+23*320+3*$a0-1,x
	dex
	bne !loop-

	ldx #79
!loop:
	lda layout_fadeout_cache,x
	sta layout_fadeout,x
	lda layout_fadeout_cache+80,x
	sta layout_fadeout+40*23,x
	dex
	bpl !loop-
	// remainder bitmap
	LoadImm( ZP_BITMAP_FETCH, indata_bitmap+168*FULLSCREEN_INDEX )
	LoadImm( ZP_BITMAP_STORE, koala_fadeout+2*320 )
	lda #40
.const ZP_COLUMN_COUNT = AllocateZP( "ZP_COLUMN_COUNT" )
	sta ZP_COLUMN_COUNT
!loopC:
	ldx #20
!loopX:
	ldy #7
!loopY:
	lda (ZP_BITMAP_FETCH),y
	sta (ZP_BITMAP_STORE),y
	dey
	bpl !loopY-
	AddWordConst( ZP_BITMAP_FETCH, 8 )
	AddWordConst( ZP_BITMAP_STORE, 320 )
	dex
	bpl !loopX-
	SubWordConst( ZP_BITMAP_STORE, 320*21-8 )
	dec ZP_COLUMN_COUNT
	bne !loopC-

	ldx #39
!loop:
.for ( var row = 0; row < 21; row++ )
{
	lda indata_layout+INBUFFER_MODULO*row+FULLSCREEN_INDEX,x
	sta $6000+80+40*row,x
}
	dex
	bmi !finished+
	jmp !loop-
!finished:

	WaitForSignal( SIGNAL_FULLSCREEN_READY )

	CopyMem( $4000, $e000, 8000 )
	CopyMem( $6000, $cc00, 1000 )
	
	WaitForVerticalBlank()
	lda #VIC_BANK_C000
	sta VIC_BANK_SELECT_REGISTER
	lda #calculateDisplayValue( $e000, $cc00 )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS
	
	jmp LOAD_AND_RUN


.const SPRITEPOS_TOP = SPRITE_POSY_TOP+12
.const RASTERLINE_SPLIT1 = SPRITEPOS_TOP+0*21+15
.const RASTERLINE_SPLIT2 = SPRITEPOS_TOP+1*21+18
.const RASTERLINE_SPLIT3 = SPRITEPOS_TOP+2*21+17
.const RASTERLINE_SPLIT4 = SPRITEPOS_TOP+3*21+18
.const RASTERLINE_SPLIT5 = SPRITEPOS_TOP+4*21+18
.const RASTERLINE_SPLIT6 = SPRITEPOS_TOP+5*21+17
.const RASTERLINE_SPLIT7 = SPRITEPOS_TOP+6*21+18
.const RASTERLINE_SPLIT8 = SPRITEPOS_TOP+7*21+18
.const RASTERLINE_SPLIT9 = SPRITEPOS_TOP+8*21+18

.align $40
irq_vsp:
	jmp jmp_vsp
irq_vsp_stable:
	jmp jmp_vsp_stable
irq_split1:
	jmp jmp_split1
irq_split1_stable:
	jmp jmp_split1_stable
irq_split2:
	jmp jmp_split2
irq_split3:
	jmp jmp_split3
irq_split4:
	jmp jmp_split4
irq_split5:
	jmp jmp_split5
irq_split6:
	jmp jmp_split6
irq_split7:
	jmp jmp_split7
irq_split8:
	jmp jmp_split8
irq_enter_fullscreen:
	jmp jmp_enter_fullscreen
irq_fullscreen_split:
	jmp jmp_fullscreen_split
irq_fullscreen_border:
	jmp jmp_fullscreen_border
irq_fullscreen_border_addsprites:
	jmp jmp_fullscreen_border_addsprites
irq_fix_border:
	jmp jmp_fix_border

irq_main:
	StoreAXY( ret_main )

	lda #VIC_BANK_C000
	sta VIC_BANK_SELECT_REGISTER
	lda #SCRX_MULTICOLOR_MODE
	sta SCREEN_CONTROL_REGISTER_X
	lda #calculateDisplayValue( koala, layoutA )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS

	lda #$17
	sta SCREEN_CONTROL_REGISTER_Y

	// sprite scroller
	ldx ZP_SPRITE_SOFTSCROLL
	dex
	txa
	and #1
	sta ZP_SPRITE_SOFTSCROLL
	cmp #1
	bne !skip1+
	ldx #7
!loop:
	lda sprite_pos_cache,x
	beq !skip+
	sec
	sbc #1
	sta sprite_pos_cache,x
!skip:
	dex
	bpl !loop-
!skip1:

	// Check framecount and copy new sprite into cache
	ldy ZP_COLUMN_INDEX
	lda ZP_FRAME_COUNT+1
	cmp sprite_enter_table_frame_hi,y
	bcc !skip+
	bne !above+
	lda ZP_FRAME_COUNT+0
	cmp sprite_enter_table_frame_lo,y
	bcc !skip+
!above:
	jsr copySpriteColumn
!skip:

	lda #SPRITEPOS_TOP
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

	set_a( SPRITES_POSX_MSB, 0 )
.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+spr
	sta layoutA+$03f8+spr
	ldx sprite_pos_cache+spr
	lda spritepos_lookup_table_lo,x
	clc
	adc ZP_SPRITE_SOFTSCROLL
	sta SPRITE0_POSX+2*spr
	lda spritepos_lookup_table_hi,x
	and #1<<spr
	ora SPRITES_POSX_MSB
	sta SPRITES_POSX_MSB
}
	lda #calculateDisplayValue( koala, layoutA )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS
	lda #0
	sta SPRITES_STRETCHX_ENABLED
	jsr update_split0
	lda #irq_vsp
	sta IRQ_JMP_LO
.const RASTERLINE_VSP = RASTERLINE_FIRST_ONSCREEN-6
	lda #RASTERLINE_VSP 
	sta RASTERLINE_REGISTER
	inc ZP_FRAME_COUNT+0
	bne !skip+
	inc ZP_FRAME_COUNT+1
!skip:
	lda ZP_FRAME_COUNT+1
	cmp #$01
	bne !skip+
	lda ZP_FRAME_COUNT+0
	cmp #$04
	bne !skip+
	lda #0
	sta ZP_VSP_INHIBIT
!skip:
	jsr FRAMEWORK_PERIODICAL

	// koala scroller
	lda ZP_VSP_INHIBIT
	beq !skip1+
	lsr
	ora #SCRX_MULTICOLOR_MODE
	sta SCREEN_CONTROL_REGISTER_X
	jmp !skip2+
!skip1:
	ldx ZP_VSP_SPEED_INDEX
	cpx #$10
	beq !skip5+
	cpx #$20+12
	beq !skip5+
	inx
	stx ZP_VSP_SPEED_INDEX
!skip5:
	lda ZP_SOFTSCROLL_VALUE
	sec
	sbc vsp_speed_table,x
	ldy #0
	cmp #$ff
	bne !skip6+
	ldy #1
	and #$0f
!skip6:
	sta ZP_SOFTSCROLL_VALUE
	lsr
	ora #SCRX_MULTICOLOR_MODE
	sta SCREEN_CONTROL_REGISTER_X
	cpy #$00
	beq !skip2+
	ldx ZP_VSP_INDEX
	inx
	stx ZP_VSP_INDEX
	cpx #$61
	bne !skip4+
	inc ZP_VSP_SPEED_INDEX
!skip4:
	lda vsp_mark
	clc
	adc #1
	cmp #40
	bne !skip1+

	lda ZP_CRUNCH_COUNT
	clc
	adc #1
	cmp #3
	sta ZP_CRUNCH_COUNT
	bne !skip3+
	.byte $02
!skip3:

	lda #0
!skip1:
	sta vsp_mark
!skip2:

ret_main:
	RestoreAXY_Return()

vsp_speed_table:
	.byte 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1
	.byte 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
	.byte 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0
	.byte 0

jmp_vsp:
	StoreAXY( ret_vsp )
	lda #irq_vsp_stable
	sta IRQ_JMP_LO
	lda #RASTERLINE_VSP+1
	sta RASTERLINE_REGISTER
	tsx
	asl $d019
	cli
	jmp NOP_FOREVER
.align $40
jmp_vsp_stable:
	txs
	set_a( IRQ_JMP_LO, irq_split1 )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT1 )
	lda #$30
	sta $d011
	DelayFor(23)
	StableRaster(false)
	jsr do_crunch
	jsr do_vsp
ret_vsp:
	RestoreAXY_Return()

.align $100
do_crunch:
// Line crunch
	ldy ZP_CRUNCH_COUNT
	beq !ret+
	DelayFor(53)
	lda #$31
	sta $d011
	dey
	beq !ret+
	DelayFor(53)
	lda #$32
	sta $d011
	dey
	beq !ret+
	DelayFor(53)
	lda #$34
	sta $d011
	dey
	beq !ret+
	inc $d021; jmp *-3
!ret:
ErrorIfNotSameBank(do_crunch,*)
	rts

do_vsp:
	ldy ZP_CRUNCH_COUNT
	lda fld_d011_table,y
	sta $d011
	iny
	cpy #$07
	beq !ret+
	DelayFor(49)
	lda fld_d011_table,y
	sta $d011
	iny
	cpy #$07
	beq !ret+
	DelayFor(49)
	lda fld_d011_table,y
	sta $d011
	iny
	cpy #$07
	beq !ret+
	DelayFor(49)
	lda fld_d011_table,y
	sta $d011
	iny
	cpy #$07
	beq !ret+
	DelayFor(49)
	lda fld_d011_table,y
	sta $d011
	iny
	cpy #$07
	beq !ret+
	DelayFor(49)
	lda fld_d011_table,y
	sta $d011
	iny
	cpy #$07
	beq !ret+
	DelayFor(49)
	lda fld_d011_table,y
	sta $d011
	iny
	cpy #$07
	beq !ret+
	DelayFor(49)
!ret:
ErrorIfNotSameBank(do_vsp,*)
	DelayFor(18)
	clv
	bvc *+2
.label vsp_mark = *-1
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	nop #$80
	bit $ea
ErrorIfNotSameBank(vsp_mark,*)
	lda #$36
	sta $d011
	lda #$37
	sta $d011
	lda #$33
	sta $d011
	rts

fld_d011_table:
.const FLD_DEBUG = 0
	.byte $31|FLD_DEBUG,$32|FLD_DEBUG,$33|FLD_DEBUG,$34|FLD_DEBUG
	.byte $35|FLD_DEBUG,$36|FLD_DEBUG,$30|FLD_DEBUG,$30|FLD_DEBUG
ErrorIfNotSameBank(*,fld_d011_table)

jmp_split1:
	StoreAXY( ret_split1 )
	set_a( IRQ_JMP_LO, irq_split1_stable )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT1+2 )
	asl $d019
	tsx
	cli
	jmp NOP_FOREVER

jmp_split1_stable:
	txs
	DelayFor(23)
	StableRaster( false )
	lda #SPRITEPOS_TOP+1*21
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+8*1+spr
	sta layoutB+$03f8+spr
}
	set_a( IRQ_JMP_LO, irq_split2 )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT2 )
	DelayFor(16)
	lda #calculateDisplayValue( koala, layoutB )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS

	jsr update_split1

ret_split1:
	RestoreAXY_Return()

jmp_split2:
	StoreAXY( ret_split2 )
	lda #SPRITEPOS_TOP+2*21
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+8*2+spr
	sta layoutA+$03f8+spr
}
	set_a( IRQ_JMP_LO, irq_split3 )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT3 )
	lda #calculateDisplayValue( koala, layoutA )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS

ret_split2:
	RestoreAXY_Return()

jmp_split3:
	StoreAXY( ret_split3 )
	lda #SPRITEPOS_TOP+3*21
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+8*3+spr
	sta layoutB+$03f8+spr
}
	set_a( IRQ_JMP_LO, irq_split4 )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT4 )
	lda #calculateDisplayValue( koala, layoutB )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS

ret_split3:
	RestoreAXY_Return()

jmp_split4:
	StoreAXY( ret_split4 )
	lda #SPRITEPOS_TOP+4*21
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+8*4+spr
	sta layoutA+$03f8+spr
}
	set_a( IRQ_JMP_LO, irq_split5 )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT5 )
	lda #calculateDisplayValue( koala, layoutA )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS

	jsr update_split2

ret_split4:
	RestoreAXY_Return()

jmp_split5:
	StoreAXY( ret_split5 )
	lda #SPRITEPOS_TOP+5*21
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+8*5+spr
	sta layoutB+$03f8+spr
}
	set_a( IRQ_JMP_LO, irq_split6 )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT6 )
	lda #calculateDisplayValue( koala, layoutB )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS

ret_split5:
	RestoreAXY_Return()

jmp_split6:
	StoreAXY( ret_split6 )
	lda #SPRITEPOS_TOP+6*21
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+8*6+spr
	sta layoutA+$03f8+spr
}
	set_a( IRQ_JMP_LO, irq_split7 )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT7 )
	lda #calculateDisplayValue( koala, layoutA )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS

ret_split6:
	RestoreAXY_Return()

jmp_split7:
	StoreAXY( ret_split7 )
	lda #SPRITEPOS_TOP+7*21
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+8*7+spr
	sta layoutB+$03f8+spr
}
	set_a( IRQ_JMP_LO, irq_split8 )
	set_a( RASTERLINE_REGISTER, RASTERLINE_SPLIT8 )
	lda #calculateDisplayValue( koala, layoutB )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS
	DelayFor(40)
	jsr update_split3

ret_split7:
	RestoreAXY_Return()

jmp_split8:
	StoreAXY( ret_split8 )
	lda #SPRITEPOS_TOP+8*21
.for ( var spr = 0; spr < 8; spr++ ) sta $d001+2*spr

.for ( var spr = 0; spr < 8; spr++ )
{
	lda sprite_window_cache+8*8+spr
	sta layoutA+$03f8+spr
}
	lda #calculateDisplayValue( koala, layoutA )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS
	set_a( RASTERLINE_REGISTER, RASTERLINE_FIRST_OFFSCREEN-2 )

	CmpWordConst( ZP_FRAME_COUNT, $07d0 )
	bne !skip+
	set_a( IRQ_JMP_LO, irq_enter_fullscreen )
	jmp ret_split8
!skip:
	set_a( IRQ_JMP_LO, irq_main )

ret_split8:
	RestoreAXY_Return()

copySpriteColumn:
	ldy ZP_CURRENT_SPRITE
	ldx ZP_COLUMN_INDEX
	cpx #37
	bne !skip+
.for ( var row = 0; row < 10; row++ )
{
	lda #SpriteIndex( spriteData )
	sta sprite_window_cache+8*row,y
}
	rts
!skip:
.for ( var row = 0; row < 10; row++ )
{
	lda sprite_layout+37*row,x
	clc
	adc #SpriteIndex( spriteData )
	sta sprite_window_cache+8*row,y
}
	lda sprite_enter_table_pos,x
	sta sprite_pos_cache,y

	lda ZP_JMP_TABLE_INDEX
	clc
	adc #2
	sta ZP_JMP_TABLE_INDEX
	
	lda #split0_jmptable
	clc
	adc ZP_JMP_TABLE_INDEX
	sta split0_jumpptr

	lda #split1_jmptable
	clc
	adc ZP_JMP_TABLE_INDEX
	sta split1_jumpptr

	lda #split2_jmptable
	clc
	adc ZP_JMP_TABLE_INDEX
	sta split2_jumpptr

	lda #split3_jmptable
	clc
	adc ZP_JMP_TABLE_INDEX
	sta split3_jumpptr

	lda ZP_CURRENT_SPRITE
	clc
	adc #1
	and #7
	sta ZP_CURRENT_SPRITE
	inc ZP_COLUMN_INDEX
	rts

//         Bl Bl S  S  S  S  U  U  U  U  B  B  B  M  M  M  M  E  E  E  E  R  R  R  G  G  G  G  E  E  E  E  D  D  D  Bl Bl
//         00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36
// Split0: W  W        00       10          20                      W     30             50          W        60    W  W
// Split1:             01                   21                            31          41 51                   61
// Split2:          W  02                                                                52
// Split3:          NW 03       13          23                                        43                      63
// 00:+24, 01:W+12, 02:NW+0, 03:+24
// 10:+24, 13:+0
// 20:+24, 21:+0, 23:+24
// 30:+24, 31:+0
// 41:+24, 43:+0
// 50:+12, 51:W+0, 52:NW+12
// 60:+24, 61:+0, 63:+24
.align $100
.pc = * "jmp tables"
split0_jmptable:
	.word split0_init0
	.word split0_init1
	.word split0_init2
	.word split0_init3
	.word split0_init4
	.word split0_init5
	.word split0_init6
	.word split0_init7
	.word split0_entry00
	.word split0_entry01
	.word split0_entry02
	.word split0_entry03
	.word split0_entry04
	.word split0_entry05
	.word split0_entry06
	.word split0_entry07
	.word split0_entry08
	.word split0_entry09
	.word split0_entry10
	.word split0_entry11
	.word split0_entry12
	.word split0_entry13
	.word split0_entry14
	.word split0_entry15
	.word split0_entry16
	.word split0_entry17
	.word split0_entry18
	.word split0_entry19
	.word split0_entry20
	.word split0_entry21
	.word split0_entry22
	.word split0_entry23
	.word split0_entry24
	.word split0_entry25
	.word split0_entry26
	.word split0_entry27
	.word split0_entry28
	.word split0_entry29
	.word split0_entry30
	.word split0_entry31
	.word split0_entry32
	.word split0_entry33
	.word split0_entry34
	.word split0_entry35
	.word split0_entry36
ErrorIfNotSameBank( *, split0_jmptable )

split1_jmptable:
	.word split1_init0
	.word split1_init1
	.word split1_init2
	.word split1_init3
	.word split1_init4
	.word split1_init5
	.word split1_init6
	.word split1_init7
	.word split1_entry00
	.word split1_entry01
	.word split1_entry02
	.word split1_entry03
	.word split1_entry04
	.word split1_entry05
	.word split1_entry06
	.word split1_entry07
	.word split1_entry08
	.word split1_entry09
	.word split1_entry10
	.word split1_entry11
	.word split1_entry12
	.word split1_entry13
	.word split1_entry14
	.word split1_entry15
	.word split1_entry16
	.word split1_entry17
	.word split1_entry18
	.word split1_entry19
	.word split1_entry20
	.word split1_entry21
	.word split1_entry22
	.word split1_entry23
	.word split1_entry24
	.word split1_entry25
	.word split1_entry26
	.word split1_entry27
	.word split1_entry28
	.word split1_entry29
	.word split1_entry30
	.word split1_entry31
	.word split1_entry32
	.word split1_entry33
	.word split1_entry34
	.word split1_entry35
	.word split1_entry36
ErrorIfNotSameBank( *, split1_jmptable )

.align $100
split2_jmptable:
	.word split2_init0
	.word split2_init1
	.word split2_init2
	.word split2_init3
	.word split2_init4
	.word split2_init5
	.word split2_init6
	.word split2_init7
	.word split2_entry00
	.word split2_entry01
	.word split2_entry02
	.word split2_entry03
	.word split2_entry04
	.word split2_entry05
	.word split2_entry06
	.word split2_entry07
	.word split2_entry08
	.word split2_entry09
	.word split2_entry10
	.word split2_entry11
	.word split2_entry12
	.word split2_entry13
	.word split2_entry14
	.word split2_entry15
	.word split2_entry16
	.word split2_entry17
	.word split2_entry18
	.word split2_entry19
	.word split2_entry20
	.word split2_entry21
	.word split2_entry22
	.word split2_entry23
	.word split2_entry24
	.word split2_entry25
	.word split2_entry26
	.word split2_entry27
	.word split2_entry28
	.word split2_entry29
	.word split2_entry30
	.word split2_entry31
	.word split2_entry32
	.word split2_entry33
	.word split2_entry34
	.word split2_entry35
	.word split2_entry36
ErrorIfNotSameBank( *, split2_jmptable )

split3_jmptable:
	.word split3_init0
	.word split3_init1
	.word split3_init2
	.word split3_init3
	.word split3_init4
	.word split3_init5
	.word split3_init6
	.word split3_init7
	.word split3_entry00
	.word split3_entry01
	.word split3_entry02
	.word split3_entry03
	.word split3_entry04
	.word split3_entry05
	.word split3_entry06
	.word split3_entry07
	.word split3_entry08
	.word split3_entry09
	.word split3_entry10
	.word split3_entry11
	.word split3_entry12
	.word split3_entry13
	.word split3_entry14
	.word split3_entry15
	.word split3_entry16
	.word split3_entry17
	.word split3_entry18
	.word split3_entry19
	.word split3_entry20
	.word split3_entry21
	.word split3_entry22
	.word split3_entry23
	.word split3_entry24
	.word split3_entry25
	.word split3_entry26
	.word split3_entry27
	.word split3_entry28
	.word split3_entry29
	.word split3_entry30
	.word split3_entry31
	.word split3_entry32
	.word split3_entry33
	.word split3_entry34
	.word split3_entry35
	.word split3_entry36
ErrorIfNotSameBank( *, split3_jmptable )

.macro adjustX( spriteNo, amount )
{
 .if ( amount != 0 )
 {
	lda sprite_pos_cache+spriteNo
	clc
	adc #amount
	tay
 }
 else
 {
 	ldy sprite_pos_cache+spriteNo
 }
	lda spritepos_lookup_table_lo,y
	clc
	adc ZP_SPRITE_SOFTSCROLL
	sta $d000+2*spriteNo
	lda spritepos_lookup_table_hi,y
	and #1<<spriteNo
	sta ZP_CACHE_D010
	lda $d010
	and #$ff-(1<<spriteNo)
	ora ZP_CACHE_D010
	sta $d010
}

.pc = * "update code"
.var CURR_SPR = 0
.eval CURR_SPR = 0
update_split0:
	ldx #8
.label split0_jumpptr = *+1
	jmp (split0_jmptable)
split0_init0:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<0 )
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_init1:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<1 )
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_init2:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<2 )
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_init3:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<3 )
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_init4:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<4 )
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_init5:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<5 )
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_init6:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<6 )
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_init7:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<7 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry00:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<0 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry01:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<1 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry02:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry03:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry04:
	adjustX( CURR_SPR, 24 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry05:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry06:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry07:
	adjustX( CURR_SPR,24)
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry08:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry09:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry10:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry11:
	adjustX( CURR_SPR,24)
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry12:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry13:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry14:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry15:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry16:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry17:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry18:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry19:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry20:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry21:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry22:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry23:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry24:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry25:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry26:
	adjustX( CURR_SPR,12 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry27:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry28:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry29:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry30:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry31:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry32:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry33:
	adjustX( CURR_SPR, 24 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry34:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry35:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split0_entry36:
	rts

.eval CURR_SPR = 0
update_split1:
	ldx #8
.label split1_jumpptr = *+1
	jmp (split1_jmptable)
split1_init0:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_init1:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_init2:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_init3:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_init4:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_init5:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_init6:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_init7:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry00:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry01:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry02:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry03:
	adjustX( CURR_SPR, 24 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry04:
	adjustX( CURR_SPR, 12 )
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry05:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry06:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry07:
	adjustX( CURR_SPR, 24 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry08:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry09:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry10:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry11:
	adjustX( CURR_SPR, 0 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry12:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry13:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry14:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry15:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry16:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry17:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry18:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry19:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry20:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry21:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry22:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry23:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry24:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry25:
	adjustX( CURR_SPR, 24 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry26:
	adjustX( CURR_SPR, 0 )
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry27:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry28:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry29:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry30:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry31:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry32:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry33:
	adjustX( CURR_SPR, 0 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry34:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry35:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split1_entry36:
	rts

.eval CURR_SPR = 0
update_split2:
	ldx #8
.label split2_jumpptr = *+1
	jmp (split2_jmptable)
split2_init0:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_init1:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_init2:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_init3:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_init4:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_init5:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_init6:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_init7:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry00:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry01:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry02:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry03:
	adjustX( CURR_SPR, 0 )
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry04:
	adjustX( CURR_SPR, 0 )
	and_i( SPRITES_STRETCHX_ENABLED, $ff-(1<<CURR_SPR) )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry05:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry06:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry07:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry08:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry09:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry10:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry11:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry12:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry13:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry14:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry15:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry16:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry17:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry18:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry19:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry20:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry21:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry22:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry23:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry24:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry25:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry26:
	adjustX( CURR_SPR, 12 )
	and_i( SPRITES_STRETCHX_ENABLED, $ff-(1<<CURR_SPR) )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry27:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry28:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry29:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry30:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry31:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry32:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry33:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry34:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry35:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split2_entry36:
	rts

.eval CURR_SPR = 0
update_split3:
	ldx #8
.label split3_jumpptr = *+1
	jmp (split3_jmptable)
split3_init0:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_init1:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_init2:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_init3:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_init4:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_init5:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_init6:
	dex
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_init7:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry00:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry01:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry02:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry03:
	adjustX( CURR_SPR, 0 )
	and_i( SPRITES_STRETCHX_ENABLED, $ff-(1<<CURR_SPR) )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry04:
	adjustX( CURR_SPR, 24 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry05:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry06:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry07:
	adjustX( CURR_SPR, 0 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry08:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry09:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry10:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry11:
	adjustX( CURR_SPR, 24 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry12:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry13:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry14:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry15:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry16:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry17:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry18:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry19:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry20:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry21:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry22:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry23:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry24:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry25:
	adjustX( CURR_SPR, 0 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry26:
	lda sprite_pos_cache+CURR_SPR
	clc
	adc #12
	tay
	lda spritepos_lookup_table_lo,y
	clc
	adc ZP_SPRITE_SOFTSCROLL
	sta $d000+2*CURR_SPR
	lda spritepos_lookup_table_hi,y
	and #1<<CURR_SPR
	sta ZP_CACHE_D010
	lda $d010
	and #$ff-(1<<CURR_SPR)
	ora ZP_CACHE_D010
	sta $d010
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry27:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry28:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry29:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry30:
	ora_i( SPRITES_STRETCHX_ENABLED, 1<<CURR_SPR )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry31:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry32:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry33:
	adjustX( CURR_SPR, 24 )
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry34:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry35:
	dex
	bne *+3
	rts
.eval CURR_SPR = (CURR_SPR + 1)&7
split3_entry36:
	rts

.var FrameTable = List().add( 0, 24, // Blank
						      48, 60, 84, 120, // S
						      132, 144, 192, 204, // U
						      216, 252, 288, // B
                     		  300, 336, 348, 384,  // M
                     		  396, 432, 444, 468,  // E (444W)
                     		  480, 516, 552, // R
                              564, 576, 624-12, 636, // G
                              648, 684, 696, 720,  // E
                              732, 768, 804, // D
                              816, 840, // Bl
                              -1
                            );

.function ExtractFrame( _index, _lo )
{
	.var value = FrameTable.get( _index )*2
	.if ( _lo ) .return ( value & $ff )
	.return ( value >> 8 )
}
sprite_enter_table_frame_hi:
	.fill 38, ExtractFrame( i, false )
sprite_enter_table_frame_lo:
	.fill 38, ExtractFrame( i, true )

sprite_enter_table_pos:
	.fill 37, 200

sprite_window_cache:
	.fill 8, SpriteIndex( spriteData )
	.fill 8, SpriteIndex( spriteData )
	.fill 8, SpriteIndex( spriteData )
	.fill 8, SpriteIndex( spriteData )
	.fill 8, SpriteIndex( spriteData )
	.fill 8, SpriteIndex( spriteData )
	.fill 8, SpriteIndex( spriteData )
	.fill 8, SpriteIndex( spriteData )
	.fill 8, SpriteIndex( spriteData )

sprite_pos_cache:
	.fill 8, 10+24*i

sprite_layout:
	.import binary "logo-koalafill/spriteoverlay.spl"

.align $100
spritepos_lookup_table_lo:
	.fill 20, $e0
	.fill 12, $e0+2*i
	.fill 128, 2*i
	.fill 128-32, 2*i

spritepos_lookup_table_hi:
	.fill 32, $ff
	.fill 128, $0
	.fill 128-32, $ff

jmp_enter_fullscreen:
	StoreAXY( ret_enter_fullscreen )

	lda #$18
	sta $d000
	lda #$48
	sta $d002
	lda #$78
	sta $d004
	lda #$a8
	sta $d006
	lda #$d8
	sta $d008
	lda #$08
	sta $d00a
	lda #$38
	sta $d00c

	lda #SpriteIndex( $6400 )
	sta $63f8
	sta $63f9
	sta $63fa
	sta $63fb
	sta $63fc
	sta $63fd
	sta $63fe

	ldx ZP_FULLSCREEN_INDEX
	lda #$2d
	sec
	sbc spriteout_table,x
	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d
	lda #%01100000
	sta $d010
	lda #$7f
	sta SPRITES_VISIBLE_REGISTER
	sta SPRITES_STRETCHX_ENABLED

	lda #VIC_BANK_4000
	sta VIC_BANK_SELECT_REGISTER
	lda #calculateDisplayValue( $4000, $6000 )
	sta SCREEN_CHARACTER_MEMORY_ADDRESS

	lda #$33
	ldx ZP_SPRITE_ADD
	cpx #2
	bmi !skip+
	lda #$3b
!skip:
	sta $d011

	jsr FRAMEWORK_PERIODICAL
	set_a( IRQ_JMP_LO, irq_fullscreen_split )
	set_a( RASTERLINE_REGISTER, $c0 )

nop_update_colors:
	jsr update_colors

ret_enter_fullscreen:
	RestoreAXY_Return()

spriteout_table:
	.fill $20, $11*(1-cos(i*PI/$40))

jmp_fullscreen_split:
	StoreAXY( ret_fullscreen_split )

	lda #SpriteIndex( $6400 )+1
	sta $63f8
	sta $63f9
	sta $63fa
	sta $63fb
	sta $63fc
	sta $63fd
	sta $63fe

	ldx ZP_FULLSCREEN_INDEX
	lda #$ea
	clc
	adc spriteout_table,x
	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d

	set_a( RASTERLINE_REGISTER, RASTERLINE_FIRST_OFFSCREEN-2 )
	ldx ZP_FULLSCREEN_INDEX
	inx
	stx ZP_FULLSCREEN_INDEX
	cpx #$18
	bne !skip+
	lda #2
	sta ZP_SPRITE_ADD
	lda #$0e
	sta $d026
!skip:
	cpx #$20
	bne !skip+
	set_a( IRQ_JMP_LO, irq_fullscreen_border )
	jmp ret_fullscreen_split
!skip:
	set_a( IRQ_JMP_LO, irq_enter_fullscreen )

ret_fullscreen_split:
	RestoreAXY_Return()

update_colors:
	lda #$0c
	sta nop_update_colors
	ldx #39
!loop:
	lda colors_fadeout_cache,x
	sta $d800,x
	lda colors_fadeout_cache+40,x
	sta $d800+40,x
	dex
	bpl !loop-

	ldx #39
!loop:
.for ( var row = 0; row < 10; row++ )
{
	lda indata_colors+INBUFFER_MODULO*row+FULLSCREEN_INDEX,x
	sta $d800+80+40*row,x
}
	dex
	bpl !loop-

	ldx #39
!loop:
.for ( var row = 10; row < 21; row++ )
{
	lda indata_colors+INBUFFER_MODULO*row+FULLSCREEN_INDEX,x
	sta $d800+80+40*row,x
}
	dex
	bpl !loop-

	ldx #39
!loop:
	lda colors_fadeout_cache+80,x
	sta $d800+23*40,x
	lda colors_fadeout_cache+120,x
	sta $d800+24*40,x
	dex
	bpl !loop-
	rts

jmp_fullscreen_border_addsprites:
	StoreAXY( ret_fullscreen_border_addsprites )
	lda #SPRITE_POSY_TOP+168
	sta $d001
	sta $d003
	set_a( IRQ_JMP_LO, irq_fullscreen_border )
	set_a( RASTERLINE_REGISTER, RASTERLINE_FIRST_OFFSCREEN-2 )

ret_fullscreen_border_addsprites:
	RestoreAXY_Return()
/*
.function min( _value1, _value2 )
{
	.if ( _value2 < _value1 )
		.return _value2
	.return _value1
}
*/
posx_border_table:
	.fill $20, 9.9*(1-cos(i*PI/$40))
posy_border_table:
	.fill $20, 9.9*(sin(i*PI/$40))

jmp_fullscreen_border:
	StoreAXY( ret_fullscreen_border )
	lda #$00
	sta SPRITES_STRETCHX_ENABLED
	lda #$ff
	sta SPRITES_STRETCHY_ENABLED
	sta SPRITES_VISIBLE_REGISTER
	lda #SPRITE_POSY_TOP
	sta $d001
	sta $d003
	lda #SPRITE_POSY_TOP+42
	sta $d005
	sta $d007
	lda #SPRITE_POSY_TOP+84
	sta $d009
	sta $d00b
	lda #SPRITE_POSY_TOP+126
	sta $d00d
	sta $d00f

	ldx ZP_POSX_BORDER_INDEX
	lda #7
	sec
	sbc posx_border_table,x
	bpl !skip+
	lda #0
!skip:
	sta $d000
	sta $d004
	sta $d008
	sta $d00c
	lda #79
	clc
	adc posx_border_table,x
	sta $d002
	sta $d006
	sta $d00a
	sta $d00e
	lda #%10101010
	sta $d010

	lda #SpriteIndex($6500)
	sta $63f8
	sta $63f9
	sta $63fa
	sta $63fb
	sta $63fc
	sta $63fd
	sta $63fe
	sta $63ff

	DelayFor(60)
	lda #$18
	sta $d016

	set_a( IRQ_JMP_LO, irq_fullscreen_border_addsprites )
	set_a( RASTERLINE_REGISTER, RASTERLINE_FIRST_ONSCREEN+100 )

	ldx ZP_POSX_BORDER_INDEX
	inx
	stx ZP_POSX_BORDER_INDEX
	cpx #$20
	bne !skip+
	NextInterrupt( FRAMEWORK_IRQ, RASTERLINE_FIRST_OFFSCREEN )
	lda #0
	sta SPRITES_VISIBLE_REGISTER
	SetSignal( SIGNAL_FULLSCREEN_READY )
!skip:
	
	jsr FRAMEWORK_PERIODICAL

ret_fullscreen_border:
	RestoreAXY_Return()

jmp_fix_border:
	StoreAXY( ret_fix_border )
	ldx ZP_BORDER_POS+0
	cpx #$20
	bne !do_pos1+
	lda #SCRX_DEFAULT_MODE_MC & SCRX_SCREEN_COLS_MASK
	sta SCREEN_CONTROL_REGISTER_X
	ldx ZP_BORDER_POS+1
	cpx #$20
	bne !do_pos2+
	lda #SCRY_DEFAULT_MODE & SCRY_SCREEN_ROWS_MASK
	sta SCREEN_CONTROL_REGISTER_Y
	SetSignal( SIGNAL_BORDER_READY )
!do_pos2:
	jsr do_border_vertical
	inc ZP_BORDER_POS+1
	jmp !skip_pos1+
!do_pos1:
	jsr do_border_horizontal
	inc ZP_BORDER_POS+0
!skip_pos1:
	jsr FRAMEWORK_PERIODICAL
ret_fix_border:
	RestoreAXY_Return()

do_border_horizontal:
	lda #$00
	sta SPRITES_STRETCHX_ENABLED
	lda #$ff
	sta SPRITES_STRETCHY_ENABLED
	lda #SPRITE_POSY_TOP
	sta $d001
	sta $d003
	ldx ZP_BORDER_POS+0
	lda posy_border_table,x
	sec
	sbc #2
	bcs !skip+
	lda #0
!skip:
	sta $d000
	sta $d004
	sta $d008
	sta $d00c
	lda #320+24+1
	sec
	sbc posy_border_table,x
	sta $d002
	sta $d006
	sta $d00a
	sta $d00e
	lda #%10101010
	sta $d010


	lda #SPRITE_POSY_TOP+8
	cmp $d012
	bne *-3

	lda #SPRITE_POSY_TOP+42
	sta $d001
	sta $d003
	lda #SPRITE_POSY_TOP+84
	sta $d005
	sta $d007
	lda #SPRITE_POSY_TOP+126
	sta $d009
	sta $d00b
	lda #SPRITE_POSY_TOP+168
	sta $d00d
	sta $d00f
	rts

do_border_vertical:
	lda #$ff
	sta SPRITES_STRETCHX_ENABLED
	lda #$00
	sta SPRITES_STRETCHY_ENABLED
	sta $d00e
	sta $d00f
	lda #$18
	sta $d000
	lda #$48
	sta $d002
	lda #$78
	sta $d004
	lda #$a8
	sta $d006
	lda #$d8
	sta $d008
	lda #$08
	sta $d00a
	lda #$38
	sta $d00c
	lda #%01100000
	sta $d010
	ldx ZP_BORDER_POS+1
	lda posy_border_table,x
	clc
	adc #SPRITE_POSY_TOP-21-5
	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d
	
	lda #RASTERLINE_FIRST_ONSCREEN+32
	cmp $d012
	bne *-3

	lda #200+SPRITE_POSY_TOP+5
	sec
	sbc posy_border_table,x
	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d

	rts


colors_fadeout_cache:
	.import binary "logo-koalafill/background-banner.col"

.pc = $4000
koala_fadeout:
	.import binary "logo-koalafill/background-banner.dat"
layout_fadeout_cache:
	.import binary "logo-koalafill/background-banner.lay"

.label layout_fadeout = $6000

.function letter_border_gfx_upper( i )
{
	.var line = i&7
    .if ( line < 4 )
	{
		.return 0
	}
	.if ( line < 7 )
	{
		.return %10101010
	}
	.return %01010101
}

.function letter_border_gfx_lower( i )
{
	.var line = i&7
	.if ( line == 0 )
	{
		.return %01010101
	}
    .if ( line < 4 )
	{
		.return %10101010
	}
	.return 0
}

.if ( GENERATE_CODE_FOR_TEST )
{
.pc = indata_bitmap "backbuffer area"
.import c64 "backbuffer-data.prg"

.pc = layoutA "layoutA"
	.fill 5, $66
	.fill 35, FONT_COLOR | ( FONT_LINE<<4 )
	.import binary "logo-koalafill/background-initial.lay"
	.fill 5, $66
	.fill 35, FONT_COLOR | ( FONT_LINE<<4 )
	.fill 80, $66
.pc = layoutB "layoutB"
	.import binary "logo-koalafill/background-initial.col"

.pc = spriteData "sprites"
	//.byte $c0,$00,$00,$60,$00,$00,$30,$00,$00,$18,$00,$00,$0c,$00,$00,$06,$00,$00,$03,$00,$00, $00,$c0,$00,$00,$60,$00,$00,$30,$00,$00,$18,$00,$00,$0c,$00,$00,$06,$00,$00,$03,$00, $00,$00,$c0,$00,$00,$60,$00,$00,$30,$00,$00,$18,$00,$00,$0c,$00,$00,$06,$00,$00,$03, $00
	//.byte $00,$00,$03,$00,$00,$06,$00,$00,$0c,$00,$00,$18,$00,$00,$30,$00,$00,$60,$00,$00,$c0, $00,$03,$00,$00,$06,$00,$00,$0c,$00,$00,$18,$00,$00,$30,$00,$00,$60,$00,$00,$c0,$00, $03,$00,$00,$06,$00,$00,$0c,$00,$00,$18,$00,$00,$30,$00,$00,$60,$00,$00,$c0,$00,$00, $00
	.import binary "spriteoverlay.spd"

.pc = koala "bitmap data"
	.fill 40, 0
	.fill 280, letter_border_gfx_upper( i )
	.import binary "background-initial.dat"
	.fill 40, 0
	.fill 280, letter_border_gfx_lower( i )
	.fill 640, 0

	//.fill $fff8-$ff40, 0
 
 }