.import source "common.iasm"
.import source "vic.iasm"
.import source "koala-techtech/scrollfont.iasm"
.import source "demo_constants.iasm"

.const ROW_COUNT = 17
.const TECHTECH_LINES = ROW_COUNT*8
.const UPDATE_BLOCK_SIZE = (update_block_end-update_block_start)/ROW_COUNT
//.const ZP_LINE_CACHE = AllocateZP( "ZP_LINE_CACHE" )
//.const ZP_SIN_X = AllocateZP( "ZP_SIN_X" )
.const ZP_SIN_Y = AllocateZP( "ZP_SIN_Y" )
.const ZP_SIN_Y_ADD = AllocateZP( "ZP_STOP_MOVEMENT" )
.const ZP_SCROLL_BLOCK = AllocateZP( "ZP_SCROLL_BLOCK" )
.const ZP_SCROLLER_SOFT = AllocateZP( "ZP_SCROLLER_SOFT" )
.const ZP_PENDING_LAYOUT = AllocateZP( "ZP_PENDING_LAYOUT" )
.const ZP_CHAR_FETCH_INDEX = AllocateZP( "ZP_CHAR_FETCH_INDEX" )
.const ZP_CHAR_FETCH_LENGTH = AllocateZP( "ZP_CHAR_FETCH_LENGTH" )
.const ZP_TEXT_FETCH_INDEX = AllocateZP( "ZP_TEXT_FETCH_INDEX" )

.const COLOR_D800 = BLACK;
.const COLOR_D021 = LIGHT_BLUE;

.pc = FIRST_SOURCE_LOCATION "main"
.if ( !GENERATE_CODE_FOR_TEST ) WaitForSignal( SIGNAL_FISH_LOAD_FINISHED )
else { lda #(>FRAME_TECH_TECH_ENTER)-1; jsr FORWARD_TO_FRAME; lda #0; sta $d011; }
	FillMem( $9300, 0, $d000-$9300 )
	jsr move_data
	FillMem( $5800, 0, $2800 )
	lda #0
	sta ZP_SIN_Y
	sta ZP_SIN_Y_ADD
	sta ZP_SCROLL_BLOCK
	sta ZP_CHAR_FETCH_INDEX
	sta ZP_TEXT_FETCH_INDEX
	lda #8
	sta ZP_CHAR_FETCH_LENGTH
	lda #7
	sta ZP_SCROLLER_SOFT
	ldx #0
!loop:
.for ( var row  = 0; row < ROW_COUNT; row++ )
{
.for ( var lay = 0; lay < 10; lay++ )
{
	lda source_layout+lay+47*row,x
	sta destination_layouts+$400*lay+40*row+3,x
}
}
	inx
	cpx #37
	beq !finished+
	jmp !loop-
!finished:
	:FillMem( $d800, COLOR_D800, 40*ROW_COUNT );
	:FillMem( $d800+40*ROW_COUNT, BLACK | 8, 40*(25-ROW_COUNT) )
	:FillMem( $a800, 0, $800 )
	lda #LIGHT_BLUE
	sta $d020
	sta $d021	
	sta $d027
	sta $d028
	sta $d029
	sta $d02a

	lda #BLUE
	sta $d022
	lda #CYAN
	sta $d023

	lda #VIC_BANK_4000
	sta VIC_BANK_SELECT_REGISTER
	lda #$0f
	sta SPRITES_VISIBLE_REGISTER
	sta SPRITES_STRETCHY_ENABLED
	lda #0
	sta SPRITES_STRETCHX_ENABLED
	sta SPRITES_MULTICOLOR_ENABLED
	sta SPRITES_PRIORITY_REGISTER
	lda #SPRITE_POSY_TOP
	sta $d001
	lda #SPRITE_POSY_TOP+42
	sta $d003
	lda #SPRITE_POSY_TOP+84
	sta $d005
	lda #SPRITE_POSY_TOP+126
	sta $d007

	lda #$20
	sta $d000
	sta $d002
	sta $d004
	sta $d006

	lda #SpriteIndex(sprite_overlay)
	ldx #3
!loop:
.for ( var rept = 0; rept < 10; rept++ )
{
	sta destination_layouts+$400*rept+$03f8,x
}
	dex
	bpl !loop-


	jsr update_tech_tech
	InitSignal()

	WaitForFrame( FRAME_TECH_TECH_ENTER )

	SetNewIRQFromMain( irq_init, RASTERLINE_FIRST_OFFSCREEN )
	lda #0
	sta ZP_SIN_Y_ADD
mainloop:
	lda #1
!loop:
	cmp ZP_SCROLL_BLOCK
	beq !loop-	
	sta ZP_SCROLL_BLOCK
	//lda #2
	//sta $d020
	jsr scroll1to2
	//lda #4
	//sta $d020
	lda #1
!loop:
	cmp ZP_SCROLL_BLOCK
	beq !loop-	
	sta ZP_SCROLL_BLOCK
	//lda #3
	//sta $d020
	jsr scroll2to1
	//lda #4
	//sta $d020
	CheckSignal( SIGNAL_PART_FINISHED )
	bne !skip+
	jmp mainloop
!skip:
	SetNewIRQFromMain( FRAMEWORK_IRQ, RASTERLINE_FIRST_OFFSCREEN )
	lda #0
	sta $d011
	jmp LOAD_AND_RUN

scroll1to2:
	ldx #0
!loop:
.for ( var line = 0; line < 5; line++ )
{
	lda scroller_layout+0*$400+40*20+40*line+1,x
	sta scroller_layout+1*$400+40*20+40*line+0,x
}
	inx
	cpx #39
	bne !loop-

	ldx ZP_CHAR_FETCH_INDEX
	lda letterCache+8*0,x
	sta scroller_layout+1*$400+40*20+39
	lda letterCache+8*1,x
	sta scroller_layout+1*$400+40*21+39
	lda letterCache+8*2,x
	sta scroller_layout+1*$400+40*22+39
	lda letterCache+8*3,x
	sta scroller_layout+1*$400+40*23+39
	lda letterCache+8*4,x
	sta scroller_layout+1*$400+40*24+39
	inx
	cpx ZP_CHAR_FETCH_LENGTH
	bne !skip+
	jsr fetch_next_character
	ldx #0
!skip:
	stx ZP_CHAR_FETCH_INDEX

	lda #calculateDisplayValue( $a000, $ac00 )
	sta ZP_PENDING_LAYOUT
	rts

scroll2to1:
	ldx #0
!loop:
.for ( var line = 0; line < 5; line++ )
{
	lda scroller_layout+1*$400+40*20+40*line+1,x
	sta scroller_layout+0*$400+40*20+40*line+0,x
}
	inx
	cpx #39
	bne !loop-

	ldx ZP_CHAR_FETCH_INDEX
	lda letterCache+8*0,x
	sta scroller_layout+0*$400+40*20+39
	lda letterCache+8*1,x
	sta scroller_layout+0*$400+40*21+39
	lda letterCache+8*2,x
	sta scroller_layout+0*$400+40*22+39
	lda letterCache+8*3,x
	sta scroller_layout+0*$400+40*23+39
	lda letterCache+8*4,x
	sta scroller_layout+0*$400+40*24+39
	inx
	cpx ZP_CHAR_FETCH_LENGTH
	bne !skip+
	jsr fetch_next_character
	ldx #0
!skip:
	stx ZP_CHAR_FETCH_INDEX

	lda #calculateDisplayValue( $a000, $a800 )
	sta ZP_PENDING_LAYOUT
	rts

fetch_next_character:
	ldx ZP_TEXT_FETCH_INDEX

	lda scrolltext,x
	cmp #$40
	bne !skip+
	inc ZP_TEXT_FETCH_INDEX
	lda #1
	sta ZP_SIN_Y_ADD
	jmp fetch_next_character
!skip:
	cmp #$ff
	bne !skip+
	SetSignal( SIGNAL_PART_FINISHED )
	lda #0
	.byte $0c
!skip:
	inc ZP_TEXT_FETCH_INDEX
	//debug_break()
	tax
	lda letterlookup,x
	sta ZP_CHAR_FETCH_LENGTH
.for ( var ix = 0; ix < 7; ix++ )
{
	ldy letterlookup+LETTER_MODULO*(ix+1),x
	lda columnlookup+COLUMN_MODULO*0,y
	sta letterCache+8*0+ix
	lda columnlookup+COLUMN_MODULO*1,y
	sta letterCache+8*1+ix
	lda columnlookup+COLUMN_MODULO*2,y
	sta letterCache+8*2+ix
	lda columnlookup+COLUMN_MODULO*3,y
	sta letterCache+8*3+ix
	lda columnlookup+COLUMN_MODULO*4,y
	sta letterCache+8*4+ix
}
	rts

letterCache:
	.fill 8*5, 0

// irq jmp vectors
irq:
	jmp jmp_irq
irq_stable:
	jmp jmp_irq_stable
irq_bottom:
	jmp jmp_irq_bottom

irq_init:
	StoreAXY( ret_init )
	lda #irq
	sta IRQ_JMP_LO
	lda #RASTERLINE_FIRST_ONSCREEN-2
	sta $d012
	lda #$3b
	sta $d011
	jsr FRAMEWORK_PERIODICAL
ret_init:
	RestoreAXY()

// irq routines
jmp_irq:
	sta irq_a
	stx irq_x
	sty irq_y
	lda #RASTERLINE_FIRST_ONSCREEN-1
	sta $d012
	lda #irq_stable
	sta IRQ_JMP_LO
	tsx
	asl $d019
	cli
	jmp NOP_FOREVER
jmp_irq_stable:
	txs
	DelayFor(24)
.label first_d018_inject = *+1
	lda #0
	sta $d018
.label first_d016_inject = *+1
	lda #0
	sta $d016
	StableRaster(false)
	DelayFor(8)
.label remain_d018_inject = *+1
.label remain_d016_inject = *+6
.const BLOCK_MULTIPLIER = 15
.for ( var row = 0; row < TECHTECH_LINES-1; row++ )
{
.var normal = true
begin:
	lda #0
	sta $d018
	lda #row+1
	sta $d016
	lda #((row+4)&7)|$38
	sta $d011
end:
.if ( row == 0 ) .if ( end-begin != BLOCK_MULTIPLIER ) .error "BLOCK_MULTIPLIER incorrect, should be " + toIntString( end-begin )
}
	lda #$d4
	sta $d018
	lda #$10
.label mark_scroll_inject = *-1
	sta $d016
	lda #$3b
	sta $d011

	lda #$1b
	ldx #VIC_BANK_8000
.label mark_display_layout = *+1
	ldy #calculateDisplayValue( $a000, $a800 )
	stx VIC_BANK_SELECT_REGISTER
	sty $d018
	sta $d011
	lda #$00
	sta $d006

	lda #irq_bottom
	sta IRQ_JMP_LO
	lda #RASTERLINE_FIRST_OFFSCREEN
	sta $d012

	asl $d019
	cli
	//inc $d020
	jsr update_tech_tech
	//dec $d020
	jsr FRAMEWORK_PERIODICAL
	lda #0
.label irq_a = *-1
	ldx #0
.label irq_x = *-1
	ldy #0
.label irq_y = *-1
	rti

jmp_irq_bottom:
	sta irq_bottom_return
	stx irq_bottom_return+2
	lda #RASTERLINE_FIRST_ONSCREEN-2
	sta $d012
	lda #irq
	sta IRQ_JMP_LO
	lda #$20
	sta $d006
	lda #$3b
	sta $d011
	lda #VIC_BANK_4000
	sta VIC_BANK_SELECT_REGISTER

	ldx ZP_SCROLLER_SOFT
	dex
	dex
	bpl !skip+
	lda #0
	sta ZP_SCROLL_BLOCK
	lda ZP_PENDING_LAYOUT
	sta mark_display_layout
	ldx #7
!skip:
	stx ZP_SCROLLER_SOFT
	txa
	ora #$10
	sta mark_scroll_inject

.label irq_bottom_return = *+1
	lda #0
	ldx #0
	asl $d019
	rti

update_tech_tech:
.const SECOND_BLOCK_SIZE = 30
.for ( var row = 0; row < TECHTECH_LINES; row++ )
{
begin:
	ldy #39
 .if ( row == 0 ) { nop; nop; nop }
 else { sty *-1-SECOND_BLOCK_SIZE }
 	ldx adjusttable+80*(row&1),y
	lda d016_table,x
 .if ( row == 0 )
 {
	sta first_d016_inject
 }
 else 
 {
	sta remain_d016_inject+(row-1)*BLOCK_MULTIPLIER
 }

	lda d018_table,x
 .if ( row == 0 ) 
 {
 	cmp first_d018_inject
	sta first_d018_inject
 }
 else
 {
 	cmp remain_d018_inject+(row-1)*BLOCK_MULTIPLIER
	sta remain_d018_inject+(row-1)*BLOCK_MULTIPLIER
 }
 	beq !skip+
 	ldy #row&7
	jsr update_block_start+UPDATE_BLOCK_SIZE*(row>>3)
 !skip:
end:
 .if ( end-begin != SECOND_BLOCK_SIZE ) .error "UPDATE_BLOCK_SIZE incorrect, should be " + toIntString( end-begin )
}
	ldx ZP_SIN_Y
	lda sinus,x
	sta *-SECOND_BLOCK_SIZE-4
	txa
	clc
	adc ZP_SIN_Y_ADD
	sta ZP_SIN_Y
	rts

adjusttable:
	.fill 80, i
	.fill 80, i //78-i

.pc = $8000 "tech-tech bitmap update code"
.const SOURCE_ALIGNMENT = 47*8
.print "Update Block Size = " + toHexString( UPDATE_BLOCK_SIZE )
update_block_start:
.for ( var row = 0; row < ROW_COUNT; row++ )
{
	sty mark+1
	txa
	and #$f8
mark:
	ora #$0
	tax
	.for ( var col = 0; col < 36; col++ )
	{
		lda source_bitmap+8*col+row*SOURCE_ALIGNMENT,x
		sta destination_bitmap+24+8*col+320*row,y
	}
	rts
}
update_block_end:

sinus:
	.fill 512, 78.9*(1+sin(i*PI/128))/2
.align $100
d018_table:
	.fill 80, $60+$10*(i>>3)
d016_table:
	.fill 80, $10 | (7-(i&7))


.pc = $4000 "VIC-bank displayed"
	// Allows 80 pixels techtech
destination_bitmap:
	.fill 320*(ROW_COUNT+2), 0 // koala data ($4000-$5540)
.align $40
sprite_overlay:
	.fill $40, $ff // free data area ($5540-$5800)
.pc = $5800 "layout buffers"
destination_layouts:
	//.fill $400*10, 0
.const SCROLLER_FONT_SIZE = 1096
.const SCROLLER_LAYOUT_SIZE = 799
.const SOURCE_BITMAP_SIZE = 6392
.const SCROLLTEXT_SIZE = 190+25
.const LETTERLOOKUP_SIZE = 264
.const COLUMNLOOKUP_SIZE = 440
.align $100
scroller_font_src:
	.import binary "scrollfont.dat"
.if ( *-scroller_font_src != SCROLLER_FONT_SIZE ) .error "SCROLLER_FONT_SIZE(" + toIntString( SCROLLER_FONT_SIZE ) + ") incorrect: " + toIntString( *-scroller_font_src )
.align $100
scroller_layout_src:
	.import binary "techtechimage.lay"
.if ( *-scroller_layout_src != SCROLLER_LAYOUT_SIZE ) .error "SCROLLER_LAYOUT_SIZE(" + toIntString( SCROLLER_LAYOUT_SIZE ) + ") incorrect: " + toIntString( *-scroller_layout_src )

.align $100
source_bitmap_src:
	.import binary "techtechimage.dat"
.if ( *-source_bitmap_src != SOURCE_BITMAP_SIZE ) .error "SOURCE_BITMAP_SIZE(" + toIntString( SOURCE_BITMAP_SIZE ) + ") incorrect: " + toIntString( *-source_bitmap_src )

.align $100
scrolltext_src:
	.import binary "scrolltext.dat"
	.fill 24, 0
	.byte $ff
.if ( *-scrolltext_src != SCROLLTEXT_SIZE ) .error "SCROLLTEXT_SIZE(" + toIntString( SCROLLTEXT_SIZE ) + ") incorrect: " + toIntString( *-scrolltext_src )

.align $100
letterlookup_src:
	.import binary "scrollfont.let"
.if ( *-letterlookup_src != LETTERLOOKUP_SIZE ) .error "LETTERLOOKUP_SIZE(" + toIntString( LETTERLOOKUP_SIZE ) + ") incorrect: " + toIntString( *-letterlookup_src )

.align $100
columnlookup_src:
	.import binary "scrollfont.col"
.if ( *-columnlookup_src != COLUMNLOOKUP_SIZE ) .error "COLUMNLOOKUP_SIZE(" + toIntString( COLUMNLOOKUP_SIZE ) + ") incorrect: " + toIntString( *-source_bitmap_src )

.macro CopyRow( row, source, destination, size )
{
 .if ( row <= ( floor(size/$100) ) )
 {
 	.print toHexString( row ) + " vs " +toHexString( size )
 	lda source+$100*row,x
 	sta destination+$100*row,x
 }
}

.align $100
move_data:
	ldx #0
!loop:
.for ( var row = 0; row < $19; row++ )
{
	CopyRow( row, scroller_font_src, scroller_font, SCROLLER_FONT_SIZE )
	CopyRow( row, scroller_layout_src, scroller_layout, SCROLLER_LAYOUT_SIZE )
	CopyRow( row, source_bitmap_src, source_bitmap, SOURCE_BITMAP_SIZE )
	CopyRow( row, scrolltext_src, scrolltext, SCROLLTEXT_SIZE )
	CopyRow( row, letterlookup_src, letterlookup, LETTERLOOKUP_SIZE )
	CopyRow( row, columnlookup_src, columnlookup, COLUMNLOOKUP_SIZE )
}
	inx
	beq !finished+
	jmp !loop-
!finished:
	rts

.label scroller_font = $a000
.label scroller_layout = $a800
.label source_layout = $a800
.label source_bitmap = $b000
.label scrolltext = $c900
.label letterlookup = $ca00
.label columnlookup = $cc00
/*
.pc = scroller_font "font"
	//.import binary "scrollfont.dat"
.pc = scroller_layout "layout"
	//.import binary "techtechimage.lay"
.pc = source_bitmap "source image data"
	//.import binary "techtechimage.dat"
.pc = scrolltext "text tables"
	//.import binary "scrolltext.dat"; .fill 24, 0; .byte $ff
.pc = letterlookup "letterlookup"
	//.import binary "scrollfont.let"
.pc = columnlookup "columnlookup"
	//.import binary "scrollfont.col"
*/