.import source "common.iasm"
.import source "vic.iasm"
.import source "semaphore.iasm"
.import source "border-koala/colortables.iasm"
.import source "demo_constants.iasm"

.const RASTERSPLIT_0 = RASTERLINE_FIRST_ONSCREEN-4

.const ZP_POSITION = AllocateZP( "ZP_POSITION" )

.pc = FIRST_SOURCE_LOCATION
      lda #0
      sta $d011
      CopyMem( colors, $d800, 1006 )
      jsr init_color_updates
      lda #calculateDisplayValue( $4000,$6000 )
      sta $d018
      lda #VIC_BANK_4000
      sta VIC_BANK_SELECT_REGISTER
      lda #GRAY
      sta $d021
      sta $d020
      lda #%00011110
      sta SPRITES_VISIBLE_REGISTER
      lda #%00000110
      sta SPRITES_MULTICOLOR_ENABLED
      lda #%00011000
      sta SPRITES_STRETCHX_ENABLED
      lda #0
      sta SPRITES_STRETCHY_ENABLED
      sta SPRITES_PRIORITY_REGISTER
.const ZP_REP_COUNT = AllocateWordZP( "ZP_REP_COUNT" )
.const ZP_SINUS_INDEX = AllocateWordZP( "ZP_SINUS_INDEX" )
.const ZP_D016_VALUE = AllocateWordZP( "ZP_D016_VALUE" )
.const ZP_D016_VALUE_A = ZP_D016_VALUE+0
.const ZP_D016_VALUE_B = ZP_D016_VALUE+1
      lda #0
      sta ZP_SINUS_INDEX+0
      sta ZP_SINUS_INDEX+1
      sta ZP_REP_COUNT
      lda #7
      sta ZP_REP_COUNT+1
      InitSignal()
      jsr update_position
      //jsr init_sprites

      lda ZP_D016_VALUE_B
      sta $d016

      lda #SPRITE_POSY_TOP
      sta $d003
      sta $d005
      sta $d007
      sta $d009

.if ( GENERATE_CODE_FOR_TEST )
{
      lda #(>FRAME_BORDER_KOALA_ENTER)-1
      jsr FORWARD_TO_FRAME
      lda #GRAY
      sta $d020
}
      lda #1
.const ZP_INHIBIT_MOVEMENT = AllocateZP( "ZP_INHIBIT_MOVEMENT" )
      sta ZP_INHIBIT_MOVEMENT
      WaitForFrame( FRAME_BORDER_KOALA_ENTER )
      SetNewIRQFromMain( irq_enter, RASTERLINE_FIRST_OFFSCREEN )
      WaitForFrame( FRAME_BORDER_KOALA_MOVE )
      lda #0
      sta ZP_INHIBIT_MOVEMENT
      //SetNewIRQFromMain( irq, RASTERSPLIT_0 )
      WaitForSignal( SIGNAL_PART_FINISHED )
      jmp LOAD_AND_RUN

.align $100
irq_enter:
      StoreAXY( ret_enter )

      lda #irq
      sta IRQ_JMP_LO
      lda #RASTERSPLIT_0
      sta RASTERLINE_REGISTER
      jsr FRAMEWORK_PERIODICAL
ret_enter:
      RestoreAXY_Return()

irq:
      StoreAXY( irq_return )
      lda #RASTERSPLIT_0+1
      sta $d012
      lda #irq_stable
      sta IRQ_JMP_LO
      asl $d019
      tsx
      cli
      jmp NOP_FOREVER
irq_stable:
      //dec $d020
      txs
      lda #$3b
      sta $d011
      lda #irq
      sta IRQ_JMP_LO
      lda #RASTERSPLIT_0
      sta $d012
      //lda #$0c
      //sta $d020
      DelayFor(26)
      StableRaster(false)
.if ( GENERATE_CODE_FOR_TEST )
{
      inc $d020
      dec $d020
      DelayFor(23-12)
}
else DelayFor( 23 )
      clc
      bcc *+2
.label vsp_position_marker = *-1
      .fill 13, $e2
      .byte $24, $ea
ErrorIfNotSameBank(*,vsp_position_marker)
      lda #$39
      sta $d011
      lda #$3b
      sta $d011
      ldx #0
//.const ZP_SIDE = AllocateZP( "ZP_SIDE" )
      jsr update
      lda #SPRITE_POSY_TOP
      sta $d003
      sta $d005
      sta $d007
      sta $d009
      jsr update_position
      //jsr init_sprites
      lda ZP_D016_VALUE_B
      sta $d016

      inc ZP_REP_COUNT+0
      bne !skip+
      dec ZP_REP_COUNT+1
      bne !skip+
.if ( !GENERATE_CODE_FOR_TEST )
{
      NextInterrupt( FRAMEWORK_IRQ, RASTERLINE_FIRST_OFFSCREEN )
      lda #0
      sta $d011
      SetSignal( SIGNAL_PART_FINISHED )
}
!skip:
      //inc $d020
      jsr FRAMEWORK_PERIODICAL
      //dec $d020
irq_return:
      RestoreAXY_Return()
      //jmp RETURN_FROM_INTERRUPT// _PERIODICAL

update_position:
      ldx ZP_SINUS_INDEX+0
      //ldy ZP_SINUS_INDEX+1
      lda sinus_curve2,x
      clc
      adc sinus_curve3,x
      lsr
      tay
      lda position_table,y
      sta $d002
      sta $d006
      sta $d008
      lda position_table_add,y
      sta $d004
      lda d010_table,y
      sta $d010
      //and #$80
      //sta ZP_SIDE
      tya
      and #$07
      ora #$10
      sta ZP_D016_VALUE_A
      ora #$08
      sta ZP_D016_VALUE_B
      tya
      lsr
      lsr
      lsr
      sta ZP_POSITION
      lda #11
      sec
      sbc ZP_POSITION
.if ( GENERATE_CODE_FOR_TEST )
{
      bpl !skip+
      inc $d020
      jmp *-3
!skip:
}
      //sta ZP_POSITION
      sta vsp_position_marker
      lda ZP_INHIBIT_MOVEMENT
      bne !skip+
      inc ZP_SINUS_INDEX
!skip:
      jmp init_sprites
      //rts

sinus_curve2:
      .fill 256, 95.9*(1+sin(i*2*PI/128))/2
sinus_curve3:
      .fill 256, 95.9*(1-sin(i*3*PI/128))/2

.const ZP_SRC_L = AllocateWordZP( "ZP_SRC_L" )
.const ZP_DST_L = AllocateWordZP( "ZP_DST_L" )
.const ZP_SRC_C = AllocateWordZP( "ZP_SRC_C" )
.const ZP_DST_C = AllocateWordZP( "ZP_DST_C" )
.const ZP_CNT = AllocateZP( "ZP_CNT" )
init_color_updates:
      lda #24
      sta ZP_CNT
      LoadImm( ZP_SRC_L, $6000+6 )
      LoadImm( ZP_DST_L, layout_update+6 )
      LoadImm( ZP_SRC_C, colors+6 )
      LoadImm( ZP_DST_C, colors_update+6 )
!loopCnt:
      ldy #0
!loop:
      lda (ZP_SRC_L),y
      sta (ZP_DST_L),y
      lda (ZP_SRC_C),y
      sta (ZP_DST_C),y
      iny
      cpy #6
      bne !loop-
      AddWordConst( ZP_SRC_L, 34 )
      AddWordConst( ZP_DST_L, 6 )
      AddWordConst( ZP_SRC_C, 34 )
      AddWordConst( ZP_DST_C, 6 )
      ldy #0
!loop:
      lda (ZP_SRC_L),y
      sta (ZP_DST_L),y
      lda (ZP_SRC_C),y
      sta (ZP_DST_C),y
      iny
      cpy #6
      bne !loop-
      AddWordConst( ZP_SRC_L, 6 )
      AddWordConst( ZP_DST_L, 18 )
      AddWordConst( ZP_SRC_C, 6 )
      AddWordConst( ZP_DST_C, 18 )
      dec ZP_CNT
      bpl !loopCnt-
      rts

layout_update:
      .fill 25*24, $cc
colors_update:
      .fill 25*25, $0c

update:
      ldx $d010 //ZP_SIDE
      bmi !skip+
      //cpx #$ff
      //beq !skip+
      bit $ea
      jmp update_left
!skip:
      nop
      jmp update_right

update_left:
{
      ldx #0
      DelayFor(11+24-1+2)
      lda ZP_D016_VALUE_B
      ldy ZP_D016_VALUE_A
.const BORDER_REGISTER = $d016
.var SpriteMoveIndex = 0
.var SpriteMoveList = List().add( 6, 5, 6, 5, 5, 5, 6, 5, 5, 100 )
.var SpriteChangeIndex = 0
.var SpriteChangeList = List().add( 19, 19, 19, 19, 18, 18, 18, 18, 18, 100 )
.for ( var row = 0; row < 200; row++ )
{
.var DoChangeSprite = -1
.var SpriteMove = -1
.var ColorUpdates = 0
.var MyDelay = 44
.if ( (row&7) == 7 ) .eval MyDelay = 0
      sty BORDER_REGISTER
.if ( ( row & 7 ) == 7 ) sta BORDER_REGISTER,x
else  sta BORDER_REGISTER
.if ( row == (21*SpriteMoveIndex + SpriteMoveList.get( SpriteMoveIndex ) ) )
{
      ldx #SPRITE_POSY_TOP+21+SpriteMoveIndex*21
      stx $d003
      stx $d005
      stx $d007
      stx $d009
      .eval MyDelay = MyDelay-(2+4*4)
      .eval SpriteMove = SpriteMoveIndex
      .eval SpriteMoveIndex = SpriteMoveIndex+1
}
.if ( row < 198 )
{
      .eval MyDelay = MyDelay-6*ColorsLeft.get(row+2).get(6)
      .eval ColorUpdates = ColorsLeft.get(row+2).get(6)
}
.if ( row == 21*SpriteChangeIndex+SpriteChangeList.get(SpriteChangeIndex) )
{
      .eval MyDelay = MyDelay - 6*4;
      .eval DoChangeSprite = SpriteChangeIndex
      .eval SpriteChangeIndex = SpriteChangeIndex+1
}
.if ( MyDelay != 0 && MyDelay < 2 ) .error "(Left) Row " + toIntString( row+2 ) + " has too many operations. SMI=" + toIntString( SpriteMoveIndex ) + " MyDelay=" +toIntString( MyDelay ) + " ColorUpdates=" + toIntString(ColorUpdates) + " SpriteMoved=" + toIntString(SpriteMove) + " SpriteChange=" +toIntString(SpriteChangeIndex) + " DoSpriteChange="+toIntString(DoChangeSprite)
.if ( ( row & 7 ) == 6 ) { .eval MyDelay = MyDelay - 2 }
      DelayFor( MyDelay )

.if ( row < 198 )
{
  .if ( ColorsLeft.get(row+2).get(0) != -1 ) { ldx #ColorsLeft.get(row+2).get(0); stx $d025 }
  .if ( ColorsLeft.get(row+2).get(1) != -1 ) { ldx #ColorsLeft.get(row+2).get(1); stx $d026 }
  .if ( ColorsLeft.get(row+2).get(2) != -1 ) { ldx #ColorsLeft.get(row+2).get(2); stx $d02a }
  .if ( ColorsLeft.get(row+2).get(3) != -1 ) { ldx #ColorsLeft.get(row+2).get(3); stx $d02b }
  .if ( ColorsLeft.get(row+2).get(4) != -1 ) { ldx #ColorsLeft.get(row+2).get(4); stx $d028 }
  .if ( ColorsLeft.get(row+2).get(5) != -1 ) { ldx #ColorsLeft.get(row+2).get(5); stx $d029 }
}
.if ( DoChangeSprite != -1 )
{
      inc $63f9
      inc $63fa
      inc $63fb
      inc $63fc
}
.if ( ( row & 7 ) == 6 ) { ldx #0; }

}
}
      rts

update_right:
{
      ldx #0
      DelayFor(11+24-1+2)
      lda ZP_D016_VALUE_B
      ldy ZP_D016_VALUE_A
.const BORDER_REGISTER = $d016
.var SpriteMoveIndex = 0
.var SpriteMoveList = List().add( 6, 5, 6, 5, 5, 5, 6, 5, 5, 100 )
.var SpriteChangeIndex = 0
.var SpriteChangeList = List().add( 19, 19, 19, 19, 18, 18, 18, 18, 18, 100 )
.for ( var row = 0; row < 200; row++ )
{
.var DoChangeSprite = -1
.var SpriteMove = -1
.var ColorUpdates = 0
.var MyDelay = 44
.if ( (row&7) == 7 ) .eval MyDelay = 0
      sty BORDER_REGISTER
.if ( ( row & 7 ) == 7 ) sta BORDER_REGISTER,x
else  sta BORDER_REGISTER
.if ( row == (21*SpriteMoveIndex + SpriteMoveList.get( SpriteMoveIndex ) ) )
{
      ldx #SPRITE_POSY_TOP+21+SpriteMoveIndex*21
      stx $d003
      stx $d005
      stx $d007
      stx $d009
      .eval MyDelay = MyDelay-(2+4*4)
      .eval SpriteMove = SpriteMoveIndex
      .eval SpriteMoveIndex = SpriteMoveIndex+1
}
.if ( row < 198 )
{
      .eval MyDelay = MyDelay-6*ColorsRight.get(row+1).get(6)
      .eval ColorUpdates = ColorsRight.get(row+1).get(6)
}
.if ( row == 21*SpriteChangeIndex+SpriteChangeList.get(SpriteChangeIndex) )
{
      .eval MyDelay = MyDelay - 6*4;
      .eval DoChangeSprite = SpriteChangeIndex
      .eval SpriteChangeIndex = SpriteChangeIndex+1
}
.if ( MyDelay != 0 && MyDelay < 2 ) .error "(Right) Row " + toIntString( row+1 ) + " has too many operations. SMI=" + toIntString( SpriteMoveIndex ) + " MyDelay=" +toIntString( MyDelay ) + " ColorUpdates=" + toIntString(ColorUpdates) + " SpriteMoved=" + toIntString(SpriteMove) + " SpriteChange=" +toIntString(SpriteChangeIndex) + " DoSpriteChange="+toIntString(DoChangeSprite)
.if ( ( row & 7 ) == 6 ) { .eval MyDelay = MyDelay - 2 }

.if ( row < 198 )
{
  .if ( ColorsRight.get(row+1).get(0) != -1 ) { ldx #ColorsRight.get(row+1).get(0); stx $d025 }
  .if ( ColorsRight.get(row+1).get(1) != -1 ) { ldx #ColorsRight.get(row+1).get(1); stx $d026 }
  .if ( ColorsRight.get(row+1).get(2) != -1 ) { ldx #ColorsRight.get(row+1).get(2); stx $d02a }
  .if ( ColorsRight.get(row+1).get(3) != -1 ) { ldx #ColorsRight.get(row+1).get(3); stx $d02b }
  .if ( ColorsRight.get(row+1).get(4) != -1 ) { ldx #ColorsRight.get(row+1).get(4); stx $d028 }
  .if ( ColorsRight.get(row+1).get(5) != -1 ) { ldx #ColorsRight.get(row+1).get(5); stx $d029 }
}
.if ( DoChangeSprite != -1 )
{
      inc $63f9
      inc $63fa
      inc $63fb
      inc $63fc
}
.if ( ( row & 7 ) == 6 ) { ldx #0; }

      DelayFor( MyDelay )
}
}
      rts

.align $100
position_table:
      // left side
      .fill $18, $e0+i
      .fill $18, i
      // right side
      .fill $30,$28+i

position_table_add:
      .fill $18, $00+i
      .fill $18, $18+i
      // right side
      .fill $30, $40+i

d010_table:
      .fill $18, $1a
      .fill $18, $00
      .fill $30, $ff

.pc = $4000
      .fill 8*6, 0
      .import binary "border-koala/image.dat"
      //.fill 8000, 0
.pc = $6000
      .fill 6, 0
      .import binary "border-koala/image.lay"
      .fill 10,0
      .fill 8, SpriteIndex($6400)
.pc = $6400
      .import binary "border-koala/spritesLeft.spr"
      .import binary "border-koala/spritesRight.spr"

.pc = $7fff
      .byte 0

init_sprites:
      lda $d010 //ZP_SIDE
      bmi init_sprites_right
      //cmp #$ff //#$80
      //beq init_sprites_right
      jmp init_sprites_left

init_sprites_right:
      lda #SpriteIndex( $6400 )+4*10
      sta $63f9
      lda #SpriteIndex( $6400 )+5*10
      sta $63fa
      lda #SpriteIndex( $6400 )+6*10
      sta $63fb
      lda #SpriteIndex( $6400 )+7*10
      sta $63fc
      lda #ColorsRight.get(0).get(0)
      sta $d025
      lda #ColorsRight.get(0).get(1)
      sta $d026
      lda #ColorsRight.get(0).get(2)
      sta $d02a
      lda #ColorsRight.get(0).get(3)
      sta $d02b
      lda #ColorsRight.get(0).get(4)
      sta $d028
      lda #ColorsRight.get(0).get(5)
      sta $d029
      ldx #0
!loop:
.for( var row = 0; row < 25; row++ )
{
      lda #$cc
      sta $6000+40+40*row,x
      sta $d800+40+40*row,x
      lda layout_update+24*row+6,x
      sta $6000+6+40*row,x
      lda colors_update+24*row+6,x
      sta $d800+6+40*row,x
}
      inx
      cpx #6
      beq !finished+
      jmp !loop-
!finished:
      rts

init_sprites_left:
      lda #SpriteIndex( $6400 )+0*10
      sta $63f9
      lda #SpriteIndex( $6400 )+1*10
      sta $63fa
      lda #SpriteIndex( $6400 )+2*10
      sta $63fb
      lda #SpriteIndex( $6400 )+3*10
      sta $63fc
      lda #ColorsLeft.get(0).get(0)
      sta $d025
      lda #ColorsLeft.get(0).get(1)
      sta $d026
      lda #ColorsLeft.get(0).get(2)
      sta $d02a
      lda #ColorsLeft.get(0).get(3)
      sta $d02b
      lda #ColorsLeft.get(0).get(4)
      sta $d028
      lda #ColorsLeft.get(0).get(5)
      sta $d029
      ldx #0
!loop:
.for( var row = 0; row < 25; row++ )
{
      lda #$cc
      sta $6000+6+40*row,x
      sta $d800+6+40*row,x
      lda layout_update+24*row+12,x
      sta $6000+40+40*row,x
      lda colors_update+24*row+12,x
      sta $d800+40+40*row,x
}
      inx
      cpx #6
      beq !finished+
      jmp !loop-
!finished:
      rts

colors:
      .fill 6, 0
      .import binary "border-koala/image.col"
