;**********************************************
; infinite scanlines vertical raster for 256byte 
; lovebyte compo
;
; (c) 2021 Simon Jonassen
; AKA The Invisble Man (DESIRE)
;
; Free for all, use as you see fit
; just give credit where it's due..
;**********************************************
		opt	6809
		opt	cd
		org	$e00
costab		equ	$1000
**********************************************
start		orcc	#$50			;irq's off
		sta	$ffd9			;fast mode (1.78Mhz)
**********************************************
* BUILD 256 BYTE COSTAB FROM 64 ENTRIES
**********************************************
		ldu	#$1000			;dest for costab
		ldx	#ctab
lp1		ldd	,x++
		std	128,u
		std	,u++
		cmpx	#endc
		bne	lp1
lp2		ldd	,--x
		exg	a,b
		std	128,u
		std	,u++
		cmpx	#ctab
		bne	lp2		
**********************************************
* 320 x 200 x 16 videomode + gime setup
**********************************************
		lda	#$4a		;coco3 mode, mmu active
		sta	$ff90
		ldd	#$873e		;(320*200*16 = $3e), INFINITE SCANLINES = $87
		std	$ff98
**********************************************
* screen offset at $60000
**********************************************
		ldd	#$c000
		std	$ff9d
**********************************************
* 8k of mmu banks at $4000
**********************************************
		lda	#$30
		sta	$ffa2
**********************************************
* CLS (ONE LINE hehe)
**********************************************
		ldx	#$4000
		ldd	#$0
cls		std	,x++
		cmpx	#$4000+160
		blo	cls
**********************************************
* PALETTE REGS 0..7
**********************************************
		ldd	#$0001
		std	$ffb0
		ldd	#$0809
		std	$ffb2
		ldd	#$0f39
		std	$ffb4
		ldd	#$3f00
		std	$ffb6
**********************************************
*DO THIS *THING*
**********************************************
hs		lda	$ff03		;POLL VSYNC
		bpl	hs
		lda	$ff02		;ack

off1		ldx	#$4000
b2		ldb	costab
		abx
		ldu	#vert		
rasit		pulu	d
		std	,x++
		cmpu	#vertend
		blo	rasit
**********************************************
* flip pallete for nn lines
**********************************************
		ldb	#255		;scanline count
kk		lda	$ff00		;ack hsync
ee		lda	$ff01		;poll for new scanline
		bpl	ee
		inc	$ffb0		;increase pallete entry #0 (background)
		decb			;do this B times	
		bne	kk
		dec	b2+2		;get next costab entry for vertical bar
		jmp	hs		

**********************************************
* RASTERBAR
**********************************************
vert		fdb	$0000
		fdb	$0000
		fdb	$1712
		fdb	$7123
		fdb	$7123
		fdb	$4712
		fdb	$3457
		fdb	$1234
		fdb	$5654
		fdb	$3217
		fdb	$5432
		fdb	$1743
		fdb	$2173
		fdb	$2172
		fdb	$1717
		fdb	$0000	
		fdb	$0000
vertend		equ	*
**********************************************
ctab	fcb	0,3,6,9,13,16,19,22,25,28,31,34,37,40,43,46
	fcb	49,52,55,58,60,63,66,68,71,74,76,79,81,84,86,88
	fcb	91,93,95,97,99,101,103,105,106,108,110,111,113,114,116,117
	fcb	118,119,121,122,122,123,124,125,126,126,127,127,127,128,128,128
endc	equ	*



		end	start