; Procedura dekompresji danych skompresowanych algorytmem RLE
									; C - klucz
									; A - koniec
									; HL - adres docelowy
									; DE - adres źródłowy
dekompresja:	
				LD (dekem_end+1),A
				LD A,C
				LD (kluczyk+1),A
	start_dekom:									
				LD A,(DE)			
				INC DE				; i przechodzimy do następnego adresu
				LD B,A				; zapisujemy ją w B, bo zanim jej użyjemy, akumulator będzie zniszczony. można by było odłożyć AF na stosie, ale to potrwa dłużej.
	kluczyk:	CP 11				; sprawdzamy, czy nie jest to znacznik ciągu
				JR Z,wiecejbajtowem	; jeżeli jest, to skaczemy do rozwinięcia ciągu.
									; tutaj nie jest to 0, czyli wrzucamy 1 bajt
				LD (HL),B			; i wrzucamy pobraną wcześniej wartość na ekran (ten z dwóch, który nie jest wyświetlany)
				INC HL				; następny adres na ekranie
				JP czykoniecem		; omijamy procedurę rozwinięcia ciągu skacząc dalej
	wiecejbajtowem:					; rozwinięcie ciągu po wykryciu wartości 26
				LD A,(DE)			; pobieramy powtarzającą się w ciągu wartość
				LD C,A				; i wrzucamy ją do rejestru C
				INC DE				; następny adres
				LD A,(DE)			; pobieramy długość ciągu
				LD B,A				; i wrzucamy ją do rejestru B
				INC DE				; następny adres
	tylebajtowem:
				LD (HL),C			; do kolejnych bajtów w pamięci ekranu wrzucamy wartość z rejesrtu C 
				INC HL				; następny adres na ekranie
				DJNZ tylebajtowem	; długość ciągu w rejestrze B
	czykoniecem:
				LD A,H				
	dekem_end:	CP 128				; sprawdzamy, czy w H jest wartość oznaczająca koniec dekompresji
				JP NZ,start_dekom	
				RET				
				