#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>
#include "smallworlds.h"
#include "renderer.h"
#include "cg_time.h"
#include "matrix.h"
#include "shader.h"
#include "texture.h"
#include "antscene.h"
#include "embryo.h"
#include "molscene.h"
#include "greetings.h"
#include "fractal.h"
#include "mesh3d.h"
#include "atomscene.h"
#include "sky.h"

#define SCREENSHADERNUM 2

Renderer render;
float pmatrix[16];
GLuint cgtex;
GLuint crewtex;
GLuint functex;
GLuint titletex;

/* Variable initialization */
void InitSmallW(int w, int h){

   /* OpenGL based initialization */
   glClearColor(0.0, 0.0, 0.0, 0.0);
   glEnable(GL_DEPTH_TEST);
   glEnable(GL_BLEND);

   /* Renderer settings */
   render                   = createRenderer(2, SCREENSHADERNUM, w, h);
   render.screen_shaders[0] = loadShader(GL_VERTEX_SHADER,   "shaders/post.vs");
   render.screen_shaders[1] = loadShader(GL_FRAGMENT_SHADER, "shaders/post.fs");
   render.screen_prg        = createProgram(SCREENSHADERNUM, render.screen_shaders);

   perspectiveMatrix(pmatrix, 35.0, ASPECT, 0.1, 1500.0);

   /* Textures */
   cgtex = loadPNGTexture("data/texture/cybernetic_genetics.png");
   crewtex = loadPNGTexture("data/texture/travis_grass_shamen.png");
   functex = loadPNGTexture("data/texture/function_2013.png");
   titletex = loadPNGTexture("data/texture/small_worlds.png");

   initSky();

   /* Scene related initialization */
   initAntScene(pmatrix);
   initMolScene(pmatrix);
   initGreetings(pmatrix);
   initFractalScene(pmatrix);
   initEmbryoScene(pmatrix);
   initAtomScene(pmatrix);

   startTime();
}

/* Timing for the scenes */
void selectScene(double time){
   if(time < 60.0)                  antScene(time);
   if(time > 60.0  && time < 120.0) molScene(time);
   if(time > 120.0 && time < 195.0) greetingsScene(time);
   if(time > 180.0 && time < 255.0) fractalScene(time);
   if(time > 255.0 && time < 285.0) atomScene(time);
   if(time > 285.0 && time < 330.0) embryoScene(time);
}

/* Additional timing/parameter settings for post processing effects */
void selectPostProcess(double time){
   GLint loc;

   glActiveTexture(GL_TEXTURE0 + render.colorbuffernum + 1);
   if(time < 7.40) glBindTexture(GL_TEXTURE_2D, cgtex);
   else if(time > 7.40 && time < 15.10) glBindTexture(GL_TEXTURE_2D, titletex);
   else if(time > 15.10 && time < 22.43) glBindTexture(GL_TEXTURE_2D, crewtex);
   else if(time > 22.43 && time < 30.52) glBindTexture(GL_TEXTURE_2D, functex);
   else glBindTexture(GL_TEXTURE_2D, 0);

   loc = glGetUniformLocation(render.screen_prg, "text");
   glUniform1i(loc, render.colorbuffernum + 1);
}

/* Render stuffs */
void PlaySmallW(){
   double time;
   char *colorbuffernames[] = {"color1", "color2", "depth"};

   time = getTimeInterval();

   /* Geometry */
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   renderFirstStage(render);
   selectScene(time);

   /* Post processing */
   renderSecondStage(render, colorbuffernames);
   selectPostProcess(time);
   drawQuad(render);
}

/* Release resources */
void FreeSmallW(){
   freeRenderer(render);

   freeSky();

   /* Scene related resource releasing */
   freeAntScene();
   freeMolScene();
   freeGreetings();
   freeFractalScene();
   freeEmbryoScene();
   freeAtomScene();
}
