#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>

#define ASPECT 1.7777

typedef struct _Renderer {
   /* Members for the first pass */
   GLuint        framebuffer;
   GLuint        depthbuffer;
   GLuint       *colorbuffers;
   unsigned int  colorbuffernum;
   int           fviewport[4]; /* Viewport for first pass */
/*   GLuint        gbuffer_prg;
   GLuint       *gbuffer_shaders;
   unsigned int  gbuffershadernum; It is unnecessary */
   GLenum       *bufferids;

   /* Members for the second pass */
   GLuint        screenvao;
   GLuint        screenvbo;
   GLuint        screen_prg;
   GLuint       *screen_shaders;
   unsigned int  screenshadernum;
   int           vviewport[4]; /* Viewport for second pass*/
} Renderer;

Renderer createRenderer(unsigned int colorbuffernum, unsigned int screenshadernum, int width, int height);
void freeRenderer(Renderer renderer);
void renderFirstStage(Renderer renderer);
void renderSecondStage(Renderer renderer, char **varname);
void drawQuad(Renderer renderer);
