uniform sampler2D       in_Normal;
uniform sampler2D       in_VPos;
uniform sampler2D       in_Diffuse;
uniform sampler2D       in_Emission;
uniform sampler2D       in_AmbientOcclusion;
uniform sampler2D       in_MaterialMap;
uniform vec3  FogColor;
uniform float FogDistance;
uniform float FogFactor;
varying vec2 uv;
vec4 DiffuseSampler;
vec4 EmissionSampler;
vec4 SpecularSampler;
float MaterialIndex;
vec3 eyeDir;
vec3 VPos;
vec3 Normal;
vec4 lightDiffuse;
vec4 lightSpecular;
#define SPEC_INTENSITY_POINT 		4.3
#define SPEC_INTENSITY_DIRECTIONAL 	1.5
#define SPECULAR_FACTOR 			1.75
#define SPECULAR_ALPHA 				0.1
#define SPEC_FACTOR_NO_SPEC_MAP 	0.6
#define ENV_ALPHA_FACTOR			0.3
void processLight(int iLightIndex)
{
vec3 lightDir;
float specularIntensity = 1.0;
float attenuation       = 1.0;
if (gl_LightSource[iLightIndex].position.w == 1.0)
{
float dist = distance(gl_LightSource[iLightIndex].position.xyz, VPos);
attenuation = 1. / (gl_LightSource[iLightIndex].constantAttenuation + (gl_LightSource[iLightIndex].linearAttenuation * dist) + (gl_LightSource[iLightIndex].quadraticAttenuation * dist * dist));
lightDir = normalize(gl_LightSource[iLightIndex].position.xyz - VPos);
specularIntensity = SPEC_INTENSITY_POINT;
}
else
{
lightDir = normalize(gl_LightSource[iLightIndex].position.xyz);
specularIntensity = SPEC_INTENSITY_DIRECTIONAL;
}
lightDiffuse += ((vec4(DiffuseSampler.rgb, 1.) * gl_LightSource[iLightIndex].diffuse * max(dot(Normal, lightDir), 0.0)) * attenuation);
float NdotHV = clamp(dot(Normal, normalize(eyeDir + lightDir)), 0.0, 1.0);
}
const float MaterialMap_PixelsPerMaterial = 3.;
const float MaterialMap_MaterialsCount    = 16.;
const float MaterialMap_YStep             = 1. / (MaterialMap_PixelsPerMaterial * MaterialMap_MaterialsCount);
vec4 GetMaterialData(int DataItem)
{
return texture2D(in_MaterialMap, vec2(0., MaterialMap_YStep * (MaterialIndex *  MaterialMap_PixelsPerMaterial + float(DataItem))));
}
void main()
{
VPos            = texture2D(in_VPos, uv).xyz;
Normal          = texture2D(in_Normal, uv).rgb;
DiffuseSampler  = texture2D(in_Diffuse, uv);
EmissionSampler = texture2D(in_Emission, uv);
MaterialIndex   = DiffuseSampler.a;
vec4  MAT_Specular  = GetMaterialData(1);
float MAT_AmbFactor = GetMaterialData(2).r;
eyeDir = vec3(normalize(-VPos));
lightDiffuse  = vec4(0.0, 0.0, 0.0, 1.0);
lightSpecular = vec4(0.0, 0.0, 0.0, 1.0);
processLight(0);
processLight(1);
gl_FragColor = vec4(DiffuseSampler.rgb * lightDiffuse.rgb, 1.);
gl_FragColor.rgb += DiffuseSampler.rgb * MAT_AmbFactor * texture2D(in_AmbientOcclusion, uv).r;
gl_FragColor.rgb += lightSpecular.rgb * (SpecularSampler.rgb * SPEC_FACTOR_NO_SPEC_MAP);
gl_FragColor.rgb += EmissionSampler.rgb;
if (FogFactor != 0.)
{
float depth = -VPos.z;
if (depth == 0.) depth = FogDistance;
depth = pow(clamp(depth / FogDistance, 0., 1.), FogFactor);
gl_FragColor.rgb = mix(gl_FragColor.rgb, FogColor, clamp(depth, 0., 1.));
}
}