#version 150 compatibility
#extension GL_EXT_gpu_shader4: require
uniform sampler2D rnm;
uniform sampler2D InPos;
uniform sampler2D InSpd;
uniform sampler2D InColor;
uniform float Time;
uniform float GlobalGlow;
uniform int   StartOffset;
uniform float ParticalSize;
out float out_MatIndex;
out vec3  out_normal;
out vec3  out_vpos;
out vec3  out_diffuse;
out vec3  out_emission;
out vec4  out_hpos;
out vec2  out_texcoord;
float rand(vec2 co, float f)
{
return fract(sin(dot(co.xy ,vec2(12.9898,78.233) * f)) * 43758.5453);
}
mat3 AxisAngleMatrix(float angle, vec3 axis)
{
float satangle = angle * 6.282;
float c = cos(satangle);
float s = sin(satangle);
float u = 1.0 - c;
mat3 rotmat;
rotmat[0][0] = axis.x*axis.x*u + c;
rotmat[1][0] = axis.y*axis.x*u - (axis.z*s);
rotmat[2][0] = axis.z*axis.x*u + (axis.y*s);
rotmat[0][1] = axis.x*axis.y*u + (axis.z*s);
rotmat[1][1] = axis.y*axis.y*u + c;
rotmat[2][1] = axis.z*axis.y*u - (axis.x*s);
rotmat[0][2] = axis.x*axis.z*u - (axis.y*s);
rotmat[1][2] = axis.x*axis.z*u + (axis.x*s);
rotmat[2][2] = axis.z*axis.z*u + c;
return rotmat;
}
mat3 LookAt(vec3 Eye, vec3 At, vec3 Up)
{
vec3 zaxis = normalize(At - Eye);
vec3 xaxis = normalize(cross(Up, zaxis));
vec3 yaxis = cross(zaxis, xaxis);
return mat3(xaxis, yaxis, zaxis);
}
void main()
{
out_diffuse  = gl_FrontMaterial.diffuse.rgb * gl_FrontMaterial.diffuse.a ;
out_emission = gl_FrontMaterial.emission.rgb * gl_FrontMaterial.emission.a ;
out_MatIndex = gl_FrontMaterial.ambient.a;
float iScaledTime = Time * 100.;
float ScaledTime = Time * 100. / 65535.;
ivec2 MapSize = ivec2(256);
int index = (StartOffset + gl_InstanceID) % (MapSize.x * MapSize.y);
ivec2 ParticalUV = ivec2(index % MapSize.x,
index / MapSize.x);
vec3 pos   = texelFetch(InPos, ParticalUV, 0).xyz;
vec3 speed = texelFetch(InSpd, ParticalUV, 0).xyz;
out_diffuse  = vec3(0);
out_emission = texelFetch(InColor, ParticalUV, 0).rgb * GlobalGlow;
mat3 mat = LookAt(vec3(0.), -speed, vec3(0., 0., 1.));
vec4 vertex = gl_Vertex;
vertex.xyz *= ParticalSize;
vertex.z *= 8;
if (vertex.z < 0)
vertex.yx *= 0.6;
vec4 newVertex = vec4(mat * vertex.xyz, 1.);
newVertex.xyz += pos;
newVertex.xyz *= 0.01;
out_vpos = (gl_ModelViewMatrix * newVertex).xyz;
out_normal = mat * gl_Normal.xyz;
out_normal = normalize(gl_NormalMatrix * out_normal);
out_hpos = gl_Position = gl_ModelViewProjectionMatrix * newVertex;
}